/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.tree.AbstractTreeLearner;
import com.rapidminer.operator.learner.tree.DecisionTreeLeafCreator;
import com.rapidminer.operator.learner.tree.EmptyTermination;
import com.rapidminer.operator.learner.tree.MaxDepthTermination;
import com.rapidminer.operator.learner.tree.NoAttributeLeftTermination;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SingleLabelTermination;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import com.rapidminer.parameter.ParameterType;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionStumpLearner
extends AbstractTreeLearner {
    public DecisionStumpLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Pruner getPruner() throws OperatorException {
        return null;
    }

    @Override
    public List<Terminator> getTerminationCriteria(ExampleSet exampleSet) {
        LinkedList<Terminator> result = new LinkedList<Terminator>();
        result.add(new SingleLabelTermination());
        result.add(new NoAttributeLeftTermination());
        result.add(new EmptyTermination());
        result.add(new MaxDepthTermination(2));
        return result;
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (capability == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (capability == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return capability == LearnerCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        for (ParameterType type : types) {
            if (!type.getKey().equals("minimal_leaf_size")) continue;
            type.setDefaultValue(1);
        }
        return types;
    }

    @Override
    protected TreeBuilder getTreeBuilder(ExampleSet exampleSet) throws OperatorException {
        return new TreeBuilder(this.createCriterion(this.getParameterAsDouble("minimal_gain")), this.getTerminationCriteria(exampleSet), this.getPruner(), this.getSplitPreprocessing(), new DecisionTreeLeafCreator(), true, 0, this.getParameterAsInt("minimal_size_for_split"), this.getParameterAsInt("minimal_leaf_size"));
    }
}

