/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaLearner
extends OperatorChain
implements Learner {
    public AbstractMetaLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        PerformanceVector perfVector;
        AttributeWeights weights;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105, new Object[0]);
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        CapabilityCheck check = new CapabilityCheck(this, Tools.booleanValue(System.getProperty("rapidminer.general.capabilities.warn"), true));
        check.checkLearnerCapabilities(this, exampleSet);
        LinkedList<ResultObject> results = new LinkedList<ResultObject>();
        Model model = this.learn(exampleSet);
        results.add(model);
        if (this.shouldCalculateWeights() && (weights = this.getWeights(exampleSet)) != null) {
            results.add(weights);
        }
        if (this.shouldEstimatePerformance() && (perfVector = this.getEstimatedPerformance()) != null) {
            results.add(perfVector);
        }
        IOObject[] resultArray = new IOObject[results.size()];
        results.toArray(resultArray);
        return resultArray;
    }

    protected Model applyInnerLearner(ExampleSet exampleSet) throws OperatorException {
        IOContainer input = new IOContainer(exampleSet);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            input = this.getOperator(i).apply(input);
            ++i;
        }
        return input.remove(Model.class);
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        if (this.shouldEstimatePerformance()) {
            condition.addCondition(new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{PerformanceVector.class}));
        }
        if (this.shouldCalculateWeights()) {
            condition.addCondition(new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{AttributeWeights.class}));
        }
        return condition;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (this.getNumberOfOperators() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            if (this.getOperator(i) instanceof Learner) {
                return ((Learner)((Object)this.getOperator(i))).supportsCapability(capability);
            }
            ++i;
        }
        return false;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        LinkedList<Class<AttributeWeights>> classList = new LinkedList<Class<AttributeWeights>>();
        classList.add(Model.class);
        if (this.shouldEstimatePerformance()) {
            classList.add(PerformanceVector.class);
        }
        if (this.shouldCalculateWeights()) {
            classList.add(AttributeWeights.class);
        }
        Class[] result = new Class[classList.size()];
        classList.toArray(result);
        return result;
    }
}

