/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.hypothesis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.hypothesis.Literal;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends Hypothesis {
    private static final long serialVersionUID = -1121263970366784202L;
    private Literal[][] allLiterals;
    private Literal[] literals;
    private int prediction;

    public Rule(Attribute[] regularAttributes, Attribute label, boolean rejectionSampling, boolean createAll) {
        super(regularAttributes, label, rejectionSampling, createAll);
        this.allLiterals = new Literal[regularAttributes.length][];
        int attributeIndex = 0;
        while (attributeIndex < regularAttributes.length) {
            this.allLiterals[attributeIndex] = new Literal[regularAttributes[attributeIndex].getMapping().size()];
            int valueIndex = 0;
            while (valueIndex < regularAttributes[attributeIndex].getMapping().size()) {
                this.allLiterals[attributeIndex][valueIndex] = new Literal(regularAttributes[attributeIndex], valueIndex, attributeIndex);
                ++valueIndex;
            }
            ++attributeIndex;
        }
    }

    @Override
    public Hypothesis clone() {
        Rule clone = new Rule(this.literals, this.prediction);
        clone.setCoveredWeight(this.getCoveredWeight());
        clone.setPositiveWeight(this.getPositiveWeight());
        return clone;
    }

    public Rule(Literal literal, int prediction) {
        this.literals = new Literal[1];
        this.literals[0] = literal;
        this.prediction = prediction;
    }

    public Rule(Literal[] literals, int prediction) {
        this.literals = new Literal[literals.length];
        int i = 0;
        while (i < literals.length) {
            this.literals[i] = literals[i];
            ++i;
        }
        this.prediction = prediction;
    }

    @Override
    public void apply(Example e) {
        if (this.applicable(e)) {
            if (this.rejectionSampling) {
                this.coveredWeight += 1.0;
                if ((int)e.getLabel() == this.prediction) {
                    this.positiveWeight += 1.0;
                }
            } else {
                this.coveredWeight += e.getWeight();
                if ((int)e.getLabel() == this.prediction) {
                    this.positiveWeight += e.getWeight();
                }
            }
        }
    }

    @Override
    public boolean applicable(Example e) {
        boolean success = true;
        int i = 0;
        while (i < this.literals.length) {
            int ruleValue;
            int exampleValue = (int)e.getValue(this.literals[i].getAttribute());
            if (exampleValue != (ruleValue = this.literals[i].getValue())) {
                success = false;
                break;
            }
            ++i;
        }
        return success;
    }

    @Override
    public LinkedList<Hypothesis> init(int minComplexity) {
        LinkedList<Hypothesis> border = new LinkedList<Hypothesis>();
        LinkedList<Hypothesis> result = new LinkedList<Hypothesis>();
        int attributeIndex = 0;
        while (attributeIndex < this.allLiterals.length) {
            int valueIndex = 0;
            while (valueIndex < this.allLiterals[attributeIndex].length) {
                border.addLast(new Rule(this.allLiterals[attributeIndex][valueIndex], 1));
                ++valueIndex;
            }
            ++attributeIndex;
        }
        while (!border.isEmpty()) {
            Rule rule = (Rule)border.removeFirst();
            result.addLast(rule);
            if (this.createAllHypothesis) {
                result.addLast(new Rule(rule.getLiterals(), 0));
            }
            if (rule.getComplexity() >= minComplexity) continue;
            border.addAll(rule.refine());
        }
        return result;
    }

    @Override
    public LinkedList<Hypothesis> refine() {
        LinkedList<Hypothesis> result = new LinkedList<Hypothesis>();
        Literal[] lits = new Literal[this.literals.length + 1];
        int i = 0;
        while (i < this.literals.length) {
            lits[i] = this.literals[i];
            ++i;
        }
        int lastLiteralIndex = this.literals[this.literals.length - 1].getIndex();
        int literalIndex = lastLiteralIndex + 1;
        while (literalIndex < this.allLiterals.length) {
            int valueIndex = 0;
            while (valueIndex < this.allLiterals[literalIndex].length) {
                lits[lits.length - 1] = this.allLiterals[literalIndex][valueIndex];
                result.addLast(new Rule(lits, this.prediction));
                ++valueIndex;
            }
            ++literalIndex;
        }
        return result;
    }

    @Override
    public boolean canBeRefined() {
        return this.literals[this.literals.length - 1].getIndex() != this.allLiterals.length - 1;
    }

    @Override
    public int getPrediction() {
        return this.prediction;
    }

    @Override
    public int getComplexity() {
        return this.literals.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule otherRule = (Rule)o;
        if (otherRule.literals.length != this.literals.length) {
            return false;
        }
        if (otherRule.prediction != this.prediction) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < this.literals.length) {
            if (!this.literals[i].equals(otherRule.literals[i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return this.literals.hashCode() ^ Integer.valueOf(this.prediction).hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("IF ");
        int i = 0;
        while (i < this.literals.length - 1) {
            result.append(String.valueOf(this.literals[i].toString()) + " AND ");
            ++i;
        }
        result.append(this.literals[this.literals.length - 1].toString());
        result.append(" THEN (" + this.getLabel().getName() + "=" + this.getLabel().getMapping().mapIndex(this.getPrediction()) + ")");
        return result.toString();
    }

    public Literal[] getLiterals() {
        return this.literals;
    }
}

