/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.OutputTypes;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOObjectWriter
extends Operator {
    public static final String PARAMETER_OBJECT_FILE = "object_file";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_WRITE_WHICH = "write_which";
    public static final String PARAMETER_OUTPUT_TYPE = "output_type";
    public static final String PARAMETER_CONTINUE_ON_ERROR = "continue_on_error";
    private String[] objectArray = null;

    public IOObjectWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        block41: {
            Class<IOObject> clazz = this.getSelectedClass();
            if (clazz == null) break block41;
            int number = this.getParameterAsInt(PARAMETER_WRITE_WHICH);
            IOObject object = this.getInput().get(clazz, number - 1);
            File objectFile = this.getParameterAsFile(PARAMETER_OBJECT_FILE, true);
            int outputType = this.getParameterAsInt(PARAMETER_OUTPUT_TYPE);
            switch (outputType) {
                case 0: {
                    FileOutputStream out = null;
                    try {
                        try {
                            out = new FileOutputStream(objectFile);
                            object.write(out);
                        }
                        catch (IOException e) {
                            if (!this.getParameterAsBoolean(PARAMETER_CONTINUE_ON_ERROR)) {
                                throw new UserError((Operator)this, (Throwable)e, 303, objectFile, e.getMessage());
                            }
                            this.logError("Could not write IO Object to file " + objectFile + ": " + e.getMessage());
                            if (out == null) break;
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException e2) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException e) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                        }
                        throw throwable;
                    }
                    if (out == null) break;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        this.logError("Cannot close stream to file " + objectFile);
                    }
                    break;
                }
                case 1: {
                    OutputStream out = null;
                    try {
                        try {
                            out = new GZIPOutputStream(new FileOutputStream(objectFile));
                            object.write(out);
                        }
                        catch (IOException e) {
                            if (!this.getParameterAsBoolean(PARAMETER_CONTINUE_ON_ERROR)) {
                                throw new UserError((Operator)this, (Throwable)e, 303, objectFile, e.getMessage());
                            }
                            this.logError("Could not write IO Object to file " + objectFile + ": " + e.getMessage());
                            if (out == null) break;
                            try {
                                out.close();
                            }
                            catch (IOException e3) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                        }
                        throw throwable;
                    }
                    if (out == null) break;
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logError("Cannot close stream to file " + objectFile);
                    }
                    break;
                }
                case 2: {
                    ObjectOutputStream objectOut = null;
                    try {
                        try {
                            objectOut = new ObjectOutputStream(new FileOutputStream(objectFile));
                            objectOut.writeObject(object);
                        }
                        catch (IOException e) {
                            if (!this.getParameterAsBoolean(PARAMETER_CONTINUE_ON_ERROR)) {
                                throw new UserError((Operator)this, (Throwable)e, 303, objectFile, e.getMessage());
                            }
                            this.logError("Could not write IO Object to file " + objectFile + ": " + e.getMessage());
                            if (objectOut == null) break;
                            try {
                                objectOut.close();
                            }
                            catch (IOException e4) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        if (objectOut != null) {
                            try {
                                objectOut.close();
                            }
                            catch (IOException e) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                        }
                        throw throwable;
                    }
                    if (objectOut == null) break;
                    try {
                        objectOut.close();
                    }
                    catch (IOException e) {
                        this.logError("Cannot close stream to file " + objectFile);
                    }
                    break;
                }
            }
        }
        return new IOObject[0];
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.getIOObjectNames() != null) {
            return OperatorService.getIOObjectClass(this.getIOObjectNames()[ioType]);
        }
        return null;
    }

    private String[] getIOObjectNames() {
        if (this.objectArray == null) {
            Set<String> ioObjects = OperatorService.getIOObjectsNames();
            this.objectArray = ioObjects.toArray(new String[ioObjects.size()]);
        }
        return this.objectArray;
    }

    @Override
    public Class<?>[] getInputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return this.getInputClasses();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_OBJECT_FILE, "Filename of the object file.", "ioo", false));
        types.add(new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be saved.", this.getIOObjectNames(), 0));
        types.add(new ParameterTypeInt(PARAMETER_WRITE_WHICH, "Defines which input object should be written.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeCategory(PARAMETER_OUTPUT_TYPE, "Indicates the type of the output", OutputTypes.OUTPUT_TYPES, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_CONTINUE_ON_ERROR, "Defines behavior on errors", false));
        return types;
    }
}

