/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleFormatter;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.FormatterException;
import com.rapidminer.example.table.SparseFormatDataRowReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_EXAMPLE_SET_FILE = "example_set_file";
    public static final String PARAMETER_ATTRIBUTE_DESCRIPTION_FILE = "attribute_description_file";
    public static final String PARAMETER_FORMAT = "format";
    public static final String PARAMETER_SPECIAL_FORMAT = "special_format";
    public static final String PARAMETER_FRACTION_DIGITS = "fraction_digits";
    public static final String PARAMETER_QUOTE_NOMINAL_VALUES = "quote_nominal_values";
    public static final String PARAMETER_ZIPPED = "zipped";
    public static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";
    public static final String[] OVERWRITE_MODES = new String[]{"none", "overwrite first, append then", "overwrite", "append"};
    public static final int OVERWRITE_MODE_NONE = 0;
    public static final int OVERWRITE_MODE_OVERWRITE_FIRST = 1;
    public static final int OVERWRITE_MODE_OVERWRITE = 2;
    public static final int OVERWRITE_MODE_APPEND = 3;
    private static String[] formatNames = new String[SparseFormatDataRowReader.FORMAT_NAMES.length + 2];
    private static final int DENSE_FORMAT = 0;

    static {
        ExampleSetWriter.formatNames[0] = "dense";
        int i = 0;
        while (i < SparseFormatDataRowReader.FORMAT_NAMES.length) {
            ExampleSetWriter.formatNames[i + 1] = "sparse_" + SparseFormatDataRowReader.FORMAT_NAMES[i];
            ++i;
        }
        ExampleSetWriter.formatNames[ExampleSetWriter.formatNames.length - 1] = PARAMETER_SPECIAL_FORMAT;
    }

    public ExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet eSet) throws OperatorException {
        boolean zipped = this.getParameterAsBoolean(PARAMETER_ZIPPED);
        File dataFile = this.getParameterAsFile(PARAMETER_EXAMPLE_SET_FILE, true);
        if (zipped) {
            dataFile = new File(String.valueOf(dataFile.getAbsolutePath()) + ".gz");
        }
        File attFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE, true);
        boolean quoteNominal = this.getParameterAsBoolean(PARAMETER_QUOTE_NOMINAL_VALUES);
        int overwriteMode = this.getParameterAsInt(PARAMETER_OVERWRITE_MODE);
        boolean append = false;
        switch (overwriteMode) {
            case 0: {
                if (dataFile.exists()) {
                    throw new UserError(this, 100);
                }
                append = false;
                break;
            }
            case 2: {
                if (dataFile.exists()) {
                    this.log("File " + dataFile + " already exists. Overwriting...");
                }
                append = false;
                break;
            }
            case 3: {
                if (dataFile.exists()) {
                    this.log("File " + dataFile + " already exists. Appending...");
                }
                append = true;
                break;
            }
            default: {
                if (this.getApplyCount() <= 1) {
                    if (dataFile.exists()) {
                        this.log("File " + dataFile + " already exists. Overwriting this time...");
                    }
                    append = false;
                    break;
                }
                if (dataFile.exists()) {
                    this.log("File " + dataFile + " already exists. Appending...");
                }
                append = true;
            }
        }
        int fractionDigits = this.getParameterAsInt(PARAMETER_FRACTION_DIGITS);
        if (fractionDigits < 0) {
            fractionDigits = -2;
        }
        Charset encoding = this.getEncoding();
        try {
            int format = this.getParameterAsInt(PARAMETER_FORMAT);
            this.log("Writing example set in format '" + formatNames[format] + "'.");
            if (format == 0) {
                eSet.writeDataFile(dataFile, fractionDigits, quoteNominal, zipped, append, encoding);
                if (attFile != null) {
                    eSet.writeAttributeFile(attFile, dataFile, this.getEncoding());
                }
            } else if (format == formatNames.length - 1) {
                if (attFile != null) {
                    this.logError("special_format used. Ignoring attribute description file.");
                }
                this.writeSpecialFormat(eSet, dataFile, fractionDigits, quoteNominal, zipped, append, encoding);
            } else {
                eSet.writeSparseDataFile(dataFile, format - 1, fractionDigits, quoteNominal, zipped, append, encoding);
                if (attFile != null) {
                    eSet.writeSparseAttributeFile(attFile, dataFile, format - 1, encoding);
                }
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, dataFile + " / " + attFile, e.getMessage());
        }
        return eSet;
    }

    private void writeSpecialFormat(ExampleSet exampleSet, File dataFile, int fractionDigits, boolean quoteNominal, boolean zipped, boolean append, Charset encoding) throws OperatorException {
        ExampleFormatter formatter;
        String format = this.getParameterAsString(PARAMETER_SPECIAL_FORMAT);
        if (format == null) {
            throw new UserError((Operator)this, 201, PARAMETER_SPECIAL_FORMAT, PARAMETER_FORMAT, PARAMETER_SPECIAL_FORMAT);
        }
        try {
            formatter = ExampleFormatter.compile(format, exampleSet, fractionDigits, quoteNominal);
        }
        catch (FormatterException e) {
            throw new UserError((Operator)this, 901, format, e.getMessage());
        }
        OutputStream out = null;
        PrintWriter writer = null;
        try {
            try {
                out = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
                writer = new PrintWriter(new OutputStreamWriter(out, encoding));
                Iterator reader = exampleSet.iterator();
                while (reader.hasNext()) {
                    writer.println(formatter.format((Example)reader.next()));
                }
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 303, dataFile, e.getMessage());
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + dataFile);
                }
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_EXAMPLE_SET_FILE, "File to save the example set to.", "dat", false));
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE, "File to save the attribute descriptions to.", "aml", true));
        types.add(new ParameterTypeCategory(PARAMETER_FORMAT, "Format to use for output.", formatNames, 0));
        types.add(new ParameterTypeString(PARAMETER_SPECIAL_FORMAT, "Format string to use for output.", true));
        types.add(new ParameterTypeInt(PARAMETER_FRACTION_DIGITS, "The number of fraction digits in the output file (-1: all possible digits).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean(PARAMETER_QUOTE_NOMINAL_VALUES, "Indicates if nominal values should be quoted with double quotes.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_ZIPPED, "Indicates if the data file content should be zipped.", false));
        types.add(new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", OVERWRITE_MODES, 1));
        return types;
    }
}

