/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.ColorizedLineAndShapeRenderer;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.gui.plotter.charts.WeightBasedSymbolAxis;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelPlotter2
extends PlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private XYSeriesCollection dataset = null;
    private int colorColumn = -1;
    private String[] domainAxisMap = null;
    private ChartPanel panel = new ChartPanel(null);
    private JCheckBox localNormalizationBox;
    private boolean localNormalization = false;
    private JCheckBox rotateLabels = new JCheckBox("Rotate Labels", false);
    private double[] colorMap = null;

    public ParallelPlotter2() {
        this.setBackground(Color.white);
        this.localNormalizationBox = new JCheckBox("Local Normalization", this.localNormalization);
        this.localNormalizationBox.setToolTipText("Indicates if a local normalization for each dimension should be performed or not.");
        this.localNormalizationBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ParallelPlotter2.this.setLocalNormalization(ParallelPlotter2.this.localNormalizationBox.isSelected());
            }
        });
        this.rotateLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParallelPlotter2.this.updatePlotter();
            }
        });
    }

    public ParallelPlotter2(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    private static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabelFont(LABEL_FONT_BOLD);
        valueAxis.setTickLabelFont(LABEL_FONT);
        return chart;
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updatePlotter();
    }

    public void setLocalNormalization(boolean localNormalization) {
        this.localNormalization = localNormalization;
        this.updatePlotter();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 0;
    }

    public void setRotateLabels(boolean rotateLabels) {
        this.rotateLabels.setSelected(rotateLabels);
        this.updatePlotter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        DataTable c22;
        this.dataset = new XYSeriesCollection();
        int columns = this.dataTable.getNumberOfColumns();
        double[] min = new double[columns];
        double[] max = new double[columns];
        if (this.localNormalization) {
            int c22 = 0;
            while (c22 < columns) {
                min[c22] = Double.POSITIVE_INFINITY;
                max[c22] = Double.NEGATIVE_INFINITY;
                ++c22;
            }
            c22 = this.dataTable;
            synchronized (c22) {
                for (DataTableRow row : this.dataTable) {
                    int c = 0;
                    while (c < this.dataTable.getNumberOfColumns()) {
                        double value = row.getValue(c);
                        min[c] = MathFunctions.robustMin(min[c], value);
                        max[c] = MathFunctions.robustMax(max[c], value);
                        ++c;
                    }
                }
            }
        }
        this.domainAxisMap = null;
        c22 = this.dataTable;
        synchronized (c22) {
            this.colorMap = new double[this.dataTable.getNumberOfRows()];
            Iterator<DataTableRow> i = this.dataTable.iterator();
            int idCounter = 0;
            while (i.hasNext()) {
                DataTableRow row = i.next();
                String id = row.getId();
                if (id == null) {
                    id = String.valueOf(idCounter + 1);
                }
                XYSeries series = new XYSeries((Comparable)((Object)id), false, false);
                int counter = 0;
                int column = 0;
                while (column < this.dataTable.getNumberOfColumns()) {
                    if (!this.dataTable.isSpecial(column) && column != this.colorColumn) {
                        double value = row.getValue(column);
                        if (this.localNormalization) {
                            value = (value - min[column]) / (max[column] - min[column]);
                        }
                        series.add((double)counter, value);
                        ++counter;
                    }
                    ++column;
                }
                if (this.colorColumn >= 0) {
                    this.colorMap[idCounter] = row.getValue(this.colorColumn);
                }
                this.dataset.addSeries(series);
                ++idCounter;
            }
        }
        if (this.domainAxisMap == null) {
            LinkedList<String> domainValues = new LinkedList<String>();
            int counter = 0;
            int column = 0;
            while (column < this.dataTable.getNumberOfColumns()) {
                if (!this.dataTable.isSpecial(column) && column != this.colorColumn) {
                    domainValues.add(this.dataTable.getColumnName(column));
                    ++counter;
                }
                ++column;
            }
            this.domainAxisMap = new String[domainValues.size()];
            domainValues.toArray(this.domainAxisMap);
        }
    }

    public void updatePlotter() {
        this.prepareData();
        JFreeChart chart = ParallelPlotter2.createChart((XYDataset)this.dataset);
        chart.setAntiAlias(false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        SymbolAxis axis = null;
        if (this.dataTable.isSupportingColumnWeights()) {
            LinkedList<Double> weightList = new LinkedList<Double>();
            int column = 0;
            while (column < this.dataTable.getNumberOfColumns()) {
                if (!this.dataTable.isSpecial(column) && column != this.colorColumn) {
                    weightList.add(this.dataTable.getColumnWeight(column));
                }
                ++column;
            }
            double[] weights = new double[weightList.size()];
            int index = 0;
            for (Double d : weightList) {
                weights[index++] = d;
            }
            axis = new WeightBasedSymbolAxis(null, this.domainAxisMap, weights);
        } else {
            axis = new SymbolAxis(null, this.domainAxisMap);
        }
        axis.setTickLabelFont(LABEL_FONT);
        axis.setLabelFont(LABEL_FONT_BOLD);
        if (this.rotateLabels.isSelected()) {
            axis.setTickLabelsVisible(true);
            axis.setVerticalTickLabels(true);
        }
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        final ColorizedLineAndShapeRenderer renderer = new ColorizedLineAndShapeRenderer(this.colorMap);
        plot.setRenderer((XYItemRenderer)renderer);
        if (this.colorColumn >= 0 && this.dataTable.isNominal(this.colorColumn)) {
            final LegendItemCollection legendItemCollection = new LegendItemCollection();
            int i = 0;
            while (i < this.dataTable.getNumberOfValues(this.colorColumn)) {
                legendItemCollection.add(new LegendItem(this.dataTable.mapIndex(this.colorColumn, i), null, null, null, (Shape)new Rectangle2D.Double(0.0, 0.0, 7.0, 7.0), (Paint)this.getColorProvider().getPointColor((double)i / (double)(this.dataTable.getNumberOfValues(this.colorColumn) - 1)), (Stroke)new BasicStroke(0.75f), (Paint)Color.GRAY));
                ++i;
            }
            chart.addLegend(new LegendTitle(new LegendItemSource(){

                public LegendItemCollection getLegendItems() {
                    return legendItemCollection;
                }
            }));
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
        } else if (this.colorColumn >= 0) {
            chart.addLegend(new LegendTitle(new LegendItemSource(){

                public LegendItemCollection getLegendItems() {
                    LegendItemCollection itemCollection = new LegendItemCollection();
                    itemCollection.add(new LegendItem("Dummy"));
                    return itemCollection;
                }
            }){
                private static final long serialVersionUID = 1288380309936848376L;

                public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
                    if (ParallelPlotter2.this.dataTable.isDate(ParallelPlotter2.this.colorColumn) || ParallelPlotter2.this.dataTable.isTime(ParallelPlotter2.this.colorColumn) || ParallelPlotter2.this.dataTable.isDateTime(ParallelPlotter2.this.colorColumn)) {
                        ParallelPlotter2.this.drawSimpleDateLegend(g2, (int)(area.getCenterX() - 170.0), (int)(area.getCenterY() + 7.0), ParallelPlotter2.this.dataTable, ParallelPlotter2.this.colorColumn, renderer.getMinColorValue(), renderer.getMaxColorValue());
                        return new BlockResult();
                    }
                    String minColorString = Tools.formatNumber(renderer.getMinColorValue());
                    String maxColorString = Tools.formatNumber(renderer.getMaxColorValue());
                    ParallelPlotter2.this.drawSimpleNumericalLegend(g2, (int)(area.getCenterX() - 90.0), (int)(area.getCenterY() + 7.0), minColorString, maxColorString);
                    return new BlockResult();
                }

                public void draw(Graphics2D g2, Rectangle2D area) {
                    this.draw(g2, area, null);
                }
            });
        }
        if (this.panel instanceof CtrlChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.localNormalizationBox;
        }
        if (index == 1) {
            return this.rotateLabels;
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys() {
        List<ParameterType> types = super.getAdditionalParameterKeys();
        types.add(new ParameterTypeBoolean("local_normalization", "Indicates if values should be normalized for each dimension between 0 and 1.", false));
        types.add(new ParameterTypeBoolean("rotate_labels", "Indicates if the domain axis labels should be rotated.", false));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        if ("local_normalization".equals(key)) {
            boolean distinct = Tools.booleanValue(value, false);
            this.localNormalizationBox.setSelected(distinct);
        } else if ("rotate_labels".equals(key)) {
            this.setRotateLabels(Tools.booleanValue(value, false));
        }
    }
}

