/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.gui.plotter.charts.RapidHistogramDataset;
import com.rapidminer.gui.plotter.charts.RapidXYBarPainter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramChart
extends PlotterAdapter {
    private static final long serialVersionUID = 9140046811324105445L;
    public static final int MIN_BIN_NUMBER = 1;
    public static final int MAX_BIN_NUMBER = 100;
    public static final int DEFAULT_BIN_NUMBER = 40;
    protected transient DataTable dataTable;
    private HistogramDataset histogramDataset;
    private boolean[] columns = new boolean[0];
    protected int binNumber = 40;
    private boolean logScale = false;
    private boolean absolute = false;
    protected boolean drawLegend = true;
    private float opaqueness = 1.0f;
    private JCheckBox rotateLabels = new JCheckBox("Rotate Labels", false);
    private ChartPanel panel = new ChartPanel(null);

    public HistogramChart() {
        this.rotateLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistogramChart.this.updatePlotter();
            }
        });
    }

    public HistogramChart(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[this.dataTable.getNumberOfColumns()];
        this.updatePlotter();
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    public void setRotateLabels(boolean rotateLabels) {
        this.rotateLabels.setSelected(rotateLabels);
        this.updatePlotter();
    }

    public void setOpaqueness(float opaqueness) {
        this.opaqueness = opaqueness;
        this.updatePlotter();
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
        this.updatePlotter();
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    public void setBinNumber(int binNumber) {
        this.binNumber = binNumber;
        this.updatePlotter();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.columns[index] = plot;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    @Override
    public int getValuePlotSelectionType() {
        return 1;
    }

    protected int getNumberOfPlots() {
        int counter = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i]) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareData() {
        this.histogramDataset = new RapidHistogramDataset(this.isLogScale());
        if (this.getNumberOfPlots() == 0) {
            return;
        }
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            int c = 0;
            while (c < this.dataTable.getNumberOfColumns()) {
                if (this.columns[c]) {
                    double[] values = new double[this.dataTable.getNumberOfRows()];
                    int index = 0;
                    for (DataTableRow row : this.dataTable) {
                        double value = row.getValue(c);
                        if (this.absolute) {
                            value = Math.abs(value);
                        }
                        values[index++] = value;
                    }
                    this.histogramDataset.addSeries((Comparable)((Object)this.dataTable.getColumnName(c)), values, this.binNumber);
                }
                ++c;
            }
        }
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    private void updatePlotter() {
        String key;
        int index;
        int categoryCount;
        this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.colors.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Deviation plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean createLegend = (categoryCount = this.histogramDataset.getSeriesCount()) > 0 && categoryCount < maxClasses && this.drawLegend;
        JFreeChart chart = ChartFactory.createHistogram(null, (String)"Value", (String)"Frequency", (IntervalXYDataset)this.histogramDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)createLegend, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setForegroundAlpha(this.opaqueness);
        XYBarRenderer renderer = new XYBarRenderer();
        if (this.histogramDataset.getSeriesCount() == 1) {
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            int i = 0;
            while (i < this.histogramDataset.getSeriesCount()) {
                Color color = this.getColorProvider().getPointColor((double)i / (double)(this.histogramDataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
                ++i;
            }
        }
        renderer.setBarPainter((XYBarPainter)new RapidXYBarPainter());
        renderer.setDrawBarOutline(true);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        if (this.histogramDataset.getSeriesCount() == 1 && (index = this.dataTable.getColumnIndex(key = this.histogramDataset.getSeriesKey(0).toString())) >= 0 && this.dataTable.isNominal(index)) {
            String[] values = new String[this.dataTable.getNumberOfValues(index)];
            int i = 0;
            while (i < values.length) {
                values[i] = this.dataTable.mapIndex(index, i);
                ++i;
            }
            plot.setDomainAxis((ValueAxis)new SymbolAxis(key, values));
            if (this.rotateLabels.isSelected()) {
                plot.getDomainAxis().setTickLabelsVisible(true);
                plot.getDomainAxis().setVerticalTickLabels(true);
            }
        }
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(LABEL_FONT);
        }
        if (this.panel instanceof CtrlChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            final JCheckBox logScaleBox = new JCheckBox("Log Scale");
            logScaleBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HistogramChart.this.setLogScale(logScaleBox.isSelected());
                }
            });
            return logScaleBox;
        }
        if (index == 1) {
            return this.rotateLabels;
        }
        if (index == 2) {
            JLabel label = new JLabel("Number of Bins");
            label.setToolTipText("Set the number of bins which should be displayed.");
            return label;
        }
        if (index == 3) {
            final JSlider binNumberSlider = new JSlider(1, 100, 40);
            binNumberSlider.setMajorTickSpacing(99);
            binNumberSlider.setMinorTickSpacing(9);
            binNumberSlider.setPaintTicks(true);
            binNumberSlider.setPaintLabels(true);
            binNumberSlider.setToolTipText("Set the number of bins which should be displayed.");
            binNumberSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!binNumberSlider.getValueIsAdjusting()) {
                        HistogramChart.this.setBinNumber(binNumberSlider.getValue());
                    }
                }
            });
            return binNumberSlider;
        }
        if (index == 4) {
            JLabel label = new JLabel("Opaqueness");
            label.setToolTipText("Sets the amount of opaqueness / transparency.");
            return label;
        }
        if (index == 5) {
            final JSlider opaquenessSlider = new JSlider(0, 100, (int)(this.opaqueness * 100.0f));
            opaquenessSlider.setPaintTicks(true);
            opaquenessSlider.setPaintLabels(true);
            opaquenessSlider.setToolTipText("Set the amount of opaqueness / transparency.");
            opaquenessSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!opaquenessSlider.getValueIsAdjusting()) {
                        HistogramChart.this.setOpaqueness((float)opaquenessSlider.getValue() / 100.0f);
                    }
                }
            });
            return opaquenessSlider;
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys() {
        List<ParameterType> types = super.getAdditionalParameterKeys();
        types.add(new ParameterTypeBoolean("log_scale", "Indicates if the bin heights should be transformed with logarithm base 10.", false));
        types.add(new ParameterTypeInt("number_of_bins", "The number of bins for each histogram.", 1, 100, 40));
        types.add(new ParameterTypeDouble("opaqueness", "Indicates the opaqueness / transparency of the bins.", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeBoolean("rotate_labels", "Indicates if the domain axis labels should be rotated.", false));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        if ("log_scale".equals(key)) {
            this.setLogScale(Tools.booleanValue(value, false));
        } else if ("number_of_bins".equals(key)) {
            try {
                int number = Integer.parseInt(value);
                this.setBinNumber(number);
            }
            catch (NumberFormatException number) {}
        } else if ("opaqueness".equals(key)) {
            try {
                float opaqueness = Float.parseFloat(value);
                this.setOpaqueness(opaqueness);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("rotate_labels".equals(key)) {
            this.setRotateLabels(Tools.booleanValue(value, false));
        }
    }
}

