/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.test;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.test.ExampleTestTools;
import com.rapidminer.test.RapidMinerTestCase;

public class DataRowTest
extends RapidMinerTestCase {
    private Attribute[] attributes;
    private double[] expected;

    public void setUp() throws Exception {
        super.setUp();
        this.attributes = ExampleTestTools.createFourAttributes();
        this.expected = new double[]{1.0, Double.NaN, 5.0, 2.3};
    }

    public void tearDown() throws Exception {
        this.attributes = null;
        this.expected = null;
        super.tearDown();
    }

    private void assertDataRow(String message, DataRow dataRow, double[] expected) {
        int i = 0;
        while (i < expected.length) {
            this.assertEqualsNaN(String.valueOf(message) + " " + this.attributes[i].getName(), expected[i], dataRow.get(this.attributes[i]));
            ++i;
        }
    }

    private void objectTest(String message, DataRowFactory factory) {
        Object[] objectArray = new Object[4];
        objectArray[0] = "cat";
        objectArray[2] = 5;
        objectArray[3] = 2.3;
        DataRow dataRow = factory.create(objectArray, this.attributes);
        this.assertDataRow(String.valueOf(message) + " object", dataRow, this.expected);
    }

    private void stringTest(String message, DataRowFactory factory) {
        DataRow dataRow = factory.create(new String[]{"cat", "?", "5", "2.3"}, this.attributes);
        this.assertDataRow(String.valueOf(message) + " string", dataRow, this.expected);
    }

    public void testDoubleArrayStrings() {
        this.objectTest("double_array", new DataRowFactory(0, '.'));
    }

    public void testDoubleArrayObjects() {
        this.stringTest("double_array", new DataRowFactory(0, '.'));
    }

    public void testSparseMapStrings() {
        this.stringTest("sparse_map", new DataRowFactory(14, '.'));
    }

    public void testSparseMapObjects() {
        this.objectTest("sparse_map", new DataRowFactory(14, '.'));
    }
}

