/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeTransformation;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.AttributeTransformationReplaceMissing;
import com.rapidminer.example.set.AttributesExampleReader;
import com.rapidminer.example.table.ExampleTable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceMissingExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = -5662936146589379273L;
    private Map<String, Double> replacementMap;
    private ExampleSet parent;

    public ReplaceMissingExampleSet(ExampleSet exampleSet) {
        this(exampleSet, null);
    }

    public ReplaceMissingExampleSet(ExampleSet exampleSet, Map<String, Double> replacementMap) {
        this.parent = (ExampleSet)exampleSet.clone();
        if (replacementMap == null) {
            this.replacementMap = new HashMap<String, Double>();
            for (Attribute attribute : this.parent.getAttributes()) {
                this.addReplacement(attribute);
            }
        } else {
            this.replacementMap = replacementMap;
        }
        Iterator<AttributeRole> a = this.parent.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute currentAttribute = role.getAttribute();
            currentAttribute.addTransformation(new AttributeTransformationReplaceMissing(this.replacementMap));
        }
    }

    public ReplaceMissingExampleSet(ReplaceMissingExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.replacementMap = new HashMap<String, Double>();
        for (String name : exampleSet.replacementMap.keySet()) {
            this.replacementMap.put(name, (double)exampleSet.replacementMap.get(name));
        }
        Iterator<AttributeRole> a = this.parent.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute currentAttribute = role.getAttribute();
            AttributeTransformation transformation = currentAttribute.getLastTransformation();
            if (transformation == null || !(transformation instanceof AttributeTransformationReplaceMissing)) continue;
            ((AttributeTransformationReplaceMissing)transformation).setReplacementMap(this.replacementMap);
        }
    }

    public Map<String, Double> getReplacementMap() {
        return this.replacementMap;
    }

    public void addReplacement(Attribute attribute) {
        this.recalculateAttributeStatistics(attribute);
        if (attribute.isNominal()) {
            this.replacementMap.put(attribute.getName(), this.getStatistics(attribute, "mode"));
        } else {
            this.replacementMap.put(attribute.getName(), this.getStatistics(attribute, "average"));
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ReplaceMissingExampleSet)) {
            return false;
        }
        boolean result = super.equals(o);
        if (result) {
            Map<String, Double> otherMap = ((ReplaceMissingExampleSet)o).replacementMap;
            if (this.replacementMap.size() != otherMap.size()) {
                return false;
            }
            for (String name : this.replacementMap.keySet()) {
                if (this.replacementMap.get(name).equals(otherMap.get(name))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.replacementMap.hashCode();
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return this.parent.getExample(index);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }
}

