/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.DataTableKernelModelAdapter;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;

public class KernelModelRow2DataTableRowWrapper
implements DataTableRow {
    static final String[] SPECIAL_COLUMN_NAMES = new String[]{"counter", "label", "function value", "alpha", "abs(alpha)", "support vector"};
    public static final int COUNTER = 0;
    public static final int LABEL = 1;
    public static final int FUNCTION_VALUE = 2;
    public static final int ALPHA = 3;
    public static final int ABS_ALPHA = 4;
    public static final int SUPPORT_VECTOR = 5;
    public static final int NUMBER_OF_SPECIAL_COLUMNS = 6;
    private KernelModel kernelModel;
    private DataTableKernelModelAdapter adapter;
    private int index;

    public KernelModelRow2DataTableRowWrapper(KernelModel kernelModel, DataTableKernelModelAdapter adapter, int index) {
        this.kernelModel = kernelModel;
        this.adapter = adapter;
        this.index = index;
    }

    public String getId() {
        return this.kernelModel.getId(this.index);
    }

    public int getNumberOfValues() {
        return this.kernelModel.getNumberOfAttributes() + 6;
    }

    public double getValue(int column) {
        switch (column) {
            case 0: {
                return this.index;
            }
            case 1: {
                if (this.kernelModel.isClassificationModel()) {
                    String label = this.kernelModel.getClassificationLabel(this.index);
                    return this.adapter.mapString(1, label);
                }
                return this.kernelModel.getRegressionLabel(this.index);
            }
            case 2: {
                return this.kernelModel.getFunctionValue(this.index);
            }
            case 3: {
                return this.kernelModel.getAlpha(this.index);
            }
            case 4: {
                return Math.abs(this.kernelModel.getAlpha(this.index));
            }
            case 5: {
                return Math.abs(this.kernelModel.getAlpha(this.index)) != 0.0 ? 1 : 0;
            }
        }
        return this.kernelModel.getAttributeValue(this.index, column - 6);
    }
}

