/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.check;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.gcube.accounting.analytics.Filter;
import org.gcube.common.quota.check.QuotaCheck;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.util.QuotaUsageServiceValue;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaUsage {
    private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertServiceQuota(QuotaUsageServiceValue usageSerVal) throws SQLException {
        String context_label = usageSerVal.getContext().replace('/', '_').toUpperCase();
        Statement stmt = null;
        try (Connection connection = this.getDBConnection();){
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String periodQuota = usageSerVal.getTemporalConstraint().getAggregationMode().toString();
            if (!this.verifyTable(connection, "QUOTAUSAGE_SERVICE_" + context_label + "_" + periodQuota).booleanValue()) {
                String queryCreate = "CREATE TABLE QUOTAUSAGE_SERVICE_" + context_label + "_" + periodQuota + "" + "(CALLERTYPE varchar(255),IDENTIFIER varchar(255) ,SERVICE varchar(255)," + "ACCESSTYPE varchar(50),QUOTAASSIGNED double, QUOTAUSAGE double,POLICY integer," + "primary key(CALLERTYPE,IDENTIFIER,SERVICE))";
                stmt.execute(queryCreate);
            }
            String serviceIdentifier = "";
            for (Filter tmp : usageSerVal.getFilters()) {
                serviceIdentifier = serviceIdentifier + tmp.getValue() + ":";
            }
            serviceIdentifier = serviceIdentifier + "0";
            String queryInsert = "REPLACE into QUOTAUSAGE_SERVICE_" + context_label + "_" + periodQuota + "" + " (CALLERTYPE,IDENTIFIER, SERVICE,ACCESSTYPE,QUOTAASSIGNED, QUOTAUSAGE)  VALUES('" + usageSerVal.getCallerType() + "'," + "'" + usageSerVal.getIdentifier() + "','" + serviceIdentifier + "'," + "'" + usageSerVal.getAccessType() + "'," + usageSerVal.getdQuota() + "," + usageSerVal.getD() + ")";
            log.debug("Insert data into table:{}", (Object)queryInsert);
            stmt.execute(queryInsert);
            stmt.close();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStorageQuota(QuotaUsageStorageValue usageStorVal) throws SQLException {
        Statement stmt = null;
        try (Connection connection = this.getDBConnection();){
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String periodQuota = "TOTAL";
            if (usageStorVal.getTemporalConstraint() != null) {
                periodQuota = usageStorVal.getTemporalConstraint().getAggregationMode().toString();
            }
            if (!this.verifyTable(connection, "QUOTAUSAGE_STORAGE_" + periodQuota).booleanValue()) {
                String queryCreate = "CREATE TABLE QUOTAUSAGE_STORAGE_" + periodQuota + "" + "(IDENTIFIER varchar(255) primary key,QUOTAASSIGNED double, QUOTAUSAGE double)";
                log.debug("Create table:{}", (Object)queryCreate);
                stmt.execute(queryCreate);
            }
            String queryInsert = "REPLACE into QUOTAUSAGE_STORAGE_" + periodQuota + "" + " (IDENTIFIER, QUOTAASSIGNED, QUOTAUSAGE)  VALUES('" + usageStorVal.getIdentifier() + "'," + usageStorVal.getdQuota() + "," + usageStorVal.getD() + ")";
            log.debug("Insert data into table:{}", (Object)queryInsert);
            stmt.execute(queryInsert);
            stmt.close();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaStorageStatus selectStorageQuota(String identifier, TimeInterval interval) throws SQLException {
        Connection connection = this.getDBConnection();
        QuotaStorageStatus quotaStorageStatus = null;
        Statement stmt = null;
        try {
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String periodQuota = "TOTAL";
            Double quotaAssigned = 0.0;
            Double quotaUsage = 0.0;
            if (interval.equals((Object)TimeInterval.FOREVER)) {
                String query = "SELECT * FROM QUOTAUSAGE_STORAGE_" + periodQuota + "" + " WHERE IDENTIFIER='" + identifier + "'";
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    quotaAssigned = rs.getDouble("QUOTAASSIGNED");
                    quotaUsage = rs.getDouble("QUOTAUSAGE");
                }
            }
            stmt.close();
            connection.commit();
            quotaStorageStatus = new QuotaStorageStatus(identifier, interval, quotaAssigned, quotaUsage);
        }
        catch (SQLException e) {
            log.error("Exception Message " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection.close();
        }
        return quotaStorageStatus;
    }

    private Connection getDBConnection() {
        Connection dbConnection = null;
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        try {
            dbConnection = DriverManager.getConnection("jdbc:h2:~/DbQuota;", "sa", "");
            return dbConnection;
        }
        catch (SQLException e) {
            log.error("Exception Message " + e.getMessage());
            return dbConnection;
        }
    }

    private Boolean verifyTable(Connection connection, String tableName) throws SQLException {
        log.trace("verifyTable :{}", (Object)tableName);
        boolean tExists = false;
        try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName, null);){
            try {
                while (rs.next()) {
                    String tName = rs.getString("TABLE_NAME");
                    if (tName == null || !tName.equals(tableName)) continue;
                    tExists = true;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return tExists;
    }
}

