/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.check;

import java.sql.SQLException;
import org.gcube.common.quota.check.QuotaCalculateUtil;
import org.gcube.common.quota.defaults.InformationSystemQuery;
import org.gcube.common.quota.service.exception.NotFoundQuotaExecption;
import org.gcube.common.quota.util.DiscoveryListUser;
import org.gcube.common.quota.util.ReadFileProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCheck {
    private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
    private String context = null;

    public QuotaCheck(String context) throws NotFoundQuotaExecption {
        this.context = context;
    }

    public void getQuotaCheck() throws SQLException {
        log.info("QuotaCheck - init quota check task");
        QuotaCalculateUtil quotaUtility = new QuotaCalculateUtil(this.context);
        InformationSystemQuery informationSystemQuery = new InformationSystemQuery();
        log.debug("QuotaCheck - context:{}, setQuoteDefault:{}", (Object)this.context, (Object)informationSystemQuery.getListQuotaDefault());
        quotaUtility.setQuoteDefault(informationSystemQuery.getListQuotaDefault());
        if (quotaUtility.getQuoteDefault() == null) {
            log.debug("QuotaCheck - No quota default found on IS");
            ReadFileProperties fileQuota = new ReadFileProperties("/tmp/quota.xml");
            quotaUtility.setQuoteDefault(fileQuota.getListQuotaDefault());
        }
        DiscoveryListUser discoveryListUser = new DiscoveryListUser(this.context);
        log.debug("QuotaCheck - for context:{} , list user:{}", (Object)this.context, (Object)discoveryListUser.getListUser());
        quotaUtility.verifyListUser(discoveryListUser.getListUser());
        log.debug("QuotaCheck - quotaUtility.getUsageToBeVerified():{}", (Object)quotaUtility.getUsageToBeVerified());
    }
}

