/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.check;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.quota.check.QuotaCheck;
import org.gcube.common.quota.library.quotalist.Quota;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.ServiceQuota;
import org.gcube.common.quota.library.quotalist.StorageQuota;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.quotedefault.QuotaDefault;
import org.gcube.common.quota.library.quotedefault.StorageQuotaDefault;
import org.gcube.common.quota.persistence.QuotaDBPersistence;
import org.gcube.common.quota.persistence.QuotaPackageDBPersistence;
import org.gcube.common.quota.service.exception.NotFoundQuotaPackageExecption;
import org.gcube.common.quota.util.QuotaUsageServiceValue;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCalculateUtil {
    private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
    private QuotaDBPersistence quotaPersistence = QuotaDBPersistence.getInstance();
    private List<QuotaDefault> quoteDefault = null;
    private String context;
    private QuotaPackageDBPersistence quotaPackagePersistence = QuotaPackageDBPersistence.getInstance();
    private List<UsageValue> usageToBeVerified = new ArrayList();

    public void setQuoteDefault(List<QuotaDefault> quoteDefault) {
        this.quoteDefault = quoteDefault;
    }

    public List<QuotaDefault> getQuoteDefault() {
        return this.quoteDefault;
    }

    public List<UsageValue> getUsageToBeVerified() {
        return this.usageToBeVerified;
    }

    public QuotaCalculateUtil(String context) {
        this.context = context;
    }

    public void verifyListUser(List<String> listUser) {
        for (String identifier : listUser) {
            log.trace("verify for user:{} in context:{},if have a no default quota", (Object)identifier, (Object)this.context);
            for (QuotaDefault quotaDefault : this.quoteDefault) {
                Quota quotaSpecified = null;
                quotaSpecified = this.quotaPersistence.getQuotaSpecified(identifier, this.context, quotaDefault.getQuotaType(), quotaDefault.getTimeInterval(), quotaDefault.getQuotaValue());
                if (quotaSpecified == null) {
                    log.debug("identifier:{} used quota default for quota type:{}-{}-", new Object[]{identifier, quotaDefault.getQuotaType(), QuotaType.STORAGE.toString()});
                    if (quotaDefault.getQuotaType() == QuotaType.STORAGE) {
                        log.debug("identifier:{} used quota STORAGE", (Object)identifier);
                        StorageQuotaDefault quotaDefaultStorage = (StorageQuotaDefault)quotaDefault;
                        quotaSpecified = new StorageQuota(this.context, identifier, quotaDefaultStorage.getCallerType(), quotaDefaultStorage.getTimeInterval(), quotaDefaultStorage.getQuotaValue());
                    }
                }
                try {
                    log.debug("add quota into list for accounting usage value" + quotaSpecified.toString());
                    this.AddList(quotaSpecified);
                }
                catch (NotFoundQuotaPackageExecption e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void AddList(Quota quota) throws NotFoundQuotaPackageExecption {
        TimeInterval interval = quota.getTimeInterval();
        QuotaType type = quota.getQuotaType();
        Class clz = type.getQuotaTypeClass();
        log.debug("time interval get Value:{}", (Object)interval.getValue());
        TemporalConstraint temporalConstraint = null;
        if (interval.getValue() == 0) {
            log.debug("definito arco temporale da sempre");
        } else {
            Calendar endTime = Calendar.getInstance();
            Calendar startTime = Calendar.getInstance();
            startTime.add(5, -interval.getValue());
            temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), interval.getAggregationMode());
        }
        ArrayList filtersList = null;
        if (quota.getQuotaType().equals((Object)QuotaType.SERVICE)) {
            filtersList = new ArrayList();
            ServiceQuota quotaService = (ServiceQuota)quota;
            String serviceIdentifier = quotaService.getServiceId();
            String[] parts = serviceIdentifier.split(":");
            String serviceClass = parts[0];
            String serviceName = parts[1];
            String serviceId = parts[2];
            ArrayList<Filter> filters = new ArrayList<Filter>();
            filters.add(new Filter("serviceClass", serviceClass));
            filters.add(new Filter("serviceName", serviceName));
            QuotaUsageServiceValue totalFilterQuota = new QuotaUsageServiceValue(quotaService.getContext(), quotaService.getIdentifier(), clz, temporalConstraint, filters);
            totalFilterQuota.setdQuota(quotaService.getQuotaValue());
            totalFilterQuota.setCallerType(quotaService.getCallerType());
            totalFilterQuota.setAccessType(quotaService.getAccessType());
            log.debug("totalfilter:{}", (Object)totalFilterQuota.toString());
            this.usageToBeVerified.add(totalFilterQuota);
        } else {
            QuotaUsageStorageValue totalFilterQuota = new QuotaUsageStorageValue(quota.getContext(), quota.getIdentifier(), clz, temporalConstraint);
            totalFilterQuota.setdQuota(quota.getQuotaValue());
            log.debug("totalfilter:{}", (Object)totalFilterQuota.toString());
            this.usageToBeVerified.add(totalFilterQuota);
        }
    }

    public void insertPolicyBlock(Quota quotaBlocked) {
        log.info("Quota Execed insert a policy :{}", (Object)quotaBlocked.toString());
        String token = null;
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(quotaBlocked.getContext(), new ArrayList()), quotaBlocked.getContext());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        SecurityTokenProvider.instance.set(token);
        ArrayList policies = new ArrayList();
        if (quotaBlocked.getQuotaType().equals((Object)QuotaType.SERVICE)) {
            // empty if block
        }
        if (quotaBlocked.getQuotaType().equals((Object)QuotaType.STORAGE)) {
            // empty if block
        }
        try {
            log.debug("insert policy for quota:" + ((Object)policies).toString());
            Constants.authorizationService().addPolicies(policies);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

