/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.check;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.FiltersValue;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageServiceValue;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.policies.Action;
import org.gcube.common.authorization.library.policies.Roles;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.policies.User2ServicePolicy;
import org.gcube.common.authorization.library.policies.UserEntity;
import org.gcube.common.authorization.library.policies.Users;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.quota.check.QuotaCheck;
import org.gcube.common.quota.library.quotalist.CallerType;
import org.gcube.common.quota.library.quotalist.Quota;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.ServicePackage;
import org.gcube.common.quota.library.quotalist.ServicePackageDetail;
import org.gcube.common.quota.library.quotalist.ServiceQuota;
import org.gcube.common.quota.library.quotalist.StorageQuota;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.quotedefault.QuotaDefault;
import org.gcube.common.quota.library.quotedefault.ServiceQuotaDefault;
import org.gcube.common.quota.library.quotedefault.StorageQuotaDefault;
import org.gcube.common.quota.persistence.QuotaDBPersistence;
import org.gcube.common.quota.persistence.QuotaPackageDBPersistence;
import org.gcube.common.quota.service.exception.NotFoundQuotaPackageExecption;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCalculateUtil {
    private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
    private QuotaDBPersistence quotaPersistence = QuotaDBPersistence.getInstance();
    private List<QuotaDefault> quoteDefault = null;
    private String context;
    private QuotaPackageDBPersistence quotaPackagePersistence = QuotaPackageDBPersistence.getInstance();
    private List<UsageValue> usageToBeVerified = new ArrayList();

    public void setQuoteDefault(List<QuotaDefault> quoteDefault) {
        this.quoteDefault = quoteDefault;
    }

    public List<QuotaDefault> getQuoteDefault() {
        return this.quoteDefault;
    }

    public List<UsageValue> getUsageToBeVerified() {
        return this.usageToBeVerified;
    }

    public QuotaCalculateUtil(String context) {
        this.context = context;
    }

    public void verifyListUser(List<String> listUser) {
        for (String identifier : listUser) {
            for (QuotaDefault quotaDefault : this.quoteDefault) {
                Quota quotaSpecified = null;
                quotaSpecified = this.quotaPersistence.getQuotaSpecified(identifier, this.context, quotaDefault.getQuotaType(), quotaDefault.getTimeInterval(), quotaDefault.getQuotaValue());
                if (quotaSpecified == null) {
                    log.debug("identifier:{} used quota default for quota type:{}-{}-", new Object[]{identifier, quotaDefault.getQuotaType(), QuotaType.STORAGE.toString()});
                    if (quotaDefault.getQuotaType() == QuotaType.SERVICE) {
                        log.debug("identifier:{} used quota SERVICE", (Object)identifier);
                        ServiceQuotaDefault quotaDefaultService = (ServiceQuotaDefault)quotaDefault;
                        quotaSpecified = new ServiceQuota(this.context, identifier, quotaDefaultService.getCallerType(), quotaDefaultService.getTimeInterval(), quotaDefaultService.getQuotaValue(), quotaDefaultService.getAccessType());
                    }
                    if (quotaDefault.getQuotaType() == QuotaType.STORAGE) {
                        log.debug("identifier:{} used quota STORAGE", (Object)identifier);
                        StorageQuotaDefault quotaDefaultStorage = (StorageQuotaDefault)quotaDefault;
                        quotaSpecified = new StorageQuota(this.context, identifier, quotaDefaultStorage.getCallerType(), quotaDefaultStorage.getTimeInterval(), quotaDefaultStorage.getQuotaValue());
                    }
                }
                try {
                    log.debug("add quota into list for accounting usage value" + quotaSpecified.toString());
                    this.AddList(quotaSpecified);
                }
                catch (NotFoundQuotaPackageExecption e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void AddList(Quota quota) throws NotFoundQuotaPackageExecption {
        TimeInterval interval = quota.getTimeInterval();
        QuotaType type = quota.getQuotaType();
        Class clz = type.getQuotaTypeClass();
        log.debug("time interval get Value:{}", (Object)interval.getValue());
        TemporalConstraint temporalConstraint = null;
        if (interval.getValue() == 0) {
            log.debug("definito arco temporale da sempre");
        } else {
            Calendar endTime = Calendar.getInstance();
            Calendar startTime = Calendar.getInstance();
            startTime.add(5, -interval.getValue());
            temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), interval.getAggregationMode());
        }
        ArrayList<FiltersValue> filtersList = null;
        if (quota.getQuotaType().equals((Object)QuotaType.SERVICE)) {
            filtersList = new ArrayList<FiltersValue>();
            ServiceQuota quotaService = (ServiceQuota)quota;
            Long servicePackgeId = quotaService.getServicePackageId();
            try {
                ServicePackage servicepackage = this.quotaPackagePersistence.getPackage(servicePackgeId.longValue());
                for (ServicePackageDetail servicePackageDetail : servicepackage.getServicesPackageDetail()) {
                    FiltersValue filters = new FiltersValue();
                    ArrayList<Filter> filterList = new ArrayList<Filter>();
                    String contentService = servicePackageDetail.getContent();
                    String[] serviceFilter = contentService.split(":");
                    String serviceClass = serviceFilter[0];
                    filterList.add(new Filter("serviceClass", serviceClass));
                    if (serviceFilter.length > 1) {
                        String serviceName = serviceFilter[1];
                        filterList.add(new Filter("serviceName", serviceName));
                    }
                    filters.setFiltersValue(filterList);
                    filtersList.add(filters);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            UsageServiceValue totalFilter = new UsageServiceValue(quota.getContext(), quota.getIdentifier(), clz, temporalConstraint, filtersList);
            this.usageToBeVerified.add(totalFilter);
        } else {
            QuotaUsageStorageValue totalFilterQuota = new QuotaUsageStorageValue(quota.getContext(), quota.getIdentifier(), clz, temporalConstraint);
            totalFilterQuota.setdQuota(quota.getQuotaValue());
            log.debug("totalfilter:{}", (Object)totalFilterQuota.toString());
            this.usageToBeVerified.add(totalFilterQuota);
        }
    }

    public void insertPolicyBlock(Quota quotaBlocked) {
        log.info("Quota Execed insert a policy :{}", (Object)quotaBlocked.toString());
        String token = null;
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(quotaBlocked.getContext(), new ArrayList()), quotaBlocked.getContext());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        SecurityTokenProvider.instance.set(token);
        ArrayList<User2ServicePolicy> policies = new ArrayList<User2ServicePolicy>();
        if (quotaBlocked.getQuotaType().equals((Object)QuotaType.SERVICE)) {
            ServiceQuota quotaService = (ServiceQuota)quotaBlocked;
            Action access = Action.valueOf((String)quotaService.getAccessType().toString());
            Long servicePackgeId = quotaService.getServicePackageId();
            try {
                ServicePackage servicepackage = this.quotaPackagePersistence.getPackage(servicePackgeId.longValue());
                for (ServicePackageDetail servicePackageDetail : servicepackage.getServicesPackageDetail()) {
                    String contentService = servicePackageDetail.getContent();
                    String[] serviceFilter = contentService.split(":");
                    String serviceClass = serviceFilter[0];
                    String serviceName = "*";
                    if (serviceFilter.length > 1) {
                        serviceName = serviceFilter[1];
                    }
                    String serviceId = "*";
                    ServiceAccess service = new ServiceAccess(serviceName, serviceClass, serviceId);
                    log.info("Quota Execed caller type :{}", (Object)quotaBlocked.getCallerType());
                    log.info("Quota Execed caller type string :{}", (Object)quotaBlocked.getCallerType().toString());
                    if (quotaBlocked.getCallerType().equals((Object)CallerType.USER)) {
                        log.debug("add policy with user" + quotaBlocked.toString());
                        policies.add(new User2ServicePolicy(quotaBlocked.getContext(), service, (UserEntity)Users.one((String)quotaBlocked.getIdentifier()), access));
                    }
                    if (!quotaBlocked.getCallerType().equals((Object)CallerType.ROLE)) continue;
                    log.debug("add policy with role" + quotaBlocked.toString());
                    policies.add(new User2ServicePolicy(quotaBlocked.getContext(), service, (UserEntity)Roles.one((String)quotaBlocked.getIdentifier()), access));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (quotaBlocked.getQuotaType().equals((Object)QuotaType.STORAGE)) {
            // empty if block
        }
        try {
            log.debug("insert policy for quota:" + ((Object)policies).toString());
            Constants.authorizationService().addPolicies(policies);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

