/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.queueManager.impl;

import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.queueManager.ConsumerFactory;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.QueueItemHandler;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.MultiSyncConsumer;
import org.gcube.common.queueManager.impl.QueueConsumer;
import org.gcube.common.queueManager.utils.Common;

public class QueueConsumerFactory
implements ConsumerFactory {
    private static QueueConsumerFactory instance = null;
    private ConcurrentHashMap<QueueType, ActiveMQConnectionFactory> factories = new ConcurrentHashMap();
    private FactoryConfiguration config = null;

    public static synchronized QueueConsumerFactory get(FactoryConfiguration configuration) throws JMSException {
        if (instance == null) {
            instance = new QueueConsumerFactory(configuration);
        }
        return instance;
    }

    private QueueConsumerFactory(FactoryConfiguration configuration) throws JMSException {
        this.config = configuration;
    }

    private synchronized ActiveMQConnectionFactory getFactory(QueueType type) throws JMSException {
        if (!this.factories.containsKey((Object)type)) {
            ActiveMQConnectionFactory toSet = null;
            switch (type) {
                case LOG: {
                    toSet = new ActiveMQConnectionFactory(this.config.getUser(), this.config.getPassword(), this.config.getBrokerEndpoint());
                    break;
                }
                default: {
                    toSet = new ActiveMQConnectionFactory(this.config.getUser(), this.config.getPassword(), this.config.getBrokerEndpoint());
                }
            }
            this.factories.put(type, toSet);
        }
        return this.factories.get((Object)type);
    }

    public QueueConsumer register(String topic, QueueType type, QueueItemHandler callback) throws JMSException {
        ActiveMQConnectionFactory factory = this.getFactory(type);
        TopicSession session = null;
        TopicConnection connection = null;
        switch (type) {
            case LOG: {
                connection = factory.createTopicConnection();
                connection.setClientID(callback.toString());
                connection.start();
                session = connection.createTopicSession(false, 1);
                break;
            }
            default: {
                connection = factory.createQueueConnection();
                connection.setClientID(callback.toString());
                connection.start();
                session = ((QueueConnection)connection).createQueueSession(false, 2);
            }
        }
        topic = Common.formTopic(this.config.getServiceClass(), this.config.getServiceName(), type, topic);
        QueueConsumer toReturn = new QueueConsumer(callback, (Session)session, (Connection)connection);
        switch (type) {
            case LOG: {
                TopicSubscriber subscriber = session.createDurableSubscriber(session.createTopic(topic), connection.getClientID());
                subscriber.setMessageListener(toReturn);
                break;
            }
            default: {
                QueueReceiver consumer = ((QueueSession)session).createReceiver(session.createQueue(topic));
                consumer.setMessageListener(toReturn);
            }
        }
        return toReturn;
    }

    public MultiSyncConsumer getMultiSyncConsumer(QueueType type) throws JMSException, Exception {
        if (type.equals((Object)QueueType.LOG)) {
            throw new Exception("QueueType not allowed for synchronous consumption");
        }
        ActiveMQConnectionFactory factory = this.getFactory(type);
        return new MultiSyncConsumer((Connection)factory.createQueueConnection(), this.config.getServiceClass(), this.config.getServiceName(), type);
    }

    public void close() {
    }
}

