/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.gcube.common.Utils;
import org.gcube.common.data.Header;
import org.gcube.common.data.Record;
import org.gcube.common.data.RecordIterator;
import org.gcube.common.repository.Identify;
import org.gcube.common.repository.MetadataFormat;
import org.gcube.common.repository.ResumptionToken;
import org.gcube.common.repository.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Harvester {
    private static Logger log = LoggerFactory.getLogger(Harvester.class);
    private String baseUrl;
    private String identifiersResumptionToken = "";
    private String setResumptionToken = "";
    private boolean hasIdentifierResumptionToken = false;
    private boolean hasSetResumptionToken = false;

    public Harvester(String baseUrl) throws Exception {
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new Exception("baseUrl cannot be null");
        }
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Identify identify() throws Exception {
        OMElement documentElement = null;
        try {
            documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "Identify");
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        Iterator it = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "Identify"));
        it.hasNext();
        Iterator identifyElements = ((OMElement)it.next()).getChildElements();
        Identify identify = new Identify();
        while (identifyElements.hasNext()) {
            OMElement eleme = (OMElement)identifyElements.next();
            if (eleme.getLocalName().equals("repositoryName")) {
                identify.setRepositoryName(eleme.getText());
                continue;
            }
            if (eleme.getLocalName().equals("protocolVersion")) {
                identify.setProtocolVersion(eleme.getText());
                continue;
            }
            if (eleme.getLocalName().equals("baseURL")) {
                identify.setBaseUrl(eleme.getText());
                continue;
            }
            if (eleme.getLocalName().equals("earliestDatestamp")) {
                identify.setEarliestDateStamp(eleme.getText());
                continue;
            }
            if (eleme.getLocalName().equals("deletedRecord")) {
                identify.setDeletedRecord(eleme.getText());
                continue;
            }
            if (eleme.getLocalName().equals("granularity")) {
                identify.setGranularity(eleme.getText());
                continue;
            }
            if (!eleme.getLocalName().equals("adminEmail")) continue;
            identify.addAdminEmail(eleme.getText());
        }
        return identify;
    }

    public List<Header> listIdentifiers(String from, String until, String set, String metadataPrefix) throws Exception {
        ArrayList<Header> listIdentifiers = new ArrayList();
        List<Header> tmpListIdentifiers = null;
        listIdentifiers = this.listIdentifiers("", from, until, set, metadataPrefix);
        if (this.hasIdentifierResumptionToken) {
            while (!this.identifiersResumptionToken.isEmpty()) {
                tmpListIdentifiers = this.listIdentifiers(this.identifiersResumptionToken, null, null, null, metadataPrefix);
                for (Header h : tmpListIdentifiers) {
                    listIdentifiers.add(h);
                }
            }
        }
        return listIdentifiers;
    }

    public List<Header> listIdentifiers(String metadataPrefix) throws Exception {
        ArrayList<Header> listIdentifiers = new ArrayList();
        List<Header> tmpListIdentifiers = null;
        listIdentifiers = this.listIdentifiers("", null, null, null, metadataPrefix);
        if (this.hasIdentifierResumptionToken) {
            while (!this.identifiersResumptionToken.isEmpty()) {
                tmpListIdentifiers = this.listIdentifiers(this.identifiersResumptionToken, null, null, null, metadataPrefix);
                for (Header h : tmpListIdentifiers) {
                    listIdentifiers.add(h);
                }
            }
        }
        return listIdentifiers;
    }

    private List<Header> listIdentifiers(String resumptionToken, String from, String until, String set, String metadataPrefix) throws Exception {
        OMElement documentElement = null;
        ArrayList<Header> recordHeaderList = new ArrayList<Header>();
        if (metadataPrefix == null) {
            metadataPrefix = "oai_dc";
        }
        try {
            if (this.identifiersResumptionToken.isEmpty()) {
                if (from == null && until == null && set == null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix);
                } else if (from != null && until == null && set == null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&from=" + from);
                } else if (from == null && until != null && set == null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&until=" + from);
                } else if (from == null && until == null && set != null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&set=" + set);
                } else if (from != null && until != null && set == null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&from=" + from + "&until=" + until);
                } else if (from != null && until != null && set != null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&from=" + from + "&until=" + until + "&set=" + set);
                } else if (from == null && until != null && set != null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&until=" + until + "&set=" + set);
                } else if (from != null && until == null && set != null) {
                    documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=" + metadataPrefix + "&from=" + from + "&set=" + set);
                }
            } else {
                documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&resumptionToken=" + resumptionToken);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        Iterator getRecordError = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "error"));
        if (getRecordError.hasNext()) {
            Utils.sendException((OMElement)getRecordError.next());
            return null;
        }
        Iterator getIdentifiers = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "ListIdentifiers"));
        getIdentifiers.hasNext();
        Iterator getHeaders = ((OMElement)getIdentifiers.next()).getChildElements();
        while (getHeaders.hasNext()) {
            OMElement head = (OMElement)getHeaders.next();
            Iterator getHeaderContent = head.getChildElements();
            Header header = new Header();
            if (head.getLocalName().equals("header")) {
                while (getHeaderContent.hasNext()) {
                    OMElement headerContent = (OMElement)getHeaderContent.next();
                    if (headerContent.getLocalName().equals("identifier")) {
                        header.setIdentifier(headerContent.getText());
                        continue;
                    }
                    if (headerContent.getLocalName().equals("datestamp")) {
                        header.setDatestamp(headerContent.getText());
                        continue;
                    }
                    if (!headerContent.getLocalName().equals("setSpec")) continue;
                    header.addSpec(headerContent.getText());
                }
                this.identifiersResumptionToken = "";
            } else if (head.getLocalName().equals("resumptionToken")) {
                this.hasIdentifierResumptionToken = true;
                this.identifiersResumptionToken = head.getText();
                continue;
            }
            recordHeaderList.add(header);
        }
        return recordHeaderList;
    }

    public List<MetadataFormat> listMetadataFormats() throws Exception {
        return this.listMetadataFormats("");
    }

    public List<MetadataFormat> listMetadataFormats(String identifier) throws Exception {
        OMElement documentElement = null;
        try {
            documentElement = !identifier.isEmpty() ? Utils.getReaderFromHttpGet(this.baseUrl, "ListMetadataFormats&identifier=" + identifier) : Utils.getReaderFromHttpGet(this.baseUrl, "ListMetadataFormats");
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        Iterator getRecordError = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "error"));
        if (getRecordError.hasNext()) {
            Utils.sendException((OMElement)getRecordError.next());
            return null;
        }
        ArrayList<MetadataFormat> metadataFormatList = new ArrayList<MetadataFormat>();
        Iterator listMetadataFormats = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "ListMetadataFormats"));
        listMetadataFormats.hasNext();
        Iterator metadataFormats = ((OMElement)listMetadataFormats.next()).getChildElements();
        while (metadataFormats.hasNext()) {
            Iterator metaContent = ((OMElement)metadataFormats.next()).getChildElements();
            MetadataFormat metadataFormat = new MetadataFormat();
            while (metaContent.hasNext()) {
                OMElement contentElement = (OMElement)metaContent.next();
                if (contentElement.getLocalName().equals("metadataPrefix")) {
                    metadataFormat.setMetadataPrefix(contentElement.getText());
                    continue;
                }
                if (contentElement.getLocalName().equals("schema")) {
                    metadataFormat.setSchema(contentElement.getText());
                    continue;
                }
                if (!contentElement.getLocalName().equals("metadataNamespace")) continue;
                metadataFormat.setMetadataNamespace(contentElement.getText());
            }
            metadataFormatList.add(metadataFormat);
        }
        return metadataFormatList;
    }

    public List<Set> listSets() throws Exception {
        ArrayList<Set> listSets = new ArrayList();
        List<Set> tmpSetList = null;
        listSets = this.listSets("");
        if (this.hasSetResumptionToken) {
            while (!this.setResumptionToken.isEmpty()) {
                tmpSetList = this.listSets(this.setResumptionToken);
                for (Set s : tmpSetList) {
                    listSets.add(s);
                }
            }
        }
        return listSets;
    }

    private List<Set> listSets(String resumptionToken) throws Exception {
        OMElement documentElement = null;
        ArrayList<Set> setList = new ArrayList<Set>();
        try {
            documentElement = this.setResumptionToken.isEmpty() ? Utils.getReaderFromHttpGet(this.baseUrl, "ListSets") : Utils.getReaderFromHttpGet(this.baseUrl, "ListSets&resumptionToken=" + resumptionToken);
        }
        catch (Exception e) {
            throw new Exception("error!" + e.getMessage());
        }
        Iterator getRecordError = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "error"));
        if (getRecordError.hasNext()) {
            Utils.sendException((OMElement)getRecordError.next());
            return null;
        }
        Iterator listSets = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "ListSets"));
        listSets.hasNext();
        Iterator sets = ((OMElement)listSets.next()).getChildElements();
        while (sets.hasNext()) {
            OMElement setEl = (OMElement)sets.next();
            Iterator setContent = setEl.getChildElements();
            Set set = new Set();
            if (setEl.getLocalName().equals("set")) {
                while (setContent.hasNext()) {
                    OMElement contentElement = (OMElement)setContent.next();
                    if (contentElement.getLocalName().equals("setSpec")) {
                        set.setSetSpec(contentElement.getText());
                        continue;
                    }
                    if (!contentElement.getLocalName().equals("setName")) continue;
                    set.setSetName(contentElement.getText());
                }
                this.setResumptionToken = "";
            } else if (setEl.getLocalName().equals("resumptionToken")) {
                this.hasSetResumptionToken = true;
                this.setResumptionToken = setEl.getText();
                continue;
            }
            setList.add(set);
        }
        return setList;
    }

    public Record getRecord(String identifier, String metadataPrefix) throws Exception {
        Iterator record;
        OMElement documentElement = null;
        if (metadataPrefix == null) {
            metadataPrefix = "oai_dc";
        }
        try {
            documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "GetRecord&identifier=" + identifier + "&metadataPrefix=" + metadataPrefix);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        Iterator getRecordError = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "error"));
        if (getRecordError.hasNext()) {
            Utils.sendException((OMElement)getRecordError.next());
            return null;
        }
        Record nrecord = null;
        Iterator getRecord = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "GetRecord"));
        if (getRecord.hasNext() && (record = ((OMElement)getRecord.next()).getChildElements()).hasNext()) {
            OMElement recordElement = (OMElement)record.next();
            nrecord = Utils.getRecord(recordElement);
            nrecord.setMetadataPrefix(metadataPrefix);
        }
        return nrecord;
    }

    public RecordIterator listRecords(String from, String until, String set, String metadataPrefix) throws Exception {
        RecordIterator rec = null;
        try {
            rec = new RecordIterator("", from, until, set, metadataPrefix, this.baseUrl);
        }
        catch (Exception e) {
            log.error("Error listing records from " + this.baseUrl, (Throwable)e);
        }
        return rec;
    }

    public RecordIterator listRecords(String metadataPrefix) throws FileNotFoundException, Exception {
        RecordIterator rec = null;
        try {
            rec = new RecordIterator("", null, null, null, metadataPrefix, this.baseUrl);
        }
        catch (Exception e) {
            log.error("Error listing records from " + this.baseUrl, (Throwable)e);
        }
        return rec;
    }

    public RecordIterator listRecords(String metadataPrefix, String resumptionToken) throws FileNotFoundException, Exception {
        RecordIterator rec = null;
        try {
            rec = new RecordIterator(resumptionToken, null, null, null, metadataPrefix, this.baseUrl);
        }
        catch (Exception e) {
            log.error("Error listing records from " + this.baseUrl, (Throwable)e);
        }
        return rec;
    }

    public ResumptionToken getResumptionToken() throws Exception {
        ResumptionToken resumptionToken = new ResumptionToken();
        OMElement documentElement = null;
        try {
            documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListIdentifiers&metadataPrefix=oai_dc");
        }
        catch (Exception e) {
            throw new Exception("error!" + e.getMessage());
        }
        Iterator getRecordError = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "error"));
        if (getRecordError.hasNext()) {
            Utils.sendException((OMElement)getRecordError.next());
        }
        Iterator listSets = documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "ListIdentifiers"));
        listSets.hasNext();
        Iterator resup = ((OMElement)listSets.next()).getChildElements();
        while (resup.hasNext()) {
            OMElement resuptionElement = (OMElement)resup.next();
            if (!resuptionElement.getLocalName().equals("resumptionToken")) continue;
            Iterator resumptionContent = resuptionElement.getAllAttributes();
            while (resumptionContent.hasNext()) {
                OMAttribute contentElement = (OMAttribute)resumptionContent.next();
                if (contentElement.getLocalName().equals("completeListSize")) {
                    resumptionToken.setCompleteListSize(contentElement.getAttributeValue());
                    continue;
                }
                if (contentElement.getLocalName().equals("cursor")) {
                    resumptionToken.setCursor(contentElement.getAttributeValue());
                    continue;
                }
                if (!contentElement.getLocalName().equals("expirationDate")) continue;
                resumptionToken.setExpirationDate(contentElement.getAttributeValue());
            }
        }
        return resumptionToken;
    }
}

