/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.metadataprofilediscovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.gcube.common.metadataprofilediscovery.MetadataProfileDiscovery;
import org.gcube.common.metadataprofilediscovery.bean.MetadataProfile;
import org.gcube.common.metadataprofilediscovery.jaxb.MetadataFormat;
import org.gcube.common.metadataprofilediscovery.jaxb.NamespaceCategory;
import org.gcube.common.metadataprofilediscovery.reader.MetadataFormatDiscovery;
import org.gcube.common.metadataprofilediscovery.reader.MetadataFormatReader;
import org.gcube.common.metadataprofilediscovery.reader.NamespaceCategoryReader;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataProfileReader
implements MetadataProfileDiscovery {
    public static final String URL_OF_GCDCMETADATAPROFILEV3_XSD = "https://wiki.gcube-system.org/images_gcube/e/e8/Gcdcmetadataprofilev3.xsd";
    private static String SCHEMA_FILENAME = "Gdcmetadataprofilev3.xsd";
    private MetadataFormatDiscovery medataFormatDiscovery;
    private ScopeBean scope;
    private Map<String, MetadataFormat> hashMetadataFormats = null;
    private List<NamespaceCategory> namespaceCategories = null;
    private String profileSchema = null;
    private String grMetadataProfileSecondaryType;
    private static Logger logger = LoggerFactory.getLogger(MetadataProfileReader.class);

    public MetadataProfileReader(String grMetadataProfileSecondaryType) throws Exception {
        if (grMetadataProfileSecondaryType == null || grMetadataProfileSecondaryType.isEmpty()) {
            throw new NullPointerException("Invalid input parameter");
        }
        this.grMetadataProfileSecondaryType = grMetadataProfileSecondaryType;
        String scopeString = ScopeProvider.instance.get();
        logger.debug("Read scope " + scopeString + " from ScopeProvider");
        if (scopeString == null || scopeString.isEmpty()) {
            throw new Exception("Please set a valid scope into ScopeProvider");
        }
        this.scope = new ScopeBean(scopeString);
        this.readNamespaces();
        this.readMetadataFormats();
    }

    private void readMetadataFormats() throws Exception {
        this.medataFormatDiscovery = new MetadataFormatDiscovery(this.scope, this.grMetadataProfileSecondaryType);
        logger.info("MedataFormatDiscovery has retrieved: " + this.medataFormatDiscovery.getMetadataProfiles().size() + " metadata type/s");
        logger.debug("filling cache for MedataFormat");
        this.hashMetadataFormats = new HashMap<String, MetadataFormat>(this.medataFormatDiscovery.getMetadataProfiles().size());
        for (MetadataProfile mT : this.medataFormatDiscovery.getMetadataProfiles()) {
            if (mT == null) continue;
            MetadataFormatReader reader = new MetadataFormatReader(this.scope, mT.getId());
            this.hashMetadataFormats.put(mT.getId(), reader.getMetadataFormat());
            logger.debug("MetadataType id: " + mT.getId() + " cached as: " + reader.getMetadataFormat());
        }
    }

    private void readNamespaces() {
        try {
            if (this.namespaceCategories == null || this.namespaceCategories.isEmpty()) {
                if (this.namespaceCategories == null) {
                    this.namespaceCategories = new ArrayList<NamespaceCategory>();
                }
                NamespaceCategoryReader rd = new NamespaceCategoryReader(this.scope);
                this.namespaceCategories.addAll(rd.getNamespaces().getNamespaceCategories());
            }
        }
        catch (Exception e) {
            logger.debug("An error occurred during read namespaces for categories: ", (Throwable)e);
        }
    }

    public static String getProfileSchemaString() {
        InputStream inputStream = MetadataProfileReader.getProfileSchemaInputStream();
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
    }

    public static InputStream getProfileSchemaInputStream() {
        try {
            logger.info("Trying to return the URL resource: https://wiki.gcube-system.org/images_gcube/e/e8/Gcdcmetadataprofilev3.xsd");
            return new URL(URL_OF_GCDCMETADATAPROFILEV3_XSD).openStream();
        }
        catch (Exception e) {
            logger.warn("Error on reading the URL: https://wiki.gcube-system.org/images_gcube/e/e8/Gcdcmetadataprofilev3.xsd");
            logger.info("Returning local resource: " + SCHEMA_FILENAME);
            return MetadataProfileReader.class.getResourceAsStream(SCHEMA_FILENAME);
        }
    }

    public static URL getProfileSchemaURL() {
        try {
            logger.info("Trying to return the URL object: https://wiki.gcube-system.org/images_gcube/e/e8/Gcdcmetadataprofilev3.xsd");
            return new URL(URL_OF_GCDCMETADATAPROFILEV3_XSD);
        }
        catch (Exception e) {
            logger.warn("Error on reading the URL: https://wiki.gcube-system.org/images_gcube/e/e8/Gcdcmetadataprofilev3.xsd");
            logger.info("Returning local URL of: " + SCHEMA_FILENAME);
            return MetadataProfileReader.class.getResource(SCHEMA_FILENAME);
        }
    }

    static void validateAgainstXSD(Source xml, URL xsd) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsd);
        Validator validator = schema.newValidator();
        validator.validate(xml);
    }

    public static void validateProfile(InputStream xml) throws Exception {
        MetadataProfileReader.validateAgainstXSD(new StreamSource(xml), MetadataProfileReader.getProfileSchemaURL());
    }

    @Override
    public MetadataFormat getMetadataFormatForMetadataProfile(MetadataProfile profile) throws Exception {
        if (profile == null) {
            throw new Exception("Input " + MetadataProfile.class.getSimpleName() + " is null");
        }
        MetadataFormat format = this.hashMetadataFormats.get(profile.getId());
        if (format != null) {
            return format;
        }
        MetadataFormatReader reader = new MetadataFormatReader(this.scope, profile.getId());
        return reader.getMetadataFormat();
    }

    @Override
    public List<MetadataProfile> getListOfMetadataProfiles() throws Exception {
        if (this.medataFormatDiscovery == null) {
            this.readMetadataFormats();
        }
        return this.medataFormatDiscovery.getMetadataProfiles();
    }

    @Override
    public List<NamespaceCategory> getListOfNamespaceCategories() throws Exception {
        if (this.namespaceCategories == null) {
            this.readNamespaces();
        }
        return this.namespaceCategories;
    }

    @Override
    public void resetMetadataProfile() {
        this.medataFormatDiscovery = null;
        this.hashMetadataFormats = null;
    }

    @Override
    public void resetNamespaceCategories() {
        this.namespaceCategories = null;
    }

    @Override
    public String getProfileSchema() {
        if (this.profileSchema == null) {
            this.profileSchema = MetadataProfileReader.getProfileSchemaString();
        }
        return this.profileSchema;
    }

    @Override
    public void validateProfile(String xmlProfile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(xmlProfile)));
        DOMSource source = new DOMSource(doc);
        MetadataProfileReader.validateAgainstXSD(source, MetadataProfileReader.getProfileSchemaURL());
    }

    public static MetadataFormat toMetadataFormat(InputStream metadataProfileStream) throws JAXBException {
        if (metadataProfileStream == null) {
            throw new NullPointerException("Invalid input parameter");
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetadataFormat.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        return (MetadataFormat)jaxbUnmarshaller.unmarshal(metadataProfileStream);
    }
}

