/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;

public class DefaultItemManager
implements ItemManagerClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultItemManager(ProxyDelegate<WebTarget> config) {
        this.delegate = config;
    }

    @Override
    public List<? extends Item> getChildren(final String id, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("children");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StreamDescriptor download(final String id) {
        Call<WebTarget, StreamDescriptor> call = new Call<WebTarget, StreamDescriptor>(){

            public StreamDescriptor call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("download");
                Invocation.Builder builder = myManager.request(new String[]{"application/octet-stream"});
                Response resp = builder.get();
                InputStream stream = (InputStream)resp.readEntity(InputStream.class);
                String disposition = resp.getHeaderString("Content-Disposition");
                String fileName = disposition.replaceFirst("attachment; filename = ([^/s]+)?", "$1");
                return new StreamDescriptor(stream, fileName);
            }
        };
        try {
            StreamDescriptor result = (StreamDescriptor)this.delegate.make((Call)call);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

