/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.util.IndentedVisitor;

public class ScopeHomesComparator
extends IndentedVisitor {
    protected boolean verbose = true;
    protected boolean failOnWorkspaceDifference = false;

    public ScopeHomesComparator() {
    }

    public ScopeHomesComparator(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean compareScopes(String scope1, String scope2, HomeManagerFactory factory) throws InternalErrorException, WorkspaceFolderNotFoundException, HomeNotFoundException {
        HomeManager manager1 = factory.getHomeManager();
        HomeManager manager2 = factory.getHomeManager();
        return this.compareHomeManager(manager1, manager2);
    }

    public boolean compareHomeManager(HomeManager manager1, HomeManager manager2) throws InternalErrorException, WorkspaceFolderNotFoundException, HomeNotFoundException {
        boolean bl;
        List<User> users1 = manager1.getUsers();
        List<User> users2 = manager2.getUsers();
        boolean sameCardinality = users1.size() == users2.size();
        LinkedHashMap<String, Workspace> user_wa1 = new LinkedHashMap<String, Workspace>();
        for (User user : users1) {
            String login = user.getPortalLogin();
            Workspace wa = manager1.getHome(user).getWorkspace();
            user_wa1.put(login, wa);
        }
        LinkedHashMap<String, Workspace> user_wa2 = new LinkedHashMap<String, Workspace>();
        for (User user : users2) {
            String login = user.getPortalLogin();
            Workspace wa = manager2.getHome(user).getWorkspace();
            user_wa2.put(login, wa);
        }
        boolean bl2 = true;
        for (Map.Entry entry : user_wa1.entrySet()) {
            if (user_wa2.containsKey(entry.getKey())) {
                if (this.verbose) {
                    this.println((String)entry.getKey());
                }
                Workspace wa1 = (Workspace)entry.getValue();
                Workspace wa2 = (Workspace)user_wa2.get(entry.getKey());
                this.indent();
                WorkspaceFolder root1 = wa1.getRoot();
                WorkspaceFolder root2 = wa2.getRoot();
                boolean compare = this.compareWorkspaceItem(root1, root2);
                bl &= compare;
                this.outdent();
                this.println((String)entry.getKey() + " >> " + compare);
            } else {
                this.println((String)entry.getKey() + ": not found in scope " + manager2 + " skipping");
                bl = false;
            }
            if (bl || !this.failOnWorkspaceDifference) continue;
            return false;
        }
        return bl && sameCardinality;
    }

    public boolean compareWorkspaceItem(WorkspaceItem item1, WorkspaceItem item2) throws InternalErrorException {
        if (this.verbose) {
            this.indent();
        }
        boolean equals = true;
        equals &= item1.getName().equals(item2.getName());
        equals &= item1.getType().equals((Object)item2.getType());
        if (this.verbose) {
            this.println(equals + " : " + item1.getName());
        }
        LinkedHashMap<String, WorkspaceItem> children1 = new LinkedHashMap<String, WorkspaceItem>();
        for (WorkspaceItem workspaceItem : item1.getChildren()) {
            children1.put(workspaceItem.getName(), workspaceItem);
        }
        LinkedHashMap<String, WorkspaceItem> children2 = new LinkedHashMap<String, WorkspaceItem>();
        for (WorkspaceItem workspaceItem : item2.getChildren()) {
            children2.put(workspaceItem.getName(), workspaceItem);
        }
        for (Map.Entry entry : children1.entrySet()) {
            if (children2.containsKey(entry.getKey())) {
                WorkspaceItem child2 = (WorkspaceItem)children2.get(entry.getKey());
                equals &= this.compareWorkspaceItem((WorkspaceItem)entry.getValue(), child2);
            } else {
                equals = false;
                if (this.verbose) {
                    this.println("not found : " + (String)entry.getKey());
                }
            }
            if (equals || !this.failOnWorkspaceDifference) continue;
            break;
        }
        if (this.verbose) {
            this.outdent();
        }
        return equals;
    }
}

