/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtil {
    protected static Logger logger = LoggerFactory.getLogger(WorkspaceUtil.class);
    private static final String READ_ONLY = "jcr:read";
    private static final String WRITE_OWNER = "jcr:write";
    private static final String WRITE_ALL = "hl:writeAll";
    private static final String ADMINISTRATOR = "jcr:all";

    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = null;
        try {
            name = folder.getUniqueName(initialName, false);
        }
        catch (Exception e) {
            logger.error("Impossibile to get an unique name for filename " + initialName);
        }
        if (name == null) {
            name = initialName;
        }
        return name;
    }

    public static String getCopyName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = null;
        try {
            name = folder.getUniqueName(initialName, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = initialName;
        }
        return name;
    }

    public static String returnThreeDigitNo(int number) {
        String threeDigitNo = null;
        int length = String.valueOf(number).length();
        if (length == 1) {
            threeDigitNo = "00" + number;
        }
        if (length == 2) {
            threeDigitNo = "0" + number;
        }
        if (length == 3) {
            threeDigitNo = "" + number;
        }
        return threeDigitNo;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String storageId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, storageId);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, String storageId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, storageId, mimeType);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String storageId, Map<String, String> properties) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, storageId, properties);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String storageId, Map<String, String> properties, String mimeType, long size) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, storageId, properties, mimeType, size);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, is);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, is, null, mimeType, 0L);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, InputStream is, Map<String, String> properties) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, is, properties);
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, InputStream is, Map<String, String> properties, String mimeType, long size) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        return destinationFolder.createExternalGenericItem(name, description, is, properties, mimeType, size);
    }

    public static ACLType getACLTypeByKey(List<String> list) throws InternalErrorException {
        if (list.size() > 0) {
            switch (list.get(0)) {
                case "jcr:read": {
                    return ACLType.READ_ONLY;
                }
                case "jcr:write": {
                    return ACLType.WRITE_OWNER;
                }
                case "hl:writeAll": {
                    return ACLType.WRITE_ALL;
                }
                case "jcr:all": {
                    return ACLType.ADMINISTRATOR;
                }
            }
            return ACLType.READ_ONLY;
        }
        throw new InternalErrorException("ACL type not retrieved");
    }

    public static List<String> getMembersByGroup(String id) throws InternalErrorException {
        UserManager um = HomeLibrary.getHomeManagerFactory().getUserManager();
        GCubeGroup group = null;
        List<String> members = null;
        try {
            group = um.getGroup(id);
            members = group.getMembers();
        }
        catch (Exception e) {
            throw new InternalErrorException(id + " is not a valid groupId", e);
        }
        return members;
    }
}

