/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.MimeTypeUtil;

public class WorkspaceUtil {
    private static final String READ_ONLY = "jcr:read";
    private static final String WRITE_OWNER = "jcr:write";
    private static final String WRITE_ALL = "hl:writeAll";
    private static final String ADMINISTRATOR = "jcr:all";

    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        String name = folder.getNames(initialName, folder);
        return name;
    }

    public static String getCopyName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        List<WorkspaceItem> children = folder.getChildren();
        LinkedList<String> names = new LinkedList<String>();
        for (WorkspaceItem item : children) {
            try {
                names.add(item.getName());
            }
            catch (Exception e) {}
        }
        String name = initialName;
        int i = 1;
        while (names.contains(name)) {
            name = i == 1 ? initialName + "(copy)" : initialName + "(copy " + i + ")";
            ++i;
        }
        return name;
    }

    public static String returnThreeDigitNo(int number) {
        String threeDigitNo = null;
        int length = String.valueOf(number).length();
        if (length == 1) {
            threeDigitNo = "00" + number;
        }
        if (length == 2) {
            threeDigitNo = "0" + number;
        }
        if (length == 3) {
            threeDigitNo = "" + number;
        }
        return threeDigitNo;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        try {
            File tmpFile = null;
            if (mimeType == null) {
                tmpFile = WorkspaceUtil.getTmpFile(is);
                try (FileInputStream tmpIs = null;){
                    tmpIs = new FileInputStream(tmpFile);
                    mimeType = MimeTypeUtil.getMimeType(name, tmpIs);
                    is = new FileInputStream(tmpFile);
                }
            }
            String mimeTypeChecked = mimeType;
            if (tmpFile != null) {
                tmpFile.delete();
            }
            if (mimeTypeChecked != null) {
                if (mimeTypeChecked.startsWith("image")) {
                    return destinationFolder.createExternalImageItem(name, description, mimeTypeChecked, is);
                }
                if (mimeTypeChecked.equals("application/pdf")) {
                    return destinationFolder.createExternalPDFFileItem(name, description, mimeTypeChecked, is);
                }
                if (mimeTypeChecked.equals("text/uri-list")) {
                    return destinationFolder.createExternalUrlItem(name, description, is);
                }
                return destinationFolder.createExternalFileItem(name, description, mimeTypeChecked, is);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return destinationFolder.createExternalFileItem(name, description, mimeType, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTmpFile(InputStream in) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempfile", ".tmp");
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }

    public static ACLType getACLTypeByKey(List<String> list) {
        switch (list.get(0)) {
            case "jcr:read": {
                return ACLType.READ_ONLY;
            }
            case "jcr:write": {
                return ACLType.WRITE_OWNER;
            }
            case "hl:writeAll": {
                return ACLType.WRITE_ALL;
            }
            case "jcr:all": {
                return ACLType.ADMINISTRATOR;
            }
        }
        return ACLType.READ_ONLY;
    }
}

