/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.consistency.statistics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;

public class WorkspaceCheckStatistics {
    protected int checkedItems = 0;
    protected int errors = 0;
    protected int folders = 0;
    protected Map<FolderItemType, Integer> folderItemTypesCount = new LinkedHashMap<FolderItemType, Integer>();

    public void increaseFolderItems(FolderItemType type) {
        ++this.checkedItems;
        if (!this.folderItemTypesCount.containsKey(type)) {
            this.folderItemTypesCount.put(type, new Integer(1));
        } else {
            int count = this.folderItemTypesCount.get(type);
            this.folderItemTypesCount.put(type, ++count);
        }
    }

    public void increaseErrors() {
        ++this.errors;
    }

    public void increaseFolders() {
        ++this.folders;
    }

    public int getCheckedItems() {
        return this.checkedItems;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFolders() {
        return this.folders;
    }

    public Map<FolderItemType, Integer> getFolderItemTypesCount() {
        return this.folderItemTypesCount;
    }
}

