/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.unittest.workspace.test;

import java.io.IOException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.gcube.common.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.common.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.common.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestCloneMethods
extends AbstractWorkspaceTest {
    public WorkspaceTestCloneMethods(WorkspaceFactory factory) {
        super(factory);
    }

    @Test
    public final void testCloneItemFolderItem() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        TestDataFactory.getInstance().fillPDFDocuments(root, 1);
        WorkspaceItem item = (WorkspaceItem)root.getChildren().get(0);
        String expectedName = "TestItemClone";
        WorkspaceItem clone = this.ownerWorkspace.cloneItem(item.getId(), expectedName);
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)clone.getName());
        WorkspaceItem findClone = this.ownerWorkspace.getItem(clone.getId());
        Assert.assertNotNull((String)"Find clone null", (Object)findClone);
        UnitTestUtil.testCopy(item, clone, false);
        UnitTestUtil.testRelationship(item, (WorkspaceItem)root);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCloneItemDuplicateItem() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder", "A test Folder");
        String expectedName = "TestFolder";
        this.ownerWorkspace.cloneItem(folder.getId(), expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCloneItemIllegalCharInNameArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder1", "A test Folder");
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "WorkspaceClone";
        this.ownerWorkspace.cloneItem(folder.getId(), expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCloneItemNullItemIdArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String expectedName = "TestFolderClone";
        this.ownerWorkspace.cloneItem(null, expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCloneItemNullNameArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder2", "A test Folder");
        String expectedName = null;
        this.ownerWorkspace.cloneItem(folder.getId(), expectedName);
    }

    @Test
    public final void testCloneItemFolder() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder3", "A test Folder");
        String expectedName = "TestFolderClone";
        WorkspaceItem clone = this.ownerWorkspace.cloneItem(folder.getId(), expectedName);
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)clone.getName());
        WorkspaceItem findClone = this.ownerWorkspace.getItem(clone.getId());
        Assert.assertNotNull((String)"Find clone null", (Object)findClone);
        UnitTestUtil.testCopy((WorkspaceItem)folder, clone, false);
        UnitTestUtil.testRelationship(clone, (WorkspaceItem)root);
    }

    @Test
    public final void testCloneItemFolderTree() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, IOException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = UnitTestUtil.getFolderTree(root, "TestFolderTree");
        String expectedName = "TestFolderClone1";
        WorkspaceItem clone = this.ownerWorkspace.cloneItem(folder.getId(), expectedName);
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)clone.getName());
        WorkspaceItem findClone = this.ownerWorkspace.getItem(clone.getId());
        Assert.assertNotNull((String)"Find clone null", (Object)findClone);
        UnitTestUtil.testCopy((WorkspaceItem)folder, clone, false);
        UnitTestUtil.testTreeRelationship(clone, (WorkspaceItem)root);
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testCloneItemWrongItemIdArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String expectedName = "TestFolderClone";
        this.ownerWorkspace.cloneItem("", expectedName);
    }
}

