/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;

public class WorkspaceUtil {
    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        List<WorkspaceItem> children = folder.getChildren();
        LinkedList<String> names = new LinkedList<String>();
        for (WorkspaceItem item : children) {
            try {
                names.add(item.getName());
            }
            catch (Exception e) {}
        }
        String name = initialName;
        int i = 0;
        while (names.contains(name)) {
            name = initialName.trim() + "(" + i + ")";
            ++i;
        }
        return name;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        String mimeTypeChecked = mimeType;
        if (mimeTypeChecked != null) {
            if (mimeTypeChecked.startsWith("image")) {
                return destinationFolder.createExternalImageItem(name, description, mimeTypeChecked, is);
            }
            if (mimeTypeChecked.equals("application/pdf")) {
                return destinationFolder.createExternalPDFFileItem(name, description, mimeTypeChecked, is);
            }
            if (mimeTypeChecked.equals("text/uri-list")) {
                return destinationFolder.createExternalUrlItem(name, description, is);
            }
            return destinationFolder.createExternalFileItem(name, description, mimeTypeChecked, is);
        }
        return destinationFolder.createExternalFileItem(name, description, mimeType, is);
    }

    public static File getTmpFile(InputStream in) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempfile", ".tmp");
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tempFile;
    }
}

