/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.testdata;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.testdata.TestDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataManager<T, D> {
    protected Logger logger = LoggerFactory.getLogger(AbstractDataManager.class);
    protected XStream xstream;
    protected Random random;
    protected List<T> data;

    public AbstractDataManager(String dataListFile) {
        this.configureXStream();
        this.random = new Random();
        this.data = this.loadData(dataListFile);
    }

    protected abstract void configureXStream();

    protected List<T> loadData(String dataListFile) {
        String dataListPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + dataListFile;
        this.logger.debug("Loading the data list from: " + dataListPath);
        InputStream dataList = TestDataFactory.class.getResourceAsStream(dataListPath);
        List data = (List)this.xstream.fromXML(dataList);
        this.logger.trace("Loaded " + data.size() + " test data.");
        return data;
    }

    protected abstract D fillData(WorkspaceFolder var1, T var2) throws InternalErrorException;

    public List<D> fillDatas(WorkspaceFolder destinationFolder, int numberOfData) throws InternalErrorException {
        LinkedList<D> externals = new LinkedList<D>();
        for (int counter = 0; counter < numberOfData; ++counter) {
            int dataIndex = counter % this.data.size();
            T image = this.data.get(dataIndex);
            D external = this.fillData(destinationFolder, image);
            externals.add(external);
        }
        return externals;
    }

    public List<D> fillAllDatas(WorkspaceFolder destinationFolder) throws InternalErrorException {
        LinkedList<D> externals = new LinkedList<D>();
        for (T image : this.data) {
            D external = this.fillData(destinationFolder, image);
            externals.add(external);
        }
        return externals;
    }
}

