/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.client;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.homelibrary.client.FTPFile;
import org.gcube.common.homelibrary.client.JUnitTest;
import org.gcube.common.homelibrary.client.servlet.Servlets;
import org.junit.Assert;

public class FTPClient {
    private String currentPath = "/Share/042efb85-240b-4a04-93d3-bca3924b7503";

    public String currentDirectory() throws Exception {
        if (this.currentPath == null || !this.currentPath.contains("/Share/042efb85-240b-4a04-93d3-bca3924b7503")) {
            throw new Exception("current directory not set");
        }
        return this.currentPath;
    }

    public void changeDirectory(String path) throws Exception {
        if (!this.exists(path)) {
            throw new Exception(String.valueOf(path) + " does not exist");
        }
        this.currentPath = String.valueOf(this.currentDirectory()) + File.separator + path;
    }

    private boolean exists(String dir) {
        try {
            Servlets.listFolder(String.valueOf(this.currentDirectory()) + File.separator + dir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void changeDirectoryUp() throws Exception {
        String path = this.currentDirectory().substring(0, this.currentDirectory().lastIndexOf(File.separator));
        if (!path.contains("/Share/042efb85-240b-4a04-93d3-bca3924b7503")) {
            throw new Exception("Operation not Allowed");
        }
        this.currentPath = path;
    }

    public void deleteFile(String path) throws Exception {
        this.deleteDirectory(path);
    }

    public void deleteDirectory(String path) throws Exception {
        String dir = String.valueOf(this.currentDirectory()) + File.separator + path;
        if (dir == "/Share/042efb85-240b-4a04-93d3-bca3924b7503") {
            throw new Exception("Root cannot be deleted");
        }
        if (!dir.contains("/Share/042efb85-240b-4a04-93d3-bca3924b7503")) {
            throw new Exception(String.valueOf(this.currentDirectory()) + " cannot be deleted");
        }
        Boolean flag = Servlets.delete(dir);
        if (!flag.booleanValue()) {
            throw new Exception("Impossible to delete " + path);
        }
    }

    public FTPFile[] list() throws Exception {
        FTPFile[] list = null;
        try {
            Map<String, Boolean> files = Servlets.listFolder(this.currentDirectory());
            list = new FTPFile[files.size()];
            int i = 0;
            Set<String> keys = files.keySet();
            for (String key : keys) {
                Boolean isFolder = files.get(key);
                list[i] = new FTPFile(key, isFolder);
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("Impossible to list " + this.currentDirectory());
        }
        return list;
    }

    public void createDirectory(String directoryName, String description) throws Exception {
        try {
            Servlets.createFolder(directoryName, description, this.currentDirectory());
        }
        catch (Exception e) {
            throw new Exception("Impossible to create Directory " + directoryName);
        }
    }

    public void upload(File file, String name, String description) throws Exception {
        try {
            Servlets.uploadFile(file, name, description, this.currentDirectory(), "UTF-8");
        }
        catch (Exception e) {
            throw new Exception("Impossible to upload file " + file.getAbsolutePath());
        }
    }

    public void upload(File file) throws Exception {
        this.upload(file, null, "");
    }

    public void test() throws Exception {
        FTPFile[] list;
        FTPClient client = new FTPClient();
        System.out.println("Current dir " + client.currentDirectory());
        System.out.println("List Root ");
        FTPFile[] fTPFileArray = list = client.list();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile item = fTPFileArray[n2];
            System.out.println("* " + item.getName() + " is folder? " + item.isFolder());
            ++n2;
        }
        System.out.println("\n\n");
        String A_name = "A-" + UUID.randomUUID().toString();
        String B_name = "B-" + UUID.randomUUID().toString();
        client.createDirectory(A_name, "test A in ROOT");
        System.out.println("Folder " + A_name + " created in " + client.currentDirectory());
        client.changeDirectory(A_name);
        System.out.println("Current dir " + client.currentDirectory());
        Assert.assertEquals((Object)client.currentDirectory(), (Object)("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name));
        System.out.println("\n\n");
        client.createDirectory(B_name, "test A in ROOT");
        System.out.println("Folder " + B_name + " created in " + client.currentDirectory());
        client.changeDirectory(B_name);
        System.out.println("Current dir " + client.currentDirectory());
        Assert.assertEquals((Object)client.currentDirectory(), (Object)("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name + "/" + B_name));
        System.out.println("\n\n");
        System.out.println("Save images in " + client.currentDirectory());
        URL imageURL = JUnitTest.class.getClassLoader().getResource("default.jpg");
        int i = 0;
        while (i < 5) {
            client.upload(new File(imageURL.getFile()), "img-" + UUID.randomUUID().toString() + ".jpg", "my description");
            ++i;
        }
        System.out.println("\n\n");
        client.changeDirectoryUp();
        System.out.println("Current directory up " + client.currentDirectory());
        Assert.assertEquals((Object)client.currentDirectory(), (Object)("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name));
        System.out.println("Delete folder " + B_name);
        client.deleteDirectory(B_name);
        System.out.println("\n\n");
        client.changeDirectoryUp();
        Assert.assertEquals((Object)client.currentDirectory(), (Object)"/Share/042efb85-240b-4a04-93d3-bca3924b7503");
        System.out.println("Current directory " + client.currentDirectory());
        System.out.println("Delete folder " + A_name);
        client.deleteDirectory(A_name);
        System.out.println("\n\n");
        System.out.println("HL CLI test successfully completed. ");
    }
}

