/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceSharedFolder
extends JCRAbstractWorkspaceFolder
implements WorkspaceSharedFolder {
    private String applicationName;
    private String destinationFolderId;
    private String itemName;
    private List<String> users;

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        super(workspace, delegate);
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, String originalDestinationFolderId, List<String> users) throws RepositoryException, InternalErrorException {
        super(workspace, delegate, name, description);
        this.destinationFolderId = originalDestinationFolderId;
        this.users = users;
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName) throws RepositoryException, InternalErrorException {
        this(workspace, delegate, name, description, originalDestinationFolderId, users);
        this.applicationName = applicationName;
        this.itemName = itemName;
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName, Map<String, String> properties) throws RepositoryException, InternalErrorException {
        this(workspace, delegate, name, description, originalDestinationFolderId, users, applicationName, itemName);
        super.setMetadata(properties);
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName, String displayName, boolean isVreFolder) throws RepositoryException, InternalErrorException {
        this(workspace, delegate, name, description, originalDestinationFolderId, users, applicationName, itemName);
        delegate.getProperties().put(NodeProperty.IS_VRE_FOLDER, new XStream().toXML((Object)isVreFolder));
        delegate.getProperties().put(NodeProperty.DISPLAY_NAME, displayName);
    }

    private void shareWithUses(List<String> users) throws RepositoryException {
        try {
            this.addUser(this.workspace.getOwner().getPortalLogin(), this.destinationFolderId);
            logger.trace("Share with " + users.toString());
            for (String user : users) {
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                Home home = homeManager.getHome(user);
                if (this.applicationName == null) {
                    if (this.isVreFolder()) {
                        this.addUser(user, home.getWorkspace().getMySpecialFolders().getId());
                        continue;
                    }
                    this.addUser(user, home.getWorkspace().getRoot().getId());
                    continue;
                }
                this.addUser(user, home.getDataArea().getApplicationRoot(this.applicationName).getId());
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    private List<String> listUsers(List<String> usersList) throws InternalErrorException {
        JCRSession servlets = null;
        ArrayList<String> users = new ArrayList<String>();
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            ArrayList<String> groups = new ArrayList<String>();
            JCRUserManager userManager = new JCRUserManager();
            List<GCubeGroup> groupsList = userManager.getGroups();
            for (GCubeGroup group : groupsList) {
                groups.add(group.getName());
            }
            ArrayList<String> memberIds = (ArrayList<String>)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.MEMBERS));
            if (memberIds == null) {
                memberIds = new ArrayList<String>();
            }
            for (String user : usersList) {
                if (!(this.isVreFolder() || user.endsWith("-Manager") || memberIds.contains(user))) {
                    memberIds.add(user);
                    logger.info(user + " add to membersList");
                }
                if (groups.contains(user)) {
                    logger.info("User " + user + " is a Group, resolve group id");
                    List<String> userList = this.workspace.resolveGroupId(user);
                    users.addAll(userList);
                    continue;
                }
                users.add(user);
            }
            this.delegate.getProperties().put(NodeProperty.MEMBERS, new XStream().toXML(memberIds));
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return users;
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }

    public ItemDelegate getUserNode(String user) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        logger.info("Get user Node of " + user + " in node " + this.delegate.getPath());
        ItemDelegate userNode = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            Map usersNode = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
            String value = (String)usersNode.get(user);
            logger.info("value " + value + " for delegate " + this.delegate.getPath());
            String[] values = value.split(this.workspace.getPathSeparator());
            if (values.length < 2) {
                throw new InternalErrorException("Path node corrupt");
            }
            String parentId = values[0];
            String nodeName = values[1];
            ItemDelegate parentNode = servlets.getItemById(parentId);
            userNode = servlets.getItemByPath(parentNode.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)nodeName));
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return userNode;
    }

    private ItemDelegate getUserNode() throws RepositoryException, InternalErrorException, ItemNotFoundException {
        return this.getUserNode(this.workspace.getOwner().getPortalLogin());
    }

    private String getNodeName(ItemDelegate node) throws RepositoryException, InternalErrorException {
        String[] names = node.getPath().split(this.workspace.getPathSeparator());
        return names[names.length - 1];
    }

    @Override
    public String getName() throws InternalErrorException {
        if (this.isSystemFolder()) {
            return this.getName(this.workspace.getOwner().getPortalLogin());
        }
        return this.delegate.getTitle();
    }

    @Override
    public void internalRename(JCRSession servlets, String newName, String remotePath) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            ItemDelegate userNode = this.getUserNode();
            if (this.workspace.exists(nodeNewName, userNode.getParentId())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            ItemDelegate parent = servlets.getItemById(userNode.getParentId());
            String newPath = parent.getPath() + this.workspace.getPathSeparator() + nodeNewName;
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.RENAMED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                logger.info("RemotePath not in " + this.delegate.getPath());
            }
            String path = userNode.getPath();
            this.delegate = servlets.move(path, newPath);
            this.delegate.setTitle(newName);
            String value = userNode.getParentId() + this.workspace.getPathSeparator() + newName;
            Map properties = this.delegate.getProperties();
            Map usersMap = (Map)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            usersMap.put(this.workspace.getOwner().getPortalLogin(), value);
            properties.put(NodeProperty.USERS, new XStream().toXML((Object)usersMap));
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (HttpException e1) {
            throw new InternalErrorException((Throwable)e1);
        }
        catch (IOException e1) {
            throw new InternalErrorException((Throwable)e1);
        }
    }

    @Override
    public void internalMove(JCRSession servlets, ItemDelegate destinationFolderNode, String remotePath) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getId());
            ItemDelegate itemDelegate = servlets.getItemById(this.getId());
            if (this.workspace.exists(itemDelegate.getTitle(), destinationFolderNode.getId())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + itemDelegate.getTitle() + " already exists");
            }
            itemDelegate.setLastModificationTime(Calendar.getInstance());
            itemDelegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            itemDelegate.setLastAction(WorkspaceItemAction.MOVED);
            ItemDelegate userNode = this.getUserNode();
            String userNodeName = this.getNodeName(userNode);
            String newPath = destinationFolderNode.getPath() + this.workspace.getPathSeparator() + userNodeName;
            String value = destinationFolderNode.getId() + this.workspace.getPathSeparator() + userNodeName;
            try {
                servlets.clone(itemDelegate.getPath(), newPath, false);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            Map properties = itemDelegate.getProperties();
            Map usersMap = (Map)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            usersMap.put(this.workspace.getOwner().getPortalLogin(), value);
            properties.put(NodeProperty.USERS, new XStream().toXML((Object)usersMap));
            servlets.removeItem(userNode.getPath());
            servlets.saveItem(itemDelegate);
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new RepositoryException(e.getMessage());
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ItemDelegate createUnsharedCopy(JCRSession servlets, ItemDelegate sharedNode, String destinationNodeId) throws Exception {
        logger.debug("unShare Node: " + sharedNode.getPath() + " -  by user: " + this.workspace.getOwner().getPortalLogin());
        ItemDelegate userNode = this.getUserNode();
        if (destinationNodeId.equals(userNode.getParentId())) {
            this.removeUserSharedFolder(sharedNode);
        }
        WorkspaceFolder unsharedFolder = this.workspace.createFolder(this.getNodeName(userNode), this.getDescription(), destinationNodeId);
        ItemDelegate nodeFolder = servlets.getItemById(unsharedFolder.getId());
        DelegateManager wrap = new DelegateManager(sharedNode, this.workspace.getOwner().getPortalLogin());
        List<ItemDelegate> children = wrap.getNodes();
        for (ItemDelegate child : children) {
            try {
                servlets.move(child.getPath(), nodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        ItemDelegate destinationNode = servlets.getItemById(destinationNodeId);
        logger.debug("copyremotecontent from " + nodeFolder.getPath() + " to parent id " + destinationNode.getPath());
        this.workspace.moveRemoteContent(servlets, (WorkspaceItem)unsharedFolder, destinationNode.getPath() + "/" + nodeFolder.getName());
        JCRWorkspaceItem itemUnshared = (JCRWorkspaceItem)this.workspace.getItem(unsharedFolder.getId());
        itemUnshared.setUnshareHistory(servlets, this.workspace.getOwner().getPortalLogin());
        itemUnshared.setOwnerToCurrentUser(itemUnshared);
        return nodeFolder;
    }

    @Override
    public ItemDelegate internalCopy(JCRSession servlets, ItemDelegate delegateFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        try {
            String pathNewNode = delegateFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
            if (servlets.getItemByPath(pathNewNode) != null) {
                throw new ItemAlreadyExistException(newName + " already exist");
            }
            String description = this.getDescription();
            String unSharedFolderId = this.workspace.createFolder(Text.escapeIllegalJcrChars((String)newName), description, delegateFolder.getId()).getId();
            ItemDelegate newNodeFolder = servlets.getItemById(unSharedFolderId);
            DelegateManager wrap = new DelegateManager(newNodeFolder, this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> children = wrap.getNodes();
            for (ItemDelegate child : children) {
                servlets.copy(child.getPath(), newNodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
            }
            return newNodeFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public JCRAbstractWorkspaceFolder getParent() throws InternalErrorException {
        try {
            return this.workspace.getParent(this.getUserNode());
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        logger.debug("Remove shared item " + this.getPath());
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            if (!JCRPrivilegesInfo.canDelete(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath(), true)) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node");
            }
            if (this.isVreFolder()) {
                throw new InternalErrorException("A VRE folder cannot be removed");
            }
            if (this.delegate.getPath().equals(this.workspace.mySpecialFoldersPath)) {
                throw new InternalErrorException("This folder cannot be removed");
            }
            try {
                JCRWorkspaceItem unsharedFolder = (JCRWorkspaceItem)this.workspace.unshare(this.getId());
                this.workspace.moveToTrash(servlets, unsharedFolder);
                try {
                    JCRAccountingFolderEntryRemoval entry = new JCRAccountingFolderEntryRemoval(unsharedFolder.getDelegate().getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), this.getType(), this.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)this).getFolderItemType() : null, this.getName(), this.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)this).getMimeType() : null);
                    entry.save(servlets);
                }
                catch (Exception e) {
                    logger.error("Impossible to set Removal Accounting Entry to parent of " + unsharedFolder.getDelegate().getPath());
                }
            }
            catch (ItemAlreadyExistException | ItemNotFoundException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public String getPath(ItemDelegate delegate) throws InternalErrorException, RepositoryException {
        ItemDelegate userNode = null;
        try {
            userNode = this.getUserNode();
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        return this.workspace.getRelativePath(userNode.getPath());
    }

    public List<String> getMembers() throws InternalErrorException {
        ArrayList list = null;
        try {
            list = (ArrayList)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.MEMBERS));
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public void setMembers(List<String> members) throws InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            this.delegate.getProperties().put(NodeProperty.MEMBERS, new XStream().toXML(members));
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Map users = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
            Set set = users.keySet();
            for (String key : set) {
                list.add(key);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    private void addUser(String user, String destinationFolderId) throws InternalErrorException, RepositoryException {
        logger.trace("addUser(" + this.delegate.getPath() + ", " + user + ", " + destinationFolderId + ");");
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            WorkspaceFolder userRoot = (WorkspaceFolder)homeManager.getHome(user).getWorkspace().getItem(destinationFolderId);
            ItemDelegate rootNode = servlets.getItemById(userRoot.getId());
            String sharedFolderName = userRoot.getUniqueName(this.delegate.getTitle(), false);
            Map properties = this.delegate.getProperties();
            HashMap<String, String> usersNode = null;
            try {
                usersNode = (HashMap<String, String>)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            }
            catch (Exception e) {
                logger.info("USERS not set on " + this.delegate.getPath());
                usersNode = new HashMap<String, String>();
            }
            String pathUser = null;
            if (this.applicationName != null) {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                logger.trace("clone from " + this.delegate.getPath() + this.workspace.getPathSeparator() + this.itemName + " to " + pathUser);
                ItemDelegate cloned = servlets.clone(this.delegate.getPath() + this.workspace.getPathSeparator() + this.itemName, pathUser, false);
                logger.trace("CLONE " + cloned.getPath());
            } else {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                try {
                    if (usersNode.get(user) != null) {
                        return;
                    }
                }
                catch (Exception e) {
                    logger.debug("User is not present");
                }
                servlets.clone(this.delegate.getPath(), pathUser, false);
                logger.trace("Clone from " + this.delegate.getPath() + " to " + pathUser);
            }
            String value = userRoot.getId() + this.workspace.getPathSeparator() + sharedFolderName;
            logger.trace("usersNode: " + this.delegate.getPath() + " - set value " + value + " to: " + user);
            usersNode.put(user, value);
            properties.put(NodeProperty.USERS, new XStream().toXML(usersNode));
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (HomeNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void addUser(String user) throws InsufficientPrivilegesException, InternalErrorException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            ItemDelegate sharedNode = servlets.getItemById(this.getId());
            Map usersMap = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.USERS));
            try {
                if (usersMap.get(user) != null) {
                    logger.trace(user + " is already in share");
                    return;
                }
            }
            catch (Exception e) {
                logger.debug("User " + user + " is not present");
            }
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            Home home = homeManager.getHome(user);
            if (this.isVreFolder()) {
                this.addUser(user, home.getWorkspace().getMySpecialFolders().getId());
            } else {
                this.addUser(user, home.getWorkspace().getRoot().getId());
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (HomeNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.SHARED_FOLDER;
    }

    public WorkspaceFolder unShare() throws InternalErrorException {
        return this.unShare(this.workspace.getOwner().getPortalLogin());
    }

    public WorkspaceFolder unShare(String user) throws InternalErrorException {
        logger.info("Unsharing folder " + this.getName() + " by user " + user);
        Boolean isSystemFolder = this.isSystemFolder();
        JCRSession servlets = null;
        JCRWorkspaceFolder folder = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            ItemDelegate sharedFolder = servlets.getItemById(this.getId());
            ItemDelegate userNode = this.getUserNode();
            if ((this.getOwner().getPortalLogin().equals(user) || this.getACLByUser(user).equals((Object)ACLType.ADMINISTRATOR)) && !this.isVreFolder()) {
                ItemDelegate unsharedNode = this.createUnsharedCopy(servlets, sharedFolder, userNode.getParentId());
                folder = new JCRWorkspaceFolder(this.workspace, unsharedNode);
                this.removeClones(servlets, sharedFolder);
                logger.trace("Remove sharedNode: " + sharedFolder.getPath());
                servlets.removeItem(sharedFolder.getPath());
                if (isSystemFolder.booleanValue()) {
                    folder.setSystemFolder(true);
                }
            } else {
                ItemDelegate cloneNode = this.getUserNode(user);
                logger.trace("Remove clone " + cloneNode.getPath());
                servlets.removeItem(cloneNode.getPath());
                Map usersMap = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
                usersMap.put(user, null);
                this.delegate.getProperties().put(NodeProperty.USERS, new XStream().toXML((Object)usersMap));
                servlets.saveItem(this.delegate);
                logger.trace(user + " has been deleted from share " + this.delegate.getPath());
                JCRAccessManager accessManager = new JCRAccessManager();
                ArrayList<String> userToRemove = new ArrayList<String>();
                userToRemove.add(user);
                boolean flag = accessManager.deleteAces(this.getAbsolutePath(), userToRemove);
                if (!flag) {
                    throw new InternalErrorException("Error deleting aces in " + this.getAbsolutePath() + " for users " + ((Object)userToRemove).toString());
                }
                this.setUnshareHistory(servlets, user);
            }
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public WorkspaceSharedFolder share(List<String> usersList) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        List<String> userIds = this.listUsers(usersList);
        for (String user : userIds) {
            this.addUser(user);
        }
        return this;
    }

    public String getName(String user) throws InternalErrorException {
        try {
            ItemDelegate userNode = this.getUserNode(user);
            return this.getNodeName(userNode);
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException(e);
        }
    }

    public ACLType getPrivilege() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getAbsolutePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    ACLType aclType;
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty() || (aclType = WorkspaceUtil.getACLTypeByKey(aclMap.get(user))).equals((Object)ACLType.ADMINISTRATOR)) continue;
                    return aclType;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return ACLType.WRITE_OWNER;
    }

    public void removeClones(JCRSession servlets, ItemDelegate sharedNode) throws InternalErrorException, RepositoryException {
        try {
            Map properties = sharedNode.getProperties();
            Map userNode = (Map)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            Set usersList = userNode.keySet();
            for (String user : usersList) {
                if (user.startsWith("jcr:")) continue;
                logger.trace("user " + user);
                logger.trace("workspace.getOwner().getPortalLogin() " + this.workspace.getOwner().getPortalLogin());
                try {
                    ItemDelegate cloneNode = this.getUserNode(user);
                    if (!cloneNode.getPrimaryType().equals("nthl:workspaceSharedItem")) continue;
                    servlets.removeItem(cloneNode.getPath());
                    logger.trace("Removed Clone " + cloneNode.getPath() + " - " + cloneNode.getPrimaryType());
                }
                catch (Exception e) {
                    logger.error("Error removing clone " + e);
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeUserSharedFolder(ItemDelegate sharedNode) throws InternalErrorException, RepositoryException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
            ItemDelegate userNode = this.getUserNode();
            servlets.removeItem(userNode.getPath());
            try {
                Map usersNode = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.USERS));
                usersNode.put(this.workspace.getOwner().getPortalLogin(), new XStream().toXML((Object)null));
                sharedNode.getProperties().put(NodeProperty.USERS, new XStream().toXML((Object)usersNode));
            }
            catch (Exception e) {
                logger.error("Error removing user from users node");
            }
            try {
                Map memberNode = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.MEMBERS));
                memberNode.remove(this.workspace.getOwner().getPortalLogin());
            }
            catch (Exception e) {
                logger.error("Error removing user from members node");
            }
            servlets.saveItem(sharedNode);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public boolean isVreFolder() {
        Boolean flag = false;
        try {
            flag = (Boolean)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.IS_VRE_FOLDER));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public boolean addAdmin(final String username) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.isAdmin(this.workspace.getOwner().getPortalLogin())) {
            try {
                this.share((List<String>)new ArrayList<String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(username);
                    }
                });
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                ArrayList<String> administator = new ArrayList<String>();
                administator.add(username);
                this.setACL(administator, ACLType.ADMINISTRATOR);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return false;
            }
            return true;
        }
        throw new InsufficientPrivilegesException("Insufficient Privileges to set administrators");
    }

    public List<String> getAdministrators() throws InternalErrorException {
        List<String> list = null;
        try {
            list = this.getACLOwner().get(ACLType.ADMINISTRATOR);
        }
        catch (Exception e) {
            logger.error("no administrators");
        }
        return list;
    }

    public boolean isAdmin(String username) throws InternalErrorException {
        return this.getACLUser().equals((Object)ACLType.ADMINISTRATOR);
    }

    public boolean setAdmins(List<String> logins) throws InsufficientPrivilegesException, InternalErrorException {
        logger.trace("setAdmins: " + logins.toString() + " on shared folder: " + this.getAbsolutePath());
        if (this.isAdmin(this.workspace.getOwner().getPortalLogin())) {
            try {
                List<String> notAdmins = this.getAdministrators();
                try {
                    notAdmins.removeAll(logins);
                }
                catch (Exception e) {
                    logger.trace("Admins not alredy set on " + this.getAbsolutePath());
                }
                try {
                    notAdmins.remove(this.getOwner().getPortalLogin());
                }
                catch (Exception e) {
                    logger.trace("Admins not alredy set on " + this.getAbsolutePath());
                }
                ACLType privilege = this.getPrivilege();
                logger.trace("Set " + privilege + " on users " + notAdmins);
                JCRAccessManager accessManager = new JCRAccessManager();
                logger.trace("Setting " + privilege + " on users " + notAdmins);
                try {
                    accessManager.deleteAces(this.getAbsolutePath(), notAdmins);
                }
                catch (Exception e) {
                    logger.error("Error deleting aces on " + this.getAbsolutePath());
                }
                try {
                    this.setACL(notAdmins, privilege);
                }
                catch (Exception e) {
                    logger.error("Error setting aces on " + this.getAbsolutePath());
                }
                try {
                    logins.removeAll(notAdmins);
                }
                catch (Exception e) {
                    logger.error("error removing all");
                }
                logger.trace("Setting Admin on users " + logins);
                for (String user : logins) {
                    this.addAdmin(user);
                }
                return true;
            }
            catch (Exception e) {
                logger.error("Error setting admins on node " + this.getAbsolutePath(), (Throwable)e);
                return false;
            }
        }
        throw new InsufficientPrivilegesException("Insufficient Privileges to edit administrators");
    }

    public void setACL(List<String> users, ACLType privilege) throws InternalErrorException {
        ArrayList<String> notAdmins = new ArrayList<String>(users);
        List<String> admins = this.getAdministrators();
        if (admins != null) {
            notAdmins.removeAll(admins);
            logger.info("notAdmin users " + ((Object)notAdmins).toString());
        } else {
            logger.info("No Administrators on " + this.getAbsolutePath());
        }
        String absPath = null;
        boolean flag = false;
        JCRAccessManager accessManager = new JCRAccessManager();
        int i = 0;
        while (!flag && i < 3) {
            ++i;
            try {
                absPath = this.getAbsolutePath();
                if (absPath == null) {
                    throw new InternalErrorException("Absolute path cannot be null setting ACL");
                }
                switch (privilege) {
                    case READ_ONLY: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setReadOnlyACL(notAdmins, absPath);
                        break;
                    }
                    case WRITE_OWNER: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setWriteOwnerACL(notAdmins, absPath);
                        break;
                    }
                    case WRITE_ALL: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setWriteAllACL(notAdmins, absPath);
                        break;
                    }
                    case ADMINISTRATOR: {
                        flag = accessManager.setAdminACL(users, absPath);
                        break;
                    }
                }
                if (flag) continue;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error("an error occurred setting ACL on: " + absPath);
            }
        }
        logger.info("Has ACL been modified correctly for users " + users.toString() + "in path " + absPath + "? " + flag);
        this.setAdministrators(accessManager, admins);
    }

    private void setAdministrators(JCRAccessManager accessManager, List<String> admins) throws InternalErrorException {
        if (!this.isVreFolder() && admins == null) {
            boolean isSet = false;
            int j = 0;
            while (!isSet && j < 3) {
                ++j;
                try {
                    String owner = this.workspace.getOwner().getPortalLogin();
                    ArrayList<String> adminList = new ArrayList<String>();
                    adminList.add(owner);
                    logger.info("Set " + owner + " ad administrator");
                    isSet = accessManager.setAdminACL(adminList, this.getAbsolutePath());
                    logger.info("Has ACL been modified correctly for users " + ((Object)adminList).toString() + "in path " + this.getAbsolutePath() + "? " + isSet);
                    if (isSet) continue;
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    logger.error("Error setting administators on " + this.getAbsolutePath());
                }
            }
        }
    }

    public List<String> getGroups() throws InternalErrorException {
        ArrayList<String> groups = new ArrayList<String>();
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        List<String> members = this.getMembers();
        for (String member : members) {
            if (!gm.isGroup(member)) continue;
            groups.add(member);
        }
        return groups;
    }

    public void share() throws RepositoryException, InternalErrorException {
        List<String> usersList = this.listUsers(this.users);
        this.shareWithUses(usersList);
    }

    public String getDisplayName() {
        String display = "";
        try {
            display = (String)this.delegate.getProperties().get(NodeProperty.DISPLAY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return display;
    }
}

