/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.AccessManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccessManager
implements AccessManager {
    private Logger logger = LoggerFactory.getLogger(JCRAccessManager.class);
    public static final String JUST_OWNER = "hl:justOwner";
    public static String url;

    public JCRAccessManager() {
        url = JCRRepository.url;
    }

    public Map<String, List<String>> getACL(String absPath) throws InternalErrorException {
        Map map = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = String.valueOf(url) + "/acl/GetACL?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            this.logger.debug(requestUrl);
            getMethod = new GetMethod(requestUrl);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        catch (Exception e) {
            this.logger.error("Error modifing ACLs: " + e);
            throw new InternalErrorException((Throwable)e);
        }
        XStream xstream = new XStream();
        try {
            map = (Map)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error reatriving EACL", (Throwable)e);
        }
        return map;
    }

    public boolean modifyAce(List<String> users, String absPath, List<String> privilegesList, String order) throws InternalErrorException {
        Boolean modified;
        block17: {
            modified = true;
            try {
                this.deleteAces(absPath, users);
            }
            catch (Exception e) {
                this.logger.error("Error deleting old ACLs: " + e);
                throw new InternalErrorException((Throwable)e);
            }
            GetMethod getMethod = null;
            try {
                try {
                    HttpClient httpClient = new HttpClient();
                    StringBuilder privileges = new StringBuilder();
                    for (String privilege : privilegesList) {
                        privileges.append("&privilege@" + privilege);
                    }
                    if (order == null) {
                        order = "first";
                    }
                    for (String user : users) {
                        try {
                            String requestUrl = String.valueOf(url) + "/ModifyAceServlet?" + JCRRepository.getCredentials() + "&principalId=" + user + "&resourcePath=" + URLEncoder.encode(absPath, "UTF-8") + privileges.toString() + "&order=" + order;
                            this.logger.debug(requestUrl);
                            getMethod = new GetMethod(requestUrl);
                            httpClient.executeMethod((HttpMethod)getMethod);
                            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                            if (getMethod == null) continue;
                            getMethod.releaseConnection();
                        }
                        catch (Exception e) {
                            this.logger.error("Error modifing ACLs: " + e);
                            throw new InternalErrorException((Throwable)e);
                        }
                    }
                    XStream xstream = new XStream();
                    try {
                        modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
                    }
                    catch (Exception e) {
                        modified = false;
                        this.logger.error("Error in Modify ace", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error in Add or Modify Permissions in AccessManager", (Throwable)e);
                    modified = false;
                    if (getMethod != null) {
                        getMethod.releaseConnection();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                throw throwable;
            }
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public Map<String, List<String>> getEACL(String absPath) throws InternalErrorException {
        Map map = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = String.valueOf(url) + "/acl/GetEACL?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            this.logger.debug(requestUrl);
            getMethod = new GetMethod(requestUrl);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        catch (Exception e) {
            this.logger.error("Error modifing ACLs: " + e);
            throw new InternalErrorException((Throwable)e);
        }
        XStream xstream = new XStream();
        try {
            map = (Map)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error reatriving EACL", (Throwable)e);
        }
        return map;
    }

    public boolean setReadOnlyACL(List<String> users, String absPath) throws InternalErrorException {
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setWriteOwnerACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("setAuthorAce - users: " + users.toString() + " - absPath: " + absPath);
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:write=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        this.logger.debug("Ace modified");
        return flag;
    }

    public boolean setWriteAllACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("hl:writeAll=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Write All to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAccessDenied(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=denied");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error removing Read privilege to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAdminACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:all=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Admin to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean deleteAces(String resourcePath, List<String> users) throws InternalErrorException {
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            try {
                HttpClient httpClient = new HttpClient();
                StringBuilder applyTo = new StringBuilder();
                for (String user : users) {
                    applyTo.append("&applyTo=" + user);
                }
                String requestUrl = String.valueOf(url) + "/DeleteAcesServlet?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(resourcePath, "UTF-8") + applyTo;
                this.logger.debug(requestUrl);
                getMethod = new GetMethod(requestUrl);
                httpClient.executeMethod((HttpMethod)getMethod);
                this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                XStream xstream = new XStream();
                modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            }
            catch (Exception e) {
                this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                return false;
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public Map<String, List<String>> getDeniedMap(String absPath) throws RepositoryException, InternalErrorException {
        Map map = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            String requestUrl = String.valueOf(url) + "/acl/GetDeniedMap?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");
            this.logger.debug(requestUrl);
            getMethod = new GetMethod(requestUrl);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        catch (Exception e) {
            this.logger.error("Error modifing ACLs: " + e);
            throw new InternalErrorException((Throwable)e);
        }
        XStream xstream = new XStream();
        try {
            map = (Map)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error reatriving EACL", (Throwable)e);
        }
        return map;
    }
}

