/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.data;

import org.gcube.common.homelibrary.home.data.ApplicationsArea;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRApplicationsArea
implements ApplicationsArea {
    private static final String SHARE = "share";
    private static final String USERS = "users";
    private WorkspaceFolder applicationsArea;
    private JCRWorkspace worksapce;

    public JCRApplicationsArea(JCRWorkspace workspace) {
        this.worksapce = workspace;
        try {
            this.applicationsArea = workspace.getApplicationArea();
        }
        catch (InternalErrorException internalErrorException) {
            // empty catch block
        }
    }

    public WorkspaceFolder getApplicationRoot(String applicationName) throws InternalErrorException {
        WorkspaceFolder folder = null;
        try {
            folder = (WorkspaceFolder)this.applicationsArea.find(applicationName);
            if (folder == null) {
                folder = this.applicationsArea.createFolder(applicationName, applicationName);
            }
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return folder;
    }

    public WorkspaceFolder getApplicationUserRoot(String applicationName) throws InternalErrorException {
        WorkspaceFolder applicationsRoot = this.getApplicationRoot(applicationName);
        try {
            WorkspaceFolder usersFolder = (WorkspaceFolder)applicationsRoot.find(USERS);
            WorkspaceFolder userFolder = (WorkspaceFolder)usersFolder.find(this.worksapce.getOwner().getPortalLogin());
            if (userFolder == null) {
                userFolder = usersFolder.createFolder(this.worksapce.getOwner().getPortalLogin(), applicationName);
            }
            return userFolder;
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder getApplicationShareRoot(String applicationName) throws InternalErrorException {
        WorkspaceFolder applicationsRoot = this.getApplicationRoot(applicationName);
        WorkspaceFolder shareFolder = (WorkspaceFolder)applicationsRoot.find(SHARE);
        return shareFolder;
    }
}

