/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
    IClient storage;
    String portalLogin;
    String callerScope;

    public GCUBEStorage(String portalLogin) {
        logger.trace("Calling GCUBEStorage from user: " + portalLogin);
        this.portalLogin = portalLogin;
        this.callerScope = ScopeProvider.instance.get();
        try {
            try {
                String scope = Utils.getRootScope(this.callerScope);
                ScopeProvider.instance.set(scope);
                logger.trace("GCUBE Storage scope : " + scope);
                this.getStorage();
                Handler.activateProtocol();
            }
            catch (Exception e) {
                logger.error("GCUBE Storage initialization failed", (Throwable)e);
                if (this.callerScope != null) {
                    ScopeProvider.instance.set(this.callerScope);
                }
            }
        }
        finally {
            if (this.callerScope != null) {
                ScopeProvider.instance.set(this.callerScope);
            }
        }
    }

    public IClient getStorage() {
        if (this.storage == null) {
            this.storage = new StorageClient("org.gcube.portlets.user", JCRRepository.serviceName, this.portalLogin, AccessType.SHARED, this.callerScope, false).getClient();
        }
        return this.storage;
    }

    public String updateMimeType(String remotePath, String mimeType) throws RemoteBackendException, IOException {
        return mimeType;
    }

    public String putStream(InputStream is, String remotePath, String mimeType) throws RemoteBackendException, IOException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + remotePath);
        String storageId = null;
        try {
            try {
                storageId = this.storage.put(true, mimeType).LFile(is).RFile(remotePath);
            }
            catch (Exception e) {
                logger.error("GCUBE Storage error in putStream operation", (Throwable)e);
                if (is != null) {
                    is.close();
                    logger.trace("GCUBE Storage inputStream closed");
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
                logger.trace("GCUBE Storage inputStream closed");
            }
        }
        return storageId;
    }

    public String putStream(String old_remotePath, String new_remotePath, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage -putStream - remotePath: " + new_remotePath);
        return this.storage.put(true, mimeType).LFile(old_remotePath).RFile(new_remotePath);
    }

    public long getRemoteFileSize(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        long size = this.storage.getSize().RFile(remotePath);
        return size;
    }

    public void removeRemoteFile(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - removeRemoteFile - remotePath: " + remotePath);
        this.storage.remove().RFile(remotePath);
    }

    public long getRemoteFileSize(String remotePath, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        return this.storage.getSize().RFile(remotePath);
    }

    public long getDiskUsageByUser() throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume used by user: " + this.portalLogin);
        return Long.parseLong(this.storage.getTotalUserVolume());
    }

    public int getTotalItemsByUser() throws RemoteBackendException {
        logger.trace("GCUBE Storage - get tot items of user " + this.portalLogin);
        return Integer.parseInt(this.storage.getUserTotalItems());
    }

    public long getFolderTotalVolume(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return Long.parseLong(this.storage.getFolderTotalVolume().RDir(remotePath).toString());
    }

    public String getFolderLastUpdate(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return this.storage.getFolderLastUpdate().RDir(remotePath);
    }

    public int getFolderTotalItems(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return Integer.parseInt(this.storage.getFolderTotalItems().RDir(remotePath).toString());
    }

    public InputStream getRemoteFile(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage -getRemoteFile - stream = storage.get().RFileAsInputStream(" + remotePath + ")");
        InputStream stream = null;
        stream = this.storage.get().RFileAsInputStream(remotePath);
        return stream;
    }

    public String getPublicLink(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        return this.storage.getUrl().RFile(remotePath);
    }

    public String getStorageId(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        MyFile file = this.storage.getMetaFile().RFile(remotePath);
        return file.getId();
    }

    public void moveRemoteFolder(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.moveDir().from(" + oldPath + ").to(" + newPath + ")");
        this.storage.moveDir().from(oldPath).to(newPath);
    }

    public void moveRemoteFile(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.moveFile().from(" + oldPath + ").to(" + newPath + ")");
        this.storage.moveFile().from(oldPath).to(newPath);
    }

    public void copyRemoteFile(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.copyFile().from(" + oldPath + ").to(" + newPath + ")");
        this.storage.copyFile().from(oldPath).to(newPath);
    }

    public void createHardLink(String srcPath, String destPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.linkFile().from(" + srcPath + ").to(" + destPath + ")");
        this.storage.linkFile().from(srcPath).to(destPath);
    }

    public void removeRemoteFolder(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        this.storage.removeDir().RDir(remotePath);
    }

    public String putStream(InputStream is, String new_remotePath, String serviceName, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + new_remotePath);
        this.storage.put(true, mimeType).LFile(is).RFile(new_remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return this.storage.getUrl().RFile(new_remotePath);
    }
}

