/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.resolver.UriResolverReaderParameter;
import org.gcube.common.homelibrary.jcr.shortner.UrlShortener;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryAddACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryCreate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDeleteACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryModifyACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUnshare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.HttpRequestUtil;
import org.gcube.common.homelibrary.jcr.workspace.util.StringUtil;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCRWorkspaceItem
implements WorkspaceItem {
    protected JCRWorkspace workspace;
    public ItemDelegate delegate;
    private ItemDelegate parentDelegate;
    protected static Logger logger = LoggerFactory.getLogger(JCRWorkspaceItem.class);

    public JCRWorkspaceItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        this.workspace = workspace;
        this.delegate = delegate;
    }

    public JCRWorkspaceItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description) throws RepositoryException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)description, (String)"Description must be not null");
        this.workspace = workspace;
        this.delegate = delegate;
        delegate.setLastModifiedBy(workspace.getOwner().getPortalLogin());
        delegate.setDescription(description);
        delegate.setTitle(name);
        delegate.setLastAction(WorkspaceItemAction.CREATED);
        delegate.setOwner(workspace.getOwner().getPortalLogin());
        delegate.setProperties(new HashMap());
        delegate.setContent(new HashMap());
    }

    public String getId() throws InternalErrorException {
        return this.delegate.getId();
    }

    public User getOwner() {
        return new JCRUser("", this.delegate.getOwner());
    }

    public String getName() throws InternalErrorException {
        return this.delegate.getTitle();
    }

    public String getDescription() throws InternalErrorException {
        return this.delegate.getDescription();
    }

    public Calendar getCreationTime() throws InternalErrorException {
        return this.delegate.getCreationTime();
    }

    public Calendar getLastModificationTime() throws InternalErrorException {
        return this.delegate.getLastModificationTime();
    }

    public WorkspaceItemAction getLastAction() throws InternalErrorException {
        return this.delegate.getLastAction();
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public Properties getProperties() throws InternalErrorException {
        try {
            return new JCRProperties(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPath() throws InternalErrorException {
        try {
            return this.getPath(this.delegate);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected String getPath(ItemDelegate item) throws InternalErrorException, RepositoryException {
        String nodePath = this.delegate.getPath();
        if (nodePath.contains("/Home/" + this.getOwner() + "/Workspace/Trash/")) {
            String path = nodePath.replace("/Home/" + this.getOwner() + "/Workspace/Trash/", "");
            String id = path.substring(path.indexOf(47) + 1);
            return "/Trash/" + id;
        }
        if (this.isRoot()) {
            return this.workspace.getPathSeparator() + item.getTitle();
        }
        JCRAbstractWorkspaceFolder folder = this.getParent(item);
        String path = folder.getPath() + this.workspace.getPathSeparator() + this.delegate.getTitle();
        return path;
    }

    public boolean isRoot() throws InternalErrorException {
        return this.getParent() == null;
    }

    public String getIdSharedFolder() throws InternalErrorException {
        return (String)this.delegate.getProperties().get(NodeProperty.SHARED_ROOT_ID);
    }

    public ItemDelegate save() throws RepositoryException {
        DelegateManager wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
        ItemDelegate item = null;
        try {
            item = wrap.save();
            this.delegate.setId(item.getId());
            this.delegate.setPath(item.getPath());
            this.delegate.setCreationTime(item.getCreationTime());
            this.delegate.setLastModificationTime(item.getLastModificationTime());
            this.delegate.setProperties(item.getProperties());
        }
        catch (Exception e) {
            logger.error("impossible to save item delegate " + this.delegate.getPath(), (Throwable)e);
        }
        return item;
    }

    public void setDescription(String description) throws InternalErrorException {
        try {
            this.internalDescription(description);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void rename(String name) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.renameItem(this.getId(), name);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<AccountingEntry> getAccounting() {
        ArrayList<AccountingEntry> list = new ArrayList<AccountingEntry>();
        JCRServlets servlets = null;
        try {
            servlets = JCRRepository.getServlets();
            JCRAccountingEntryCreate entry = new JCRAccountingEntryCreate(this.getId(), this.getOwner().getPortalLogin(), this.getCreationTime(), this.delegate.getTitle());
            list.add(entry);
            List<AccountingDelegate> accountingNode = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entryNode : accountingNode) {
                try {
                    switch (entryNode.getEntryType()) {
                        case CUT: {
                            list.add(new JCRAccountingFolderEntryCut(entryNode));
                            break;
                        }
                        case PASTE: {
                            list.add(new JCRAccountingEntryPaste(entryNode));
                            break;
                        }
                        case REMOVAL: {
                            list.add(new JCRAccountingFolderEntryRemoval(entryNode));
                            break;
                        }
                        case RENAMING: {
                            list.add(new JCRAccountingEntryRenaming(entryNode));
                            break;
                        }
                        case ADD: {
                            list.add(new JCRAccountingFolderEntryAdd(entryNode));
                            break;
                        }
                        case UPDATE: {
                            list.add(new JCRAccountingEntryUpdate(entryNode));
                            break;
                        }
                        case READ: {
                            list.add(new JCRAccountingEntryRead(entryNode));
                            break;
                        }
                        case SHARE: {
                            list.add(new JCRAccountingEntryShare(entryNode));
                            break;
                        }
                        case UNSHARE: {
                            list.add(new JCRAccountingEntryUnshare(entryNode));
                            break;
                        }
                        case ADD_ACL: {
                            list.add(new JCRAccountingEntryAddACL(entryNode));
                            break;
                        }
                        case MODIFY_ACL: {
                            list.add(new JCRAccountingEntryModifyACL(entryNode));
                            break;
                        }
                        case DELETE_ACL: {
                            list.add(new JCRAccountingEntryDeleteACL(entryNode));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Accounting entry skipped " + entryNode.getEntryType().toString(), (Throwable)e);
                }
            }
            return list;
        }
        catch (Exception e) {
            logger.error("Error to retrieve accounting entries ", (Throwable)e);
            return list;
        }
    }

    public JCRAbstractWorkspaceFolder getParent() throws InternalErrorException {
        try {
            return this.workspace.getParent(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isShared() throws InternalErrorException {
        return this.getType().equals((Object)WorkspaceItemType.SHARED_FOLDER) || this.delegate.getProperties().containsKey(NodeProperty.SHARED_ROOT_ID);
    }

    protected JCRAbstractWorkspaceFolder getParent(ItemDelegate node) throws InternalErrorException {
        try {
            return this.workspace.getParent(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isRoot(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        return this.getParentDelegate() == null;
    }

    public ItemDelegate getParentDelegate() throws InternalErrorException {
        if (this.parentDelegate == null) {
            this.parentDelegate = JCRRepository.getServlets().getItemById(this.delegate.getParentId());
        }
        return this.parentDelegate;
    }

    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.moveItem(this.getId(), destination.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem cloneItem(String cloneName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.cloneItem(this.getId(), cloneName);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ItemDelegate internalCopy(ItemDelegate nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        String pathNewNode = null;
        try {
            pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
            ItemDelegate node1 = null;
            try {
                node1 = JCRRepository.getServlets().getItemByPath(pathNewNode, this.workspace.getOwner().getPortalLogin());
            }
            catch (Exception e) {
                logger.trace(pathNewNode + " doesn not exist yet, it will be created");
            }
            if (node1 != null) {
                try {
                    WorkspaceFolder destinationFolder = (WorkspaceFolder)this.workspace.getWorkspaceItem(nodeFolder);
                    newName = destinationFolder.getUniqueName(newName, true);
                    pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
                }
                catch (Exception e) {
                    logger.trace("impossible to convert item in WorkspaceItem");
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        try {
            try {
                JCRRepository.getServlets().copy(this.delegate.getPath(), pathNewNode);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            DelegateManager wrap = null;
            try {
                wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            ItemDelegate newNode = JCRRepository.getServlets().getItemByPath(pathNewNode, this.workspace.getOwner().getPortalLogin());
            newNode.setLastModificationTime(Calendar.getInstance());
            newNode.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            newNode.setTitle(Text.unescapeIllegalJcrChars((String)newName));
            newNode.setLastAction(WorkspaceItemAction.CLONED);
            DelegateManager wrap1 = null;
            try {
                wrap1 = new DelegateManager(newNode, this.workspace.getOwner().getPortalLogin());
                wrap1.save();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            return newNode;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalMove(ItemDelegate destinationFolderNode, String remotePath) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getId());
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.MOVED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                try {
                    this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
                catch (Exception e1) {
                    logger.error("Remote path property is not in " + this.delegate.getPath());
                }
            }
            DelegateManager wrap = null;
            try {
                wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JCRRepository.getServlets().move(this.delegate.getPath(), destinationFolderNode.getPath() + this.workspace.getPathSeparator() + this.delegate.getName());
        }
        catch (Exception e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalRename(String newName, String remotePath) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            logger.debug("Internal rename item with id " + this.getId() + " to destination item with id " + this.delegate.getParentId());
            if (this.workspace.exists(newName, this.delegate.getParentId())) {
                logger.error("Item with name " + newName + " exists in folder " + this.delegate.getPath());
                throw new ItemAlreadyExistException("Item " + newName + " already exists");
            }
            ItemDelegate parent = JCRRepository.getServlets().getItemById(this.delegate.getParentId());
            String newPath = parent.getPath() + this.workspace.getPathSeparator() + nodeNewName;
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.RENAMED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                logger.info("remotePath will not be updated for item " + this.delegate.getPath());
            }
            this.delegate.setTitle(nodeNewName);
            DelegateManager wrap = null;
            try {
                wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
            catch (Exception e) {
                logger.error("Impossible to save " + this.delegate.getPath());
            }
            JCRRepository.getServlets().move(this.delegate.getPath(), newPath);
        }
        catch (Exception e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalDescription(String newDescription) throws InternalErrorException {
        Validate.notNull((Object)newDescription, (String)"Description must be not null");
        try {
            this.delegate.setDescription(newDescription);
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            DelegateManager wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
            wrap.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isMarkedAsRead() throws InternalErrorException {
        try {
            return this.hasReaders();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private boolean hasReaders() throws RepositoryException, InternalErrorException {
        int count = 0;
        try {
            JCRServlets servlets = JCRRepository.getServlets();
            List<AccountingDelegate> accounting = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entry : accounting) {
                if (!entry.equals((Object)AccountingEntryType.READ)) continue;
                ++count;
            }
            if (count > 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info("Node READERS has been added to " + this.delegate.getPath());
            return false;
        }
        return false;
    }

    public List<AccountingEntryRead> getReaders() throws InternalErrorException {
        ArrayList<AccountingEntryRead> list = new ArrayList<AccountingEntryRead>();
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            List<AccountingDelegate> accountingNode = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entry : accountingNode) {
                try {
                    if (!entry.equals((Object)AccountingEntryType.READ)) continue;
                    list.add(new JCRAccountingEntryRead(entry));
                }
                catch (Exception e) {
                    logger.info("Node ACCOUNTING not found");
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setShareHistory(List<String> users, String author) throws InternalErrorException {
        try {
            this.setShare(users, author);
            this.setHistoryShareUnshare(this, AccountingEntryType.SHARE.getNodeTypeDefinition(), author, users);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void setHistoryShareUnshare(WorkspaceItem item, String operation, String user, List<String> members) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        for (WorkspaceItem child : item.getChildren()) {
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM) || child.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                    if (operation.equals(AccountingEntryType.UNSHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)child).setUnshare(user);
                    } else if (operation.equals(AccountingEntryType.SHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)child).setShare(members, user);
                    }
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.setHistoryShareUnshare(child, operation, user, members);
        }
    }

    public void setUnshareHistory(String user) throws InternalErrorException {
        this.setUnshare(user);
        try {
            this.setHistoryShareUnshare(this, AccountingEntryType.UNSHARE.getNodeTypeDefinition(), user, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShare(List<String> users, String author) throws InternalErrorException {
        logger.info("Add SHARE operation for user " + author + " to node " + this.delegate.getPath());
        try {
            JCRAccountingEntryShare entry = new JCRAccountingEntryShare(this.getId(), author, Calendar.getInstance(), this.getName(), users);
            entry.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setUnshare(String user) throws InternalErrorException {
        logger.info("Add UNSHARE operation for user " + user);
        try {
            JCRAccountingEntryUnshare entry = new JCRAccountingEntryUnshare(this.getId(), user, Calendar.getInstance(), this.getName());
            entry.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void markAsRead(boolean read) throws InternalErrorException {
        try {
            logger.info("Mark Node " + this.delegate.getPath() + " As Read ");
            String user = this.workspace.getOwner().getPortalLogin();
            if (read) {
                logger.info("Setting " + this.delegate.getTitle() + " as read in " + this.delegate.getPath());
                JCRAccountingEntryRead entry = new JCRAccountingEntryRead(this.getId(), user, Calendar.getInstance(), this.getName());
                entry.save();
                try {
                    logger.info("Mark Parent of Node " + this.delegate.getPath() + " As Read ");
                    JCRAccountingEntryRead entryParent = new JCRAccountingEntryRead(this.delegate.getParentId(), user, Calendar.getInstance(), this.delegate.getTitle());
                    entryParent.save();
                }
                catch (Exception e) {
                    logger.info("Error setting " + this.delegate.getTitle() + " as read in parent node");
                }
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getRemotePath() throws InternalErrorException {
        return (String)this.delegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
    }

    public void setRemotePath(String remotePath) throws InternalErrorException, RepositoryException {
        try {
            Map contentNode = this.delegate.getContent();
            if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
        }
        catch (Exception e) {
            try {
                this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e1) {
                throw new InternalErrorException((Throwable)e1);
            }
        }
        DelegateManager wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
        try {
            wrap.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void setOwnerToCurrentUser(WorkspaceItem item) throws Exception {
        JCRServlets servlets = null;
        try {
            servlets = JCRRepository.getServlets();
            if (item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM) || item.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                ItemDelegate itemUnshared = servlets.getItemById(item.getId());
                itemUnshared.setOwner(this.workspace.getOwner().getPortalLogin());
                DelegateManager wrap = new DelegateManager(itemUnshared, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
            List children = null;
            try {
                children = item.getChildren();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (children != null) {
                for (WorkspaceItem child : children) {
                    this.setOwnerToCurrentUser(child);
                }
            }
        }
        catch (InternalErrorException e1) {
            throw new InternalErrorException((Throwable)e1);
        }
    }

    public List<String> getUsers() throws InternalErrorException {
        Map users = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
        return (List)((Object)users.keySet());
    }

    public boolean isFolder() throws InternalErrorException {
        return this.getType().equals((Object)WorkspaceItemType.FOLDER) || this.getType().equals((Object)WorkspaceItemType.SHARED_FOLDER);
    }

    public String getStorageID() throws InternalErrorException {
        logger.info("get Storage ID for item: " + this.getName());
        FolderItem folderItem = (FolderItem)this;
        String storageId = null;
        try {
            storageId = this.workspace.getStorage().getStorageId(folderItem.getRemotePath(), this.workspace.getOwner().getPortalLogin());
        }
        catch (Exception e) {
            throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
        }
        return storageId;
    }

    public String getPublicLink(boolean shortenUrl) throws InternalErrorException {
        logger.info("get PublicLink for item: " + this.getName());
        String publicLink = null;
        if (this.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
            FolderItem folderItem = (FolderItem)this;
            try {
                String smpUri = this.getPubliLinkForFolderItem(folderItem);
                publicLink = this.getPublicLinkForFolderItemId(smpUri, folderItem, shortenUrl);
            }
            catch (Exception e) {
                throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
            }
        } else {
            logger.warn("ItemId: " + this.getId() + " is not a folder item, sent exception Public Link  unavailable");
            throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
        }
        return publicLink;
    }

    private String getPubliLinkForFolderItem(FolderItem folderItem) throws InternalErrorException {
        return this.workspace.getStorage().getPublicLink(folderItem.getRemotePath(), this.workspace.getOwner().getPortalLogin());
    }

    public String getPublicLinkForFolderItemId(String smpUri, FolderItem folderItem, boolean shortenUrl) throws InternalErrorException {
        logger.trace("get Public Link ");
        try {
            if (smpUri == null || smpUri.isEmpty()) {
                throw new Exception("Sorry, public link on " + folderItem.getName() + " is not available");
            }
            UriResolverReaderParameter uriResolver = new UriResolverReaderParameter(ScopeProvider.instance.get());
            String uriRequest = "";
            if (uriResolver != null && uriResolver.isAvailable()) {
                String itemName = StringUtil.removeSpecialCharacters(folderItem.getName());
                uriRequest = uriResolver.resolveAsUriRequest(smpUri, itemName = StringUtil.replaceAllWhiteSpace(itemName, "_"), folderItem.getMimeType(), true);
                if (!HttpRequestUtil.urlExists(uriRequest + "&validation=true")) {
                    throw new InternalErrorException("Sorry, The Public Link for selected file is unavailable");
                }
                if (shortenUrl) {
                    uriRequest = this.getShortUrl(uriRequest);
                }
                return uriRequest;
            }
            throw new InternalErrorException("Sorry, The Uri resolver service is temporarily unavailable. Please try again later");
        }
        catch (Exception e) {
            logger.error("Error getPublicLinkForFolderItemId for item: " + folderItem.getId(), (Throwable)e);
            throw new InternalErrorException(e.getMessage());
        }
    }

    public String getShortUrl(String longUrl) throws Exception {
        logger.trace("get short url for " + longUrl);
        UrlShortener shortener = new UrlShortener(ScopeProvider.instance.get());
        try {
            if (shortener != null && shortener.isAvailable()) {
                return shortener.shorten(longUrl);
            }
            return longUrl;
        }
        catch (Exception e) {
            logger.error("Error get short url for ", (Throwable)e);
            return longUrl;
        }
    }

    public boolean isTrashed() throws InternalErrorException {
        return this.getPath().startsWith("/Trash/");
    }

    public String getAbsolutePath() throws InternalErrorException {
        logger.trace("Getting absolute path of: " + this.delegate.getTitle());
        String path = null;
        try {
            path = this.delegate.getPath();
            logger.trace(path);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return path;
    }

    public boolean hasAccessRight(String user, String absPath) throws InternalErrorException {
        List<String> privileges;
        Map<String, List<String>> map;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            map = accessManager.getDeniedMap(absPath);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException("Impossible to retrieve privileges");
        }
        return !map.containsKey(user) || !(privileges = map.get(user)).contains("jcr:read");
    }

    public void deleteACL(List<String> users) throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            absPath = this.getAbsolutePath();
            accessManager.deleteAces(absPath, users);
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
    }

    public String getLastUpdatedBy() throws InternalErrorException {
        List<AccountingEntry> accounting = null;
        String updatedBy = null;
        try {
            accounting = this.getAccounting();
            int size = accounting.size();
            if (size > 0) {
                updatedBy = accounting.get(size - 1).getUser();
            }
        }
        catch (Exception e) {
            throw new InternalErrorException("Impossible to retrieve Last Updated By");
        }
        return updatedBy;
    }

    public ACLType getACLUser() throws InternalErrorException {
        return JCRPrivilegesInfo.getACLByUser(this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath());
    }

    public Map<ACLType, List<String>> getACLOwner() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        HashMap<ACLType, List<String>> map = new HashMap<ACLType, List<String>>();
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getAbsolutePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (final String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty()) continue;
                    ACLType aclType = WorkspaceUtil.getACLTypeByKey(aclMap.get(user));
                    List users = null;
                    try {
                        users = (List)map.get(aclType);
                        users.add(user);
                        map.put(aclType, users);
                    }
                    catch (Exception e) {
                        map.put(aclType, (List<String>)new ArrayList<String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add(user);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return map;
    }
}

