/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceSharedFolder
extends JCRAbstractWorkspaceFolder
implements WorkspaceSharedFolder {
    private String applicationName;
    private String destinationFolderId;
    private String itemName;
    private List<String> users;

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        super(workspace, delegate);
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName) throws RepositoryException, InternalErrorException {
        super(workspace, delegate, name, description);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = users;
    }

    private void shareWithUses(List<String> users) throws RepositoryException {
        try {
            this.addUser(this.workspace.getOwner().getPortalLogin(), this.destinationFolderId);
            logger.trace("Share with " + users.toString());
            for (String user : users) {
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                Home home = homeManager.getHome(user);
                if (this.applicationName == null) {
                    if (this.isVreFolder()) {
                        this.addUser(user, home.getWorkspace().getMySpecialFolders().getId());
                        continue;
                    }
                    this.addUser(user, home.getWorkspace().getRoot().getId());
                    continue;
                }
                this.addUser(user, home.getDataArea().getApplicationRoot(this.applicationName).getId());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName, String displayName, boolean isVreFolder) throws RepositoryException, InternalErrorException {
        this(workspace, delegate, name, description, originalDestinationFolderId, users, applicationName, itemName);
        delegate.getProperties().put(NodeProperty.IS_VRE_FOLDER, new XStream().toXML((Object)isVreFolder));
        delegate.getProperties().put(NodeProperty.DISPLAY_NAME, displayName);
    }

    private List<String> listUsers(List<String> usersList) throws InternalErrorException {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        JCRUserManager userManager = new JCRUserManager();
        List<GCubeGroup> groupsList = userManager.getGroups();
        for (GCubeGroup group : groupsList) {
            groups.add(group.getName());
        }
        ArrayList<String> memberIds = null;
        try {
            for (String user : usersList) {
                memberIds = (ArrayList<String>)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.MEMBERS));
                if (memberIds.size() < 1) {
                    memberIds = new ArrayList<String>();
                }
                if (!memberIds.contains(user) && !user.endsWith("-Manager")) {
                    memberIds.add(user);
                    logger.warn(user + " add to membersList");
                }
                if (groups.contains(user)) {
                    logger.info("User " + user + " is a Group, resolve group id");
                    List<String> userList = this.workspace.resolveGroupId(user);
                    users.addAll(userList);
                    continue;
                }
                users.add(user);
            }
            this.delegate.getProperties().put(NodeProperty.MEMBERS, new XStream().toXML(memberIds));
            DelegateManager manager = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
            manager.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return users;
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }

    public ItemDelegate getUserNode(ItemDelegate delegate, String user) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        Map usersNode = (Map)new XStream().fromXML((String)delegate.getProperties().get(NodeProperty.USERS));
        String value = (String)usersNode.get(user);
        String[] values = value.split(this.workspace.getPathSeparator());
        if (values.length < 2) {
            throw new InternalErrorException("Path node corrupt");
        }
        String parentId = values[0];
        String nodeName = values[1];
        ItemDelegate parentNode = JCRRepository.getServlets().getItemById(parentId);
        return JCRRepository.getServlets().getItemByPath(parentNode.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)nodeName), this.workspace.getOwner().getPortalLogin());
    }

    private ItemDelegate getUserNode(ItemDelegate delegate) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        return this.getUserNode(delegate, this.workspace.getOwner().getPortalLogin());
    }

    private String getNodeName(ItemDelegate node) throws RepositoryException, InternalErrorException {
        String[] names = node.getPath().split(this.workspace.getPathSeparator());
        return names[names.length - 1];
    }

    @Override
    public String getName() throws InternalErrorException {
        return this.delegate.getTitle();
    }

    @Override
    public void internalRename(String newName, String remotePath) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            ItemDelegate userNode = this.getUserNode(this.delegate);
            if (this.workspace.exists(nodeNewName, userNode.getParentId())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            ItemDelegate parent = JCRRepository.getServlets().getItemById(userNode.getParentId());
            String newPath = parent.getPath() + this.workspace.getPathSeparator() + nodeNewName;
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.RENAMED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                logger.info("RemotePath not in " + this.delegate.getPath());
            }
            String path = userNode.getPath();
            try {
                this.delegate = JCRRepository.getServlets().move(path, newPath);
            }
            catch (HttpException e1) {
                throw new InternalErrorException((Throwable)e1);
            }
            catch (IOException e1) {
                throw new InternalErrorException((Throwable)e1);
            }
            Map properties = this.delegate.getProperties();
            Map usersNode = (Map)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            String value = userNode.getParentId() + this.workspace.getPathSeparator() + newName;
            usersNode.put(this.workspace.getOwner().getPortalLogin(), value);
            properties.put(NodeProperty.USERS, new XStream().toXML((Object)usersNode));
            DelegateManager wrap = null;
            try {
                wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public void internalMove(ItemDelegate destinationFolderNode, String remotePath) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getId());
            ItemDelegate itemDelegate = JCRRepository.getServlets().getItemById(this.getId());
            if (this.workspace.exists(itemDelegate.getTitle(), destinationFolderNode.getId())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + itemDelegate.getTitle() + " already exists");
            }
            itemDelegate.setLastModificationTime(Calendar.getInstance());
            itemDelegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            itemDelegate.setLastAction(WorkspaceItemAction.MOVED);
            ItemDelegate userNode = this.getUserNode(itemDelegate);
            String userNodeName = this.getNodeName(userNode);
            String newPath = destinationFolderNode.getPath() + this.workspace.getPathSeparator() + userNodeName;
            String value = destinationFolderNode.getId() + this.workspace.getPathSeparator() + userNodeName;
            try {
                JCRRepository.getServlets().clone(itemDelegate.getPath(), newPath, false);
            }
            catch (HttpException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Map usersNode = (Map)new XStream().fromXML((String)itemDelegate.getContent().get(NodeProperty.USERS));
            usersNode.put(this.workspace.getOwner().getPortalLogin(), value);
            JCRRepository.getServlets().removeItem(userNode.getPath());
            DelegateManager wrap = new DelegateManager(itemDelegate, this.workspace.getOwner().getPortalLogin());
            wrap.save();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ItemDelegate unShareNode(ItemDelegate sharedNode, String destinationNodeId, boolean localCopy) throws Exception {
        logger.debug("unShare Node: " + sharedNode.getPath() + " -  by user: " + this.workspace.getOwner().getPortalLogin());
        ItemDelegate userNode = this.getUserNode(sharedNode);
        String folderName = this.getNodeName(userNode);
        String description = this.getDescription();
        if (destinationNodeId.equals(userNode.getParentId())) {
            this.removeUserSharedFolder(sharedNode);
        }
        if (localCopy) {
            String unSharedFolderId = this.workspace.createFolder(folderName, description, destinationNodeId).getId();
            ItemDelegate nodeFolder = JCRRepository.getServlets().getItemById(unSharedFolderId);
            DelegateManager wrap = new DelegateManager(sharedNode, this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> children = wrap.getNodes();
            for (ItemDelegate child : children) {
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
                try {
                    JCRRepository.getServlets().copy(child.getPath(), nodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
                }
                catch (HttpException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ItemDelegate destinationNode = JCRRepository.getServlets().getItemById(destinationNodeId);
            logger.debug("copyremotecontent from " + nodeFolder.getPath() + " to parent id " + destinationNode.getPath());
            this.workspace.copyRemoteContent(nodeFolder, destinationNode);
            JCRWorkspaceItem itemUnshared = (JCRWorkspaceItem)this.workspace.getItem(unSharedFolderId);
            itemUnshared.setUnshareHistory(this.workspace.getOwner().getPortalLogin());
            itemUnshared.setOwnerToCurrentUser(itemUnshared);
            return nodeFolder;
        }
        return null;
    }

    @Override
    public ItemDelegate internalCopy(ItemDelegate delegateFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        JCRServlets servlets = JCRRepository.getServlets();
        String pathNewNode = delegateFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (servlets.getItemByPath(pathNewNode, this.workspace.getOwner().getPortalLogin()) != null) {
                throw new ItemAlreadyExistException(newName + " already exist");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String description = this.getDescription();
        try {
            String unSharedFolderId = this.workspace.createFolder(Text.escapeIllegalJcrChars((String)newName), description, delegateFolder.getId()).getId();
            ItemDelegate newNodeFolder = servlets.getItemById(unSharedFolderId);
            DelegateManager wrap = new DelegateManager(newNodeFolder, this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> children = wrap.getNodes();
            for (ItemDelegate child : children) {
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
                servlets.copy(child.getPath(), newNodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
            }
            return newNodeFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public JCRAbstractWorkspaceFolder getParent() throws InternalErrorException {
        try {
            return this.workspace.getParent(this.getUserNode(this.delegate));
        }
        catch (RepositoryException | ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        logger.debug("Remove shared item");
        logger.debug("portalLogin: " + this.workspace.getOwner().getPortalLogin() + " - owner: " + this.getOwner());
        try {
            if (!JCRPrivilegesInfo.canDelete(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath(), true)) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node");
            }
            if (this.isVreFolder()) {
                throw new InternalErrorException("A VRE folder cannot be removed");
            }
            if (this.delegate.getPath().equals(this.workspace.mySpecialFoldersPath)) {
                throw new InternalErrorException("This folder cannot be removed");
            }
            try {
                WorkspaceFolder unsharedFolder = this.unShare();
                logger.trace("unsharedFolder: " + unsharedFolder.getPath());
                ItemDelegate usharedNode = JCRRepository.getServlets().getItemById(unsharedFolder.getId());
                this.workspace.moveToTrash(usharedNode);
            }
            catch (ItemAlreadyExistException | ItemNotFoundException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public String getPath(ItemDelegate delegate) throws InternalErrorException, RepositoryException {
        ItemDelegate userNode = null;
        try {
            userNode = this.getUserNode(delegate);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        return ((JCRWorkspaceFolder)this.getParent(userNode)).getPath(JCRRepository.getServlets().getItemById(userNode.getParentId())) + this.workspace.getPathSeparator() + this.getNodeName(userNode);
    }

    public List<String> getMembers() throws InternalErrorException {
        ArrayList list = null;
        try {
            list = (ArrayList)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.MEMBERS));
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    @Override
    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Map users = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
            Set set = users.keySet();
            for (String key : set) {
                list.add(key);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    private void addUser(String user, String destinationFolderId) throws InternalErrorException, RepositoryException {
        logger.trace("addUser(" + this.delegate.getPath() + ", " + user + ", " + destinationFolderId + ");");
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            WorkspaceFolder userRoot = (WorkspaceFolder)homeManager.getHome(user).getWorkspace().getItem(destinationFolderId);
            ItemDelegate rootNode = servlets.getItemById(userRoot.getId());
            String sharedFolderName = userRoot.getUniqueName(this.delegate.getTitle(), false);
            Map properties = this.delegate.getProperties();
            HashMap<String, String> usersNode = null;
            try {
                usersNode = (HashMap<String, String>)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            }
            catch (Exception e) {
                logger.info("USERS not set on " + this.delegate.getPath());
                usersNode = new HashMap<String, String>();
            }
            String pathUser = null;
            if (this.applicationName != null) {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                logger.trace("clone from " + this.delegate.getPath() + this.workspace.getPathSeparator() + this.itemName + " to " + pathUser);
                ItemDelegate cloned = JCRRepository.getServlets().clone(this.delegate.getPath() + this.workspace.getPathSeparator() + this.itemName, pathUser, false);
                logger.trace("CLONE " + cloned.getPath());
            } else {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                try {
                    if (usersNode.get(user) != null) {
                        return;
                    }
                }
                catch (Exception e) {
                    logger.debug("User is not present");
                }
                JCRRepository.getServlets().clone(this.delegate.getPath(), pathUser, false);
                logger.trace("Clone from " + this.delegate.getPath() + " to " + pathUser);
            }
            String value = userRoot.getId() + this.workspace.getPathSeparator() + sharedFolderName;
            logger.trace("usersNode: " + this.delegate.getPath() + " - set value " + value + " to: " + user);
            usersNode.put(user, value);
            properties.put(NodeProperty.USERS, new XStream().toXML(usersNode));
            DelegateManager wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
            wrap.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void addUser(String user) throws InsufficientPrivilegesException, InternalErrorException {
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            ItemDelegate sharedNode = servlets.getItemById(this.getId());
            Map usersMap = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.USERS));
            try {
                if (usersMap.get(user) != null) {
                    logger.trace(user + " is already in share");
                    return;
                }
            }
            catch (Exception e) {
                logger.debug("User " + user + " is not present");
            }
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            Home home = homeManager.getHome(user);
            if (this.isVreFolder()) {
                this.addUser(user, home.getWorkspace().getMySpecialFolders().getId());
            } else {
                this.addUser(user, home.getWorkspace().getRoot().getId());
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.SHARED_FOLDER;
    }

    public WorkspaceFolder unShare() throws InternalErrorException {
        try {
            ItemDelegate item = JCRRepository.getServlets().getItemById(this.getId());
            ItemDelegate userNode = this.getUserNode(item);
            ItemDelegate unsharedNode = null;
            JCRWorkspaceFolder folder = null;
            boolean flag = false;
            if (this.getOwner().equals(this.workspace.getOwner().getPortalLogin()) || this.getACLUser().equals((Object)ACLType.ADMINISTRATOR)) {
                flag = true;
            }
            try {
                unsharedNode = this.unShareNode(item, userNode.getParentId(), flag);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (unsharedNode != null) {
                folder = new JCRWorkspaceFolder(this.workspace, unsharedNode);
                logger.trace("remove clones");
                this.removeClones(item);
                logger.trace("remove sharedNode: " + item.getPath());
                DelegateManager wrap = new DelegateManager(item, this.workspace.getOwner().getPortalLogin());
                wrap.remove();
            } else {
                JCRAccessManager accessManager = new JCRAccessManager();
                ArrayList<String> userToRemove = new ArrayList<String>();
                userToRemove.add(this.workspace.getOwner().getPortalLogin());
                accessManager.deleteAces(this.getAbsolutePath(), userToRemove);
            }
            return folder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder unShare(String user) throws InternalErrorException {
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            if (!(user.startsWith("jcr:") || user.startsWith("hl:") || user.equals(this.workspace.getOwner().getPortalLogin()))) {
                try {
                    ItemDelegate cloneNode = this.getUserNode(this.delegate, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    servlets.removeItem(cloneNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing clone ");
                }
                Map userNode = null;
                try {
                    userNode = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
                    userNode.put(user, null);
                    this.delegate.getProperties().put(NodeProperty.USERS, new XStream().toXML((Object)userNode));
                    DelegateManager wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
                    wrap.save();
                    logger.trace(user + "  deleted from share " + this.delegate.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users ");
                }
            }
            JCRAccessManager accessManager = new JCRAccessManager();
            ArrayList<String> userToRemove = new ArrayList<String>();
            userToRemove.add(user);
            accessManager.deleteAces(this.getAbsolutePath(), userToRemove);
            this.setUnshareHistory(user);
            return null;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder share(List<String> usersList) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        List<String> userIds = this.listUsers(usersList);
        for (String user : userIds) {
            this.addUser(user);
        }
        return this;
    }

    public String getName(String user) throws InternalErrorException {
        try {
            ItemDelegate userNode = this.getUserNode(this.delegate, user);
            return this.getNodeName(userNode);
        }
        catch (RepositoryException | ItemNotFoundException e) {
            throw new InternalErrorException(e);
        }
    }

    public ACLType getPrivilege() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getAbsolutePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    ACLType aclType;
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty() || (aclType = WorkspaceUtil.getACLTypeByKey(aclMap.get(user))).equals((Object)ACLType.ADMINISTRATOR)) continue;
                    return aclType;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return ACLType.WRITE_OWNER;
    }

    public void removeClones(ItemDelegate sharedNode) throws InternalErrorException, RepositoryException {
        JCRServlets servlets = JCRRepository.getServlets();
        try {
            Map properties = sharedNode.getProperties();
            Map userNode = (Map)new XStream().fromXML((String)properties.get(NodeProperty.USERS));
            Set usersList = userNode.keySet();
            for (String user : usersList) {
                if (user.startsWith("jcr:")) continue;
                logger.trace("user " + user);
                logger.trace("workspace.getOwner().getPortalLogin() " + this.workspace.getOwner().getPortalLogin());
                if (user.startsWith("jcr:") || user.startsWith("hl:")) continue;
                try {
                    ItemDelegate cloneNode = this.getUserNode(sharedNode, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    servlets.removeItem(cloneNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing clone " + e);
                }
                try {
                    logger.trace("remove user in userList");
                    logger.trace(user + "  deleted from share " + sharedNode.getPath());
                    userNode.put(user, null);
                    sharedNode.getProperties().put(NodeProperty.USERS, new XStream().toXML((Object)userNode));
                    logger.trace(user + "  deleted from share " + sharedNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users " + e);
                }
                try {
                    Map memberNode = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.MEMBERS));
                    memberNode.remove(user);
                }
                catch (Exception e) {
                    logger.error("Error removing user from members node");
                }
                DelegateManager wrap = new DelegateManager(sharedNode, this.workspace.getOwner().getPortalLogin());
                wrap.save();
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeUserSharedFolder(ItemDelegate sharedNode) throws InternalErrorException, RepositoryException {
        try {
            ItemDelegate userNode = this.getUserNode(sharedNode);
            JCRRepository.getServlets().removeItem(userNode.getPath());
            try {
                Map usersNode = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.USERS));
                usersNode.put(this.workspace.getOwner().getPortalLogin(), new XStream().toXML((Object)null));
                sharedNode.getProperties().put(NodeProperty.USERS, new XStream().toXML((Object)usersNode));
            }
            catch (Exception e) {
                logger.error("Error removing user from users node");
            }
            try {
                Map memberNode = (Map)new XStream().fromXML((String)sharedNode.getProperties().get(NodeProperty.MEMBERS));
                memberNode.remove(this.workspace.getOwner().getPortalLogin());
            }
            catch (Exception e) {
                logger.error("Error removing user from members node");
            }
            DelegateManager wrap = new DelegateManager(sharedNode, this.workspace.getOwner().getPortalLogin());
            wrap.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isVreFolder() {
        Boolean flag = false;
        try {
            flag = (Boolean)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.IS_VRE_FOLDER));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public String getDisplayName() {
        String display = "";
        try {
            display = (String)this.delegate.getProperties().get(NodeProperty.DISPLAY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return display;
    }

    public boolean addAdmin(final String username) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.isAdmin(this.workspace.getOwner().getPortalLogin())) {
            try {
                this.share((List<String>)new ArrayList<String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(username);
                    }
                });
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                ArrayList<String> administator = new ArrayList<String>();
                administator.add(username);
                this.setACL(administator, ACLType.ADMINISTRATOR);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return false;
            }
            return true;
        }
        throw new InsufficientPrivilegesException("Insufficient Privileges to set administrators");
    }

    public List<String> getAdministrators() throws InternalErrorException {
        List<String> list = null;
        try {
            list = this.getACLOwner().get(ACLType.ADMINISTRATOR);
        }
        catch (Exception e) {
            logger.error("no administrators");
        }
        return list;
    }

    public boolean isAdmin(String username) throws InternalErrorException {
        return this.getACLUser().equals((Object)ACLType.ADMINISTRATOR);
    }

    public boolean setAdmins(List<String> logins) throws InsufficientPrivilegesException, InternalErrorException {
        logger.trace("setAdmins: " + logins.toString() + " on shared folder: " + this.getAbsolutePath());
        if (this.isAdmin(this.workspace.getOwner().getPortalLogin())) {
            try {
                List<String> notAdmins = this.getAdministrators();
                try {
                    notAdmins.removeAll(logins);
                }
                catch (Exception e) {
                    logger.trace("Admins not alredy set on " + this.getAbsolutePath());
                }
                try {
                    notAdmins.remove(this.getOwner().getPortalLogin());
                }
                catch (Exception e) {
                    logger.trace("Admins not alredy set on " + this.getAbsolutePath());
                }
                ACLType privilege = this.getPrivilege();
                logger.trace("Set " + privilege + " on users " + notAdmins);
                JCRAccessManager accessManager = new JCRAccessManager();
                logger.trace("Setting " + privilege + " on users " + notAdmins);
                try {
                    accessManager.deleteAces(this.getAbsolutePath(), notAdmins);
                }
                catch (Exception e) {
                    logger.error("Error deleting aces on " + this.getAbsolutePath());
                }
                try {
                    this.setACL(notAdmins, privilege);
                }
                catch (Exception e) {
                    logger.error("Error setting aces on " + this.getAbsolutePath());
                }
                try {
                    logins.removeAll(notAdmins);
                }
                catch (Exception e) {
                    logger.error("error removing all");
                }
                logger.trace("Setting Admin on users " + logins);
                for (String user : logins) {
                    this.addAdmin(user);
                }
                return true;
            }
            catch (Exception e) {
                logger.error("Error setting admins on node " + this.getAbsolutePath(), (Throwable)e);
                return false;
            }
        }
        throw new InsufficientPrivilegesException("Insufficient Privileges to edit administrators");
    }

    public void setACL(List<String> users, ACLType privilege) throws InternalErrorException {
        ArrayList<String> notAdmins = new ArrayList<String>(users);
        List<String> admins = this.getAdministrators();
        if (admins != null) {
            notAdmins.removeAll(admins);
            logger.info("notAdmin users " + ((Object)notAdmins).toString());
        } else {
            logger.info("No Administrators on " + this.getAbsolutePath());
        }
        boolean flag = false;
        JCRAccessManager accessManager = new JCRAccessManager();
        int i = 0;
        while (!flag && i < 3) {
            ++i;
            try {
                if (this.getAbsolutePath() == null) {
                    throw new InternalErrorException("Absolute path cannot be null setting ACL");
                }
                switch (privilege) {
                    case READ_ONLY: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setReadOnlyACL(notAdmins, this.getAbsolutePath());
                        break;
                    }
                    case WRITE_OWNER: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setWriteOwnerACL(notAdmins, this.getAbsolutePath());
                        break;
                    }
                    case WRITE_ALL: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setWriteAllACL(notAdmins, this.getAbsolutePath());
                        break;
                    }
                    case ADMINISTRATOR: {
                        flag = accessManager.setAdminACL(users, this.getAbsolutePath());
                        break;
                    }
                }
                if (flag) continue;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error("an error occurred setting ACL on: " + this.getAbsolutePath());
            }
        }
        logger.info("Has ACL been modified correctly for users " + users.toString() + "in path " + this.getAbsolutePath() + "? " + flag);
        this.setAdministrators(accessManager, admins);
    }

    private void setAdministrators(JCRAccessManager accessManager, List<String> admins) throws InternalErrorException {
        if (!this.isVreFolder() && admins == null) {
            boolean isSet = false;
            int j = 0;
            while (!isSet && j < 3) {
                ++j;
                try {
                    String owner = this.workspace.getOwner().getPortalLogin();
                    ArrayList<String> adminList = new ArrayList<String>();
                    adminList.add(owner);
                    logger.info("Set " + owner + " ad administrator");
                    isSet = accessManager.setAdminACL(adminList, this.getAbsolutePath());
                    logger.info("Has ACL been modified correctly for users " + ((Object)adminList).toString() + "in path " + this.getAbsolutePath() + "? " + isSet);
                    if (isSet) continue;
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    logger.error("Error setting administators on " + this.getAbsolutePath());
                }
            }
        }
    }

    public List<String> getGroups() throws InternalErrorException {
        ArrayList<String> groups = new ArrayList<String>();
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        List<String> members = this.getMembers();
        for (String member : members) {
            if (!gm.isGroup(member).booleanValue()) continue;
            groups.add(member);
        }
        return groups;
    }

    public void share() throws RepositoryException, InternalErrorException {
        List<String> usersList = this.listUsers(this.users);
        this.shareWithUses(usersList);
    }
}

