/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper;

import java.util.List;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;

public class DelegateManager {
    ItemDelegate item;
    String login;

    public DelegateManager(ItemDelegate item, String login) {
        this.item = item;
        this.login = login;
    }

    public DelegateManager(String name, String type, String parentId) {
        this.item.setName(name);
        this.item.setPrimaryType(type);
        this.item.setParentId(parentId);
    }

    public ItemDelegate save() throws Exception {
        ItemDelegate saved = JCRRepository.getServlets().saveItem(this.item);
        return saved;
    }

    public void save(ItemDelegate itemDelegate) throws Exception {
        ItemDelegate delegate = JCRRepository.getServlets().saveItem(itemDelegate);
        itemDelegate.setId(delegate.getId());
        itemDelegate.setPath(delegate.getPath());
        itemDelegate.setCreationTime(delegate.getCreationTime());
        itemDelegate.setLastModificationTime(delegate.getLastModificationTime());
    }

    public ItemDelegate getParent() {
        ItemDelegate parent = null;
        try {
            parent = JCRRepository.getServlets().getItemById(this.item.getParentId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parent;
    }

    public List<ItemDelegate> getNodes() {
        List<ItemDelegate> children = null;
        try {
            children = JCRRepository.getServlets().getChildrenById(this.item.getId(), this.login);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return children;
    }

    public void remove() {
        try {
            JCRRepository.getServlets().removeItem(this.item.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ItemDelegate addNode(String name, String type) {
        ItemDelegate delegate = new ItemDelegate();
        delegate.setName(name);
        if (type != null) {
            delegate.setPrimaryType(type);
        }
        delegate.setParentId(this.item.getId());
        delegate.setLastAction(WorkspaceItemAction.CREATED);
        return delegate;
    }

    public ItemDelegate addNode(String name) {
        ItemDelegate delegate = new ItemDelegate();
        delegate.setName(name);
        delegate.setParentId(this.item.getId());
        return delegate;
    }

    public ItemDelegate getNode(String name) throws ItemNotFoundException {
        ItemDelegate delegate = null;
        try {
            delegate = JCRRepository.getServlets().getItemByPath(this.item.getPath() + "/" + Text.escapeIllegalJcrChars((String)name), this.login);
        }
        catch (ItemNotFoundException e) {
            throw new ItemNotFoundException(e.toString());
        }
        return delegate;
    }
}

