/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRProperties
implements Properties {
    private static Logger logger = LoggerFactory.getLogger(JCRProperties.class);
    private Map<String, String> map;
    private ItemDelegate itemDelegate;

    public JCRProperties(ItemDelegate itemDelegate) throws RepositoryException, InternalErrorException {
        this.itemDelegate = itemDelegate;
        this.map = itemDelegate.getMetadata();
    }

    public String getId() throws InternalErrorException {
        return this.itemDelegate.getId();
    }

    public String getPropertyValue(String propertyName) throws InternalErrorException {
        return this.map.get(propertyName);
    }

    public Map<String, String> getProperties() throws InternalErrorException {
        return this.map;
    }

    public void addProperty(String name, String value) throws InternalErrorException {
        Validate.notNull((Object)name, (String)"Name property must be not null");
        Validate.notNull((Object)value, (String)"Value property must be not null");
        try {
            String escapeName = Text.escapeIllegalJcrChars((String)name);
            this.map.put(escapeName, value);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void update() throws InternalErrorException {
        DelegateManager item = new DelegateManager(this.itemDelegate, "");
        try {
            item.save();
        }
        catch (Exception e) {
            logger.error("Error updating properties ", (Throwable)e);
        }
    }
}

