/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;

public class JCRWorkspaceTrashFolder
extends JCRWorkspaceFolder
implements WorkspaceTrashFolder {
    private static final String NT_TRASH_ITEM = "nthl:trashItem";

    public JCRWorkspaceTrashFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public WorkspaceTrashItem getTrashItemById(String id) throws InternalErrorException {
        JCRWorkspaceTrashItem trashItem;
        block4: {
            ItemDelegate trashNode = null;
            trashItem = null;
            try {
                trashNode = JCRRepository.getServlets().getItemById(id);
                if (!trashNode.getPrimaryType().equals(NT_TRASH_ITEM)) break block4;
                try {
                    trashItem = new JCRWorkspaceTrashItem(this.workspace, trashNode);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Trash not found " + e);
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return trashItem;
    }

    public List<WorkspaceTrashItem> listTrashItems() throws InternalErrorException, ItemNotFoundException {
        ItemDelegate node = null;
        ArrayList<WorkspaceTrashItem> children = null;
        try {
            children = new ArrayList<WorkspaceTrashItem>();
            node = JCRRepository.getServlets().getItemById(this.getId());
            DelegateManager wrap = new DelegateManager(node, this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> trashNodes = wrap.getNodes();
            for (ItemDelegate trashNode : trashNodes) {
                if (!trashNode.getPrimaryType().equals(NT_TRASH_ITEM)) continue;
                WorkspaceTrashItem trashItem = (WorkspaceTrashItem)this.workspace.getItem(trashNode.getId());
                children.add(trashItem);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return children;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> emptyTrash() throws InternalErrorException {
        ItemDelegate trashNode = null;
        try {
            trashNode = JCRRepository.getServlets().getItemById(this.getId());
            DelegateManager wrap = new DelegateManager(trashNode, this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> children = wrap.getNodes();
            for (ItemDelegate child : children) {
                if (!child.getPrimaryType().equals(NT_TRASH_ITEM)) continue;
                try {
                    JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                    trashItem.deletePermanently();
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> restoreAll() throws InternalErrorException {
        ItemDelegate trashNode = null;
        try {
            trashNode = JCRRepository.getServlets().getItemById(this.getId());
            DelegateManager wrap = new DelegateManager(trashNode, this.workspace.getOwner().getPortalLogin());
            List<ItemDelegate> children = wrap.getNodes();
            for (ItemDelegate child : children) {
                if (!child.getPrimaryType().equals(NT_TRASH_ITEM)) continue;
                try {
                    JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                    trashItem.restore();
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_FOLDER;
    }
}

