/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.search;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolder;

public class JCRSearchFolderItem
extends JCRSearchFolder
implements SearchFolderItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String DATA = "jcr:data";
    private static final String MIME_TYPE = "jcr:mimeType";
    private static final String SIZE = "hl:size";
    private long size;
    private String mimeType;
    private final FolderItemType folderItemType;

    public JCRSearchFolderItem(Node node, FolderItemType type, String name) throws RepositoryException {
        super(node, name);
        this.folderItemType = type;
        String[] nameGlobs = new String[]{MIME_TYPE, SIZE};
        try {
            PropertyIterator properties = node.getNode(CONTENT).getProperties(nameGlobs);
            while (properties.hasNext()) {
                Property propery = properties.nextProperty();
                switch (propery.getName()) {
                    case "jcr:mimeType": {
                        this.mimeType = propery.getString();
                        break;
                    }
                    case "hl:size": {
                        this.size = propery.getLong();
                        break;
                    }
                }
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public FolderItemType getFolderItemType() {
        return this.folderItemType;
    }
}

