/**
 * 
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryShare;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Valentina Marioli valentina.marioli@isti.cnr.it
 *
 */
public class JCRAccountingEntryModifyACL extends JCRAccountingEntry implements AccountingEntryShare {

	private static final String MEMBERS 			= "hl:members";
	private static final String ITEM_NAME 			= "hl:itemName";

	protected String itemName;
	protected List<String> members;

	
	protected static Logger logger = LoggerFactory.getLogger(JCRAccountingEntryModifyACL.class);
	
	/**
	 * @param node
	 * @throws RepositoryException
	 */
	public JCRAccountingEntryModifyACL(Node node) throws RepositoryException {

		super(node);
		this.itemName =  node.getProperty(ITEM_NAME).getString();	
		this.members = new ArrayList<String>();
		
		for(Value v : node.getProperty(MEMBERS).getValues()) {
			   if(v!=null){
				   this.members.add(v.toString());
			   }
		}  
	}

	public JCRAccountingEntryModifyACL(String user, Calendar date, String nodeName, List<String> members) {
		super(user,date);

		this.itemName = nodeName;
		this.members = members;
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.SHARE;
	}

	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s]]",parentValue, getEntryType());
	}


	@Override
	public void save(Node entryNode) throws RepositoryException {
		super.save(entryNode);

		entryNode.setProperty(ITEM_NAME, itemName);	

		//corvert arrayList to Array
		String[] array = members.toArray(new String[members.size()]);

		entryNode.setProperty(MEMBERS, array);
		
		entryNode.getSession().save();

	}

	@Override
	public String getItemName() {		
		return itemName;
	}

	@Override
	public List<String> getMembers() {		
		return members;
	}

}
