/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeriesInfo;

public class HomeLibraryImporter {
    public static int errors = 0;
    public static int notImported = 0;

    public static void copyItem(Workspace newWorkspace, WorkspaceItem oldRoot, String newRoot) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, WrongItemTypeException {
        if (oldRoot.getChildren() == null) {
            return;
        }
        for (WorkspaceItem childItem : oldRoot.getChildren()) {
            WorkspaceItem item = HomeLibraryImporter.createJCRWorkspaceItem(newWorkspace, newRoot, childItem);
            if (item == null) continue;
            HomeLibraryImporter.copyItem(newWorkspace, childItem, item.getId());
        }
    }

    public static WorkspaceItem createJCRWorkspaceItem(Workspace newWorkspace, String destinationFolderId, WorkspaceItem oldItem) throws InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, InternalErrorException, WrongItemTypeException {
        switch (oldItem.getType()) {
            case FOLDER: {
                try {
                    return newWorkspace.createFolder(oldItem.getName(), oldItem.getDescription(), destinationFolderId);
                }
                catch (ItemAlreadyExistException e) {
                    System.err.println("Item " + oldItem.getName() + " already exists");
                    return newWorkspace.find(oldItem.getName(), destinationFolderId);
                }
            }
            case FOLDER_ITEM: {
                return HomeLibraryImporter.createJCRWorkspaceFolderItem(newWorkspace, destinationFolderId, (FolderItem)oldItem);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorkspaceItem createJCRWorkspaceFolderItem(Workspace newWorkspace, String destinationFolderId, FolderItem oldItem) {
        try {
            switch (oldItem.getFolderItemType()) {
                case EXTERNAL_FILE: {
                    ExternalFile file = (ExternalFile)oldItem;
                    try {
                        return newWorkspace.createExternalFile(file.getName(), file.getDescription(), file.getMimeType(), file.getData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + file.getName());
                    }
                }
                case EXTERNAL_IMAGE: {
                    ExternalImage image = (ExternalImage)oldItem;
                    try {
                        return newWorkspace.createExternalImage(image.getName(), image.getDescription(), image.getMimeType(), image.getData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + image.getName());
                    }
                }
                case EXTERNAL_PDF_FILE: {
                    ExternalPDFFile pdfFile = (ExternalPDFFile)oldItem;
                    try {
                        return newWorkspace.createExternalPDFFile(pdfFile.getName(), pdfFile.getDescription(), pdfFile.getMimeType(), pdfFile.getData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + pdfFile.getName());
                    }
                }
                case EXTERNAL_URL: {
                    ExternalUrl url = (ExternalUrl)oldItem;
                    try {
                        return newWorkspace.createExternalUrl(url.getName(), url.getDescription(), url.getUrl(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + url.getName());
                    }
                }
                case AQUAMAPS_ITEM: {
                    AquaMapsItem aquaMapsItem = (AquaMapsItem)oldItem;
                    List images = aquaMapsItem.getImages();
                    HashMap<String, InputStream> map = new HashMap<String, InputStream>();
                    Iterator iterator = images.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            try {
                                return newWorkspace.createAquaMapsItem(aquaMapsItem.getName(), aquaMapsItem.getDescription(), aquaMapsItem.getMapName(), aquaMapsItem.getMapType(), aquaMapsItem.getAuthor(), aquaMapsItem.getNumberOfSpecies(), aquaMapsItem.getBoundingBox(), aquaMapsItem.getPsoThreshold(), aquaMapsItem.getNumberOfGeneratedImages(), aquaMapsItem.getMetadata().getData(), map, destinationFolderId);
                            }
                            catch (ItemAlreadyExistException e) {
                                System.err.println("File found " + aquaMapsItem.getName());
                                break;
                            }
                        }
                        Image img = (Image)iterator.next();
                        map.put(img.getName(), img.getData());
                    }
                }
                case GCUBE_ITEM: {
                    GCubeItem gcubeItem = (GCubeItem)oldItem;
                    try {
                        return newWorkspace.createGcubeItem(gcubeItem.getName(), gcubeItem.getDescription(), gcubeItem.getScopes(), gcubeItem.getCreator(), gcubeItem.getItemType(), gcubeItem.getItemProperties(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("object found" + gcubeItem.getName());
                    }
                }
                case TIME_SERIES: {
                    TimeSeries ts = (TimeSeries)oldItem;
                    TimeSeriesInfo infos = ts.getTimeSeriesInfo();
                    try {
                        return newWorkspace.createTimeSeries(ts.getName(), ts.getDescription(), infos.getId(), infos.getTitle(), infos.getCreator(), infos.getDescription(), infos.getCreationDate(), infos.getPublisher(), infos.getSourceId(), infos.getSourceName(), infos.getRights(), infos.getDimension(), ts.getHeaderLabels(), ts.getCompressedData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + ts.getName());
                    }
                }
                case QUERY: {
                    Query query = (Query)oldItem;
                    try {
                        return newWorkspace.createQuery(query.getName(), query.getDescription(), query.getQuery(), query.getQueryType(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + query.getName());
                    }
                }
                case REPORT: {
                    Report report = (Report)oldItem;
                    try {
                        return newWorkspace.createReport(report.getName(), report.getDescription(), report.getCreated(), report.getLastEdit(), report.getAuthor(), report.getLastEditBy(), report.getTemplateName(), report.getNumberOfSections(), report.getStatus(), report.getData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + oldItem.getName());
                    }
                }
                case REPORT_TEMPLATE: {
                    ReportTemplate reportTemplate = (ReportTemplate)oldItem;
                    try {
                        return newWorkspace.createReportTemplate(reportTemplate.getName(), reportTemplate.getDescription(), reportTemplate.getCreated(), reportTemplate.getLastEdit(), reportTemplate.getAuthor(), reportTemplate.getLastEditBy(), reportTemplate.getNumberOfSections(), reportTemplate.getStatus(), reportTemplate.getData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + reportTemplate.getName());
                    }
                }
                case WORKFLOW_REPORT: {
                    WorkflowReport workflowReport = (WorkflowReport)oldItem;
                    try {
                        return newWorkspace.createWorkflowReport(workflowReport.getName(), workflowReport.getDescription(), workflowReport.getWorkflowId(), workflowReport.getWorkflowStatus(), workflowReport.getWorkflowData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + workflowReport.getName());
                    }
                }
                case WORKFLOW_TEMPLATE: {
                    WorkflowTemplate w = (WorkflowTemplate)oldItem;
                    try {
                        return newWorkspace.createWorkflowTemplate(w.getName(), w.getDescription(), w.getWorkflowId(), w.getWorkflowStatus(), w.getWorkflowData(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + w.getName());
                    }
                }
                case DOCUMENT: {
                    Document document = (Document)oldItem;
                    if (document.getData() == null) {
                        System.err.println("DATA is null");
                        return null;
                    }
                    HashMap<String, String> mapMetadata = new HashMap();
                    Iterator iterator = document.getMetadata().entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            try {
                                return newWorkspace.createDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                            }
                            catch (ItemAlreadyExistException e) {
                                System.err.println("File found " + document.getName());
                                break;
                            }
                        }
                        Map.Entry entry = iterator.next();
                        mapMetadata.put((String)entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                }
                case IMAGE_DOCUMENT: {
                    Document document = (ImageDocument)oldItem;
                    HashMap<String, String> mapMetadata = new HashMap<String, String>();
                    Iterator iterator = document.getMetadata().entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            try {
                                return newWorkspace.createImageDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                            }
                            catch (ItemAlreadyExistException e) {
                                System.err.println("File found " + document.getName());
                                break;
                            }
                        }
                        Map.Entry entry = iterator.next();
                        mapMetadata.put((String)entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                }
                case PDF_DOCUMENT: {
                    Document document = (PDFDocument)oldItem;
                    HashMap<String, String> mapMetadata = new HashMap();
                    Iterator iterator = document.getMetadata().entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            try {
                                return newWorkspace.createPDFDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                            }
                            catch (ItemAlreadyExistException e) {
                                System.err.println("File found " + document.getName());
                                break;
                            }
                        }
                        Map.Entry entry = iterator.next();
                        mapMetadata.put((String)entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                }
                case URL_DOCUMENT: {
                    Document document = (UrlDocument)oldItem;
                    HashMap<String, String> mapMetadata = new HashMap();
                    Iterator iterator = document.getMetadata().entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            try {
                                return newWorkspace.createUrlDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(), document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
                            }
                            catch (ItemAlreadyExistException e) {
                                System.err.println("File found " + document.getName());
                                break;
                            }
                        }
                        Map.Entry entry = iterator.next();
                        mapMetadata.put((String)entry.getKey(), ((DocumentMetadata)entry.getValue()).getXML());
                    }
                }
                case METADATA: {
                    Metadata metadata = (Metadata)oldItem;
                    try {
                        return newWorkspace.createMetadata(metadata.getName(), metadata.getDescription(), metadata.getURI(), metadata.getSchema(), metadata.getLanguage(), metadata.getData(), metadata.getCollectionName(), destinationFolderId);
                    }
                    catch (ItemAlreadyExistException e) {
                        System.err.println("File found " + metadata.getName());
                        break;
                    }
                }
            }
            System.err.println("ITEM is not been imported " + oldItem.getFolderItemType());
            ++notImported;
            return null;
        }
        catch (Exception e) {
            try {
                System.err.println("Item " + oldItem.getName() + " not imported");
            }
            catch (InternalErrorException internalErrorException) {
                // empty catch block
            }
            ++errors;
            return null;
        }
    }
}

