package org.gcube.common.homelibrary.jcr.workspace;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRWorkspaceSmartFolder extends JCRWorkspaceFolderItem implements WorkspaceSmartFolder {
	
	private static final String NT_CONTENT		= "nthl:smartFolderContent";
	private static final String QUERY 			= "hl:query";

	private final String query;
	
	public JCRWorkspaceSmartFolder(JCRWorkspace workspace, Node node) throws RepositoryException,
	InternalErrorException{
		super(workspace, node);
		
		Node contentNode = node.getNode(CONTENT);
		this.query = contentNode.getProperty(QUERY).getString();
	}
	
	public JCRWorkspaceSmartFolder(JCRWorkspace workspace, Node node, String name,
			String description, String query) throws RepositoryException  {
		super(workspace, node, name, description);
			
		this.query = query;
		
		Node nodeContent;
		nodeContent = node.addNode(CONTENT, NT_CONTENT);
		nodeContent.setProperty(QUERY,query);
		
	}


	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.SMART_FOLDER;
	}

	@Override
	public List<? extends WorkspaceItem> getChildren()
			throws InternalErrorException {
		
		return null;
	}


	@Override
	public FolderItemType getFolderItemType() {
		return null;
	}


	@Override
	public long getLength() throws InternalErrorException {
		return 0;
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public List<? extends SearchItem> getSearchItems()
			throws InternalErrorException {
		
		return workspace.searchByName(query);

	}

	@Override
	public String getMimeType() throws InternalErrorException {
		return null;
	}

}
