/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryType;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceSharedFolder
extends JCRAbstractWorkspaceFolder
implements WorkspaceSharedFolder {
    public static final String USERS = "hl:users";
    public static final String MEMBERS = "hl:members";
    public static final String IS_VRE_FOLDER = "hl:isVreFolder";
    public static final String DISPLAY_NAME = "hl:displayName";
    private static final String READ_ONLY = "jcr:read";
    private static final String WRITE_OWNER = "jcr:write";
    private static final String WRITE_ALL = "hl:writeAll";
    private static final String ADMINISTRATOR = "jcr:all";
    private String applicationName;
    private String destinationFolderId;
    private boolean isVreFolder;
    private String displayName;
    private String absPath;
    private String itemName;
    private List<String> users;

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        this.absPath = node.getPath();
        try {
            this.isVreFolder = node.getProperty(IS_VRE_FOLDER).getBoolean();
        }
        catch (Exception e) {
            this.isVreFolder = false;
        }
        try {
            this.displayName = node.getProperty(DISPLAY_NAME).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = this.listUsers(users);
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName, String displayName, boolean isVreFolder) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = this.listUsers(users);
        this.displayName = displayName;
        this.isVreFolder = isVreFolder;
        this.absPath = node.getPath();
        node.setProperty(IS_VRE_FOLDER, isVreFolder);
        node.setProperty(DISPLAY_NAME, displayName);
        node.getSession().save();
    }

    private List<String> listUsers(List<String> usersList) throws InternalErrorException {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        JCRUserManager userManager = new JCRUserManager();
        List<GCubeGroup> groupsList = userManager.getGroups();
        for (GCubeGroup group : groupsList) {
            groups.add(group.getName());
        }
        Session session = JCRRepository.getSession();
        try {
            try {
                for (String user : usersList) {
                    block12: {
                        Node sharedNode = session.getNodeByIdentifier(this.getId());
                        Node memberIds = null;
                        try {
                            memberIds = sharedNode.getNode(MEMBERS);
                        }
                        catch (Exception e) {
                            memberIds = sharedNode.addNode(MEMBERS);
                            session.save();
                            logger.warn(" Members_ids Node already exists");
                        }
                        try {
                            memberIds.getNode(user);
                        }
                        catch (Exception e) {
                            if (user.endsWith("-Manager")) break block12;
                            memberIds.addNode(user);
                            session.save();
                            logger.warn(String.valueOf(user) + " add to membersList");
                        }
                    }
                    if (groups.contains(user)) {
                        List<String> userList = this.workspace.resolveGroupId(user);
                        users.addAll(userList);
                        continue;
                    }
                    users.add(user);
                }
                session.save();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
        return users;
    }

    @Override
    public void save(Node node) throws RepositoryException {
        try {
            this.addUser(node, this.workspace.getOwner().getPortalLogin(), this.destinationFolderId);
            logger.trace("Share with " + this.users.toString());
            for (String user : this.users) {
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                Home home = homeManager.getHome(user);
                if (this.applicationName == null) {
                    if (this.isVreFolder()) {
                        this.addUser(node, user, home.getWorkspace().getMySpecialFolders().getId());
                        continue;
                    }
                    this.addUser(node, user, home.getWorkspace().getRoot().getId());
                    continue;
                }
                this.addUser(node, user, home.getDataArea().getApplicationRoot(this.applicationName).getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    public Node getUserNode(Node node, String user) throws RepositoryException, InternalErrorException {
        Node usersNode = node.getNode(USERS);
        logger.trace("Looking for user: " + user + " in node: " + usersNode.getPath());
        String value = usersNode.getProperty(user).getString();
        String[] values = value.split(this.workspace.getPathSeparator());
        if (values.length < 2) {
            throw new InternalErrorException("Path node corrupt");
        }
        String parentId = values[0];
        String nodeName = values[1];
        Node parentNode = node.getSession().getNodeByIdentifier(parentId);
        return node.getSession().getNode(String.valueOf(parentNode.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)nodeName));
    }

    private Node getUserNode(Node node) throws RepositoryException, InternalErrorException {
        return this.getUserNode(node, this.workspace.getOwner().getPortalLogin());
    }

    private String getNodeName(Node node) throws RepositoryException, InternalErrorException {
        String[] names = node.getPath().split(this.workspace.getPathSeparator());
        return names[names.length - 1];
    }

    @Override
    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            Node userNode = this.getUserNode(node);
            if (this.workspace.exists(nodeNewName, userNode.getParent().getIdentifier())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = String.valueOf(userNode.getParent().getPath()) + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.RENAMED.toString());
            node.getSession().save();
            String path = userNode.getPath();
            node.getSession().getWorkspace().move(path, newPath);
            Node usersNode = node.getNode(USERS);
            String value = String.valueOf(userNode.getParent().getIdentifier()) + this.workspace.getPathSeparator() + newName;
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier());
            Session session = destinationFolderNode.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            Node userNode = this.getUserNode(node);
            String userNodeName = this.getNodeName(userNode);
            String newPath = String.valueOf(destinationFolderNode.getPath()) + this.workspace.getPathSeparator() + userNodeName;
            String value = String.valueOf(destinationFolderNode.getIdentifier()) + this.workspace.getPathSeparator() + userNodeName;
            session.getWorkspace().clone(session.getWorkspace().getName(), node.getPath(), newPath, false);
            Node usersNode = node.getNode(USERS);
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            session.removeItem(userNode.getPath());
            session.save();
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Node unShareNode(Node sharedNode, Node destinationNode, boolean localCopy) throws RepositoryException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException, ItemNotFoundException, RemoteBackendException {
        logger.debug("unShare Node: " + sharedNode.getPath() + " -  by user: " + this.workspace.getOwner().getPortalLogin());
        Session session = sharedNode.getSession();
        Node userNode = this.getUserNode(sharedNode);
        String folderName = this.getNodeName(userNode);
        String description = this.getDescription();
        if (destinationNode.getIdentifier().equals(userNode.getParent().getIdentifier())) {
            this.removeUserSharedFolder(sharedNode);
        }
        if (localCopy) {
            String unSharedFolderId = this.workspace.createFolder(folderName, description, destinationNode.getIdentifier()).getId();
            Node nodeFolder = session.getNodeByIdentifier(unSharedFolderId);
            NodeIterator iterator = sharedNode.getNodes();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
                session.getWorkspace().copy(child.getPath(), String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + child.getName());
            }
            logger.debug("copyremotecontent from " + nodeFolder.getPath() + " to " + destinationNode.getPath());
            this.workspace.copyRemoteContent(nodeFolder, destinationNode);
            session.save();
            JCRWorkspaceItem itemUnshared = (JCRWorkspaceItem)this.workspace.getItem(unSharedFolderId);
            itemUnshared.setUnshareHistory(this.workspace.getOwner().getPortalLogin());
            itemUnshared.setOwnerToCurrentUser(itemUnshared);
            return nodeFolder;
        }
        return null;
    }

    @Override
    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Session session = nodeFolder.getSession();
        Node node = session.getNodeByIdentifier(this.identifier);
        String pathNewNode = String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (session.getNode(pathNewNode) != null) {
                throw new ItemAlreadyExistException(String.valueOf(newName) + " already exist");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        String description = this.getDescription();
        try {
            String unSharedFolderId = this.workspace.createFolder(Text.escapeIllegalJcrChars((String)newName), description, nodeFolder.getIdentifier()).getId();
            Node newNodeFolder = session.getNodeByIdentifier(unSharedFolderId);
            NodeIterator iterator = node.getNodes();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
                session.getWorkspace().copy(child.getPath(), String.valueOf(newNodeFolder.getPath()) + this.workspace.getPathSeparator() + child.getName());
            }
            return newNodeFolder;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRAbstractWorkspaceFolder jCRAbstractWorkspaceFolder = this.workspace.getParent(this.getUserNode(node));
            return jCRAbstractWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        Node userNode = this.getUserNode(node);
        return String.valueOf(((JCRWorkspaceFolder)this.getParent(userNode)).getPath(userNode.getParent())) + this.workspace.getPathSeparator() + this.getNodeName(userNode);
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        logger.debug("remove shared");
        logger.debug("portalLogin: " + this.workspace.getOwner().getPortalLogin() + " - owner: " + this.getOwner().getPortalLogin());
        Session session = JCRRepository.getSession();
        try {
            try {
                Node sharedNode = session.getNodeByIdentifier(this.getId());
                if (!JCRPrivilegesInfo.canDelete(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getSharePath(), true)) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node");
                }
                if (this.isVreFolder()) {
                    throw new InternalErrorException("A VRE folder cannot be removed");
                }
                if (sharedNode.getPath().equals(this.workspace.mySpecialFoldersPath)) {
                    throw new InternalErrorException("This folder cannot be removed");
                }
                try {
                    WorkspaceFolder unsharedFolder = this.unShare();
                    logger.trace("unsharedFolder: " + unsharedFolder.getPath());
                    Node usharedNode = session.getNodeByIdentifier(unsharedFolder.getId());
                    this.workspace.moveToTrash(usharedNode);
                    session.save();
                }
                catch (ItemAlreadyExistException | ItemNotFoundException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                    throw new InternalErrorException(e);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RemoteBackendException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public List<String> getMembers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                Node members = node.getNode(MEMBERS);
                NodeIterator children = members.getNodes();
                while (children.hasNext()) {
                    String name = children.nextNode().getName();
                    if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                    list.add(name);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
        return list;
    }

    @Override
    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                Node usersNode = node.getNode(USERS);
                PropertyIterator iterator = usersNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    String name = property.getName();
                    if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                    list.add(name);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
        return list;
    }

    private void addUser(Node sharedNode, String user, String destinationFolderId) throws InternalErrorException, RepositoryException {
        logger.trace("addUser(" + sharedNode.getPath() + ", " + user + ", " + destinationFolderId + ");");
        Session session = sharedNode.getSession();
        try {
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            WorkspaceFolder userRoot = (WorkspaceFolder)homeManager.getHome(user).getWorkspace().getItem(destinationFolderId);
            Node rootNode = session.getNodeByIdentifier(userRoot.getId());
            String sharedFolderName = WorkspaceUtil.getUniqueName((String)sharedNode.getProperty("jcr:title").getString(), (WorkspaceFolder)userRoot);
            String pathUser = null;
            Node usersNode = sharedNode.getNode(USERS);
            if (this.applicationName != null) {
                pathUser = String.valueOf(rootNode.getPath()) + this.workspace.getPathSeparator() + sharedFolderName;
                session.getWorkspace().clone(session.getWorkspace().getName(), String.valueOf(sharedNode.getPath()) + this.workspace.getPathSeparator() + this.itemName, pathUser, false);
                logger.trace("clone from " + sharedNode.getPath() + this.workspace.getPathSeparator() + this.itemName + " to " + pathUser);
                session.save();
            } else {
                pathUser = String.valueOf(rootNode.getPath()) + this.workspace.getPathSeparator() + sharedFolderName;
                try {
                    if (usersNode.getProperty(user) != null) {
                        return;
                    }
                }
                catch (PathNotFoundException e) {
                    logger.debug("User is not present");
                }
                session.getWorkspace().clone(session.getWorkspace().getName(), sharedNode.getPath(), pathUser, false);
                logger.trace("Clone from " + sharedNode.getPath() + " to " + pathUser);
                session.save();
            }
            String value = String.valueOf(userRoot.getId()) + this.workspace.getPathSeparator() + sharedFolderName;
            logger.trace("usersNode: " + usersNode.getPath() + " - set value " + value + " to: " + user);
            usersNode.setProperty(user, value);
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addUser(String user) throws InsufficientPrivilegesException, InternalErrorException {
        session = JCRRepository.getSession();
        try {
            sharedNode = session.getNodeByIdentifier(this.getId());
            usersNode = sharedNode.getNode("hl:users");
            try {
                if (usersNode.getProperty(user) != null) {
                    return;
                }
                ** GOTO lbl13
            }
            catch (PathNotFoundException e) {
                try {
                    JCRWorkspaceSharedFolder.logger.debug("User " + user + " is not present");
lbl13:
                    // 2 sources

                    homeManager = this.workspace.getHome().getHomeManager();
                    home = homeManager.getHome(user);
                    if (this.isVreFolder) {
                        this.addUser(sharedNode, user, home.getWorkspace().getMySpecialFolders().getId());
                    } else {
                        this.addUser(sharedNode, user, home.getWorkspace().getRoot().getId());
                    }
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
        }
        finally {
            session.logout();
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.SHARED_FOLDER;
    }

    public WorkspaceFolder unShare() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = this.getUserNode(node);
            Node unsharedNode = null;
            JCRWorkspaceFolder folder = null;
            boolean flag = false;
            if (this.getOwner().getPortalLogin().equals(this.workspace.getOwner().getPortalLogin()) || this.getACLUser().equals((Object)ACLType.ADMINISTRATOR)) {
                flag = true;
            }
            try {
                unsharedNode = this.unShareNode(node, userNode.getParent(), flag);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (unsharedNode != null) {
                folder = new JCRWorkspaceFolder(this.workspace, unsharedNode);
                logger.trace("remove clones");
                this.removeClones(node);
                logger.trace("remove sharedNode: " + node.getPath());
                node.remove();
                session.save();
            } else {
                JCRAccessManager accessManager = new JCRAccessManager();
                ArrayList<String> userToRemove = new ArrayList<String>();
                userToRemove.add(this.workspace.getOwner().getPortalLogin());
                accessManager.deleteAces(this.getSharePath(), userToRemove);
            }
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceFolder unShare(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = node.getNode(USERS);
            if (!(user.startsWith("jcr:") || user.startsWith("hl:") || user.equals(this.workspace.getOwner().getPortalLogin()))) {
                try {
                    Node cloneNode = this.getUserNode(node, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    session.removeItem(cloneNode.getPath());
                    session.save();
                }
                catch (Exception e) {
                    logger.error("Error removing clone ");
                }
                try {
                    userNode.setProperty(user, null);
                    userNode.getSession().save();
                    logger.trace(String.valueOf(user) + "  deleted from share " + node.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users ");
                }
            }
            JCRAccessManager accessManager = new JCRAccessManager();
            ArrayList<String> userToRemove = new ArrayList<String>();
            userToRemove.add(user);
            accessManager.deleteAces(this.getSharePath(), userToRemove);
            this.setUnshareHistory(user);
            return null;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceSharedFolder share(List<String> usersList) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        List<String> userIds = this.listUsers(usersList);
        for (String user : userIds) {
            this.addUser(user);
        }
        return this;
    }

    public String getName(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode, user);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getSharePath() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String string = session.getNodeByIdentifier(this.identifier).getPath();
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setACL(List<String> users, ACLType privilege) throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            absPath = this.getSharePath();
            switch (privilege) {
                case READ_ONLY: {
                    accessManager.setReadOnlyACL(users, absPath);
                    break;
                }
                case WRITE_OWNER: {
                    accessManager.setWriteOwnerACL(users, absPath);
                    break;
                }
                case WRITE_ALL: {
                    accessManager.setWriteAllACL(users, absPath);
                    break;
                }
                case ADMINISTRATOR: {
                    accessManager.setAdminACL(users, absPath);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        if (!this.isVreFolder()) {
            ArrayList<String> userList = null;
            try {
                userList = new ArrayList<String>();
                userList.add(this.workspace.getOwner().getPortalLogin());
                accessManager.setAdminACL(userList, absPath);
            }
            catch (Exception e) {
                logger.error("Error setting owner as administator");
            }
        }
    }

    public void deleteACL(List<String> users) throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            absPath = this.getSharePath();
            accessManager.deleteAces(absPath, users);
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
    }

    private void setAcesHistory() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                if (!node.hasNode("hl:accounting")) {
                    node.addNode("hl:accounting", "nthl:accountingSet");
                    session.save();
                }
                logger.trace("Update History: Node " + node.getPath() + " ACEs modified");
                Node parentNode = node.getParent();
                String user = this.workspace.getOwner().getPortalLogin();
                Node accounting = node.getNode("hl:accounting");
                logger.info("Setting " + node.getName() + " as read in " + node.getPath());
                JCRAccountingEntryRead entry = new JCRAccountingEntryRead(user, Calendar.getInstance(), node.getName());
                entry.save(accounting.addNode(UUID.randomUUID().toString(), JCRAccountingEntryType.READ.getNodeTypeDefinition()));
                session.save();
                try {
                    logger.info("Mark Parent Node " + parentNode.getPath() + " As Read ");
                    Node accountingParentNode = parentNode.getNode("hl:accounting");
                    JCRAccountingEntryRead entryParent = new JCRAccountingEntryRead(user, Calendar.getInstance(), node.getName());
                    entryParent.save(accountingParentNode.addNode(UUID.randomUUID().toString(), JCRAccountingEntryType.READ.getNodeTypeDefinition()));
                    session.save();
                    logger.info("Set " + node.getName() + " as read in " + parentNode.getPath());
                }
                catch (Exception e) {
                    logger.info("Error setting " + node.getName() + " as read in " + parentNode.getPath());
                }
                session.save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public Map<ACLType, List<String>> getACLOwner() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        HashMap<ACLType, List<String>> map = new HashMap<ACLType, List<String>>();
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getSharePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty()) continue;
                    List<String> acl = aclMap.get(user);
                    ACLType aclType = this.getACLTypeByKey(aclMap.get(user));
                    List users = null;
                    try {
                        users = (List)map.get(aclType);
                        users.add(user);
                        map.put(aclType, users);
                    }
                    catch (Exception e) {
                        map.put(aclType, (List<String>)new ArrayList<String>(user){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add(string);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return map;
    }

    private ACLType getACLTypeByKey(List<String> list) {
        switch (list.get(0)) {
            case "jcr:read": {
                return ACLType.READ_ONLY;
            }
            case "jcr:write": {
                return ACLType.WRITE_OWNER;
            }
            case "hl:writeAll": {
                return ACLType.WRITE_ALL;
            }
            case "jcr:all": {
                return ACLType.ADMINISTRATOR;
            }
        }
        return ACLType.READ_ONLY;
    }

    public void removeClones(Node sharedNode) throws InternalErrorException, RepositoryException {
        Session session = sharedNode.getSession();
        try {
            Node userNode = sharedNode.getNode(USERS);
            PropertyIterator usersList = userNode.getProperties();
            while (usersList.hasNext()) {
                String user = usersList.nextProperty().getName();
                if (user.startsWith("jcr:")) continue;
                logger.trace("user " + user);
                logger.trace("workspace.getOwner().getPortalLogin() " + this.workspace.getOwner().getPortalLogin());
                if (user.startsWith("jcr:") || user.startsWith("hl:")) continue;
                try {
                    Node cloneNode = this.getUserNode(sharedNode, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    session.removeItem(cloneNode.getPath());
                    session.save();
                }
                catch (Exception e) {
                    logger.error("Error removing clone " + e);
                }
                try {
                    logger.trace("remove user in userList");
                    logger.trace(String.valueOf(user) + "  deleted from share " + sharedNode.getPath());
                    userNode.setProperty(user, null);
                    userNode.getSession().save();
                    logger.trace(String.valueOf(user) + "  deleted from share " + sharedNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users " + e);
                }
                try {
                    Node memberNode = sharedNode.getNode(MEMBERS);
                    memberNode.getNode(user).remove();
                    memberNode.getSession().save();
                }
                catch (Exception e) {
                    logger.error("Error removing user from members node");
                }
            }
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeUserSharedFolder(Node sharedNode) throws InternalErrorException, RepositoryException {
        Session session = sharedNode.getSession();
        try {
            Node userNode = this.getUserNode(sharedNode);
            session.removeItem(userNode.getPath());
            session.save();
            try {
                Node usersNode = sharedNode.getNode(USERS);
                usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), null);
                usersNode.getSession().save();
            }
            catch (Exception e) {
                logger.error("Error removing user from users node");
            }
            try {
                Node memberNode = sharedNode.getNode(MEMBERS);
                memberNode.getNode(this.workspace.getOwner().getPortalLogin()).remove();
                memberNode.getSession().save();
            }
            catch (Exception e) {
                logger.error("Error removing user from members node");
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isVreFolder() {
        return this.isVreFolder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ACLType getACLUser() throws InternalErrorException {
        return JCRPrivilegesInfo.getACLByUser(this.workspace.getOwner().getPortalLogin(), this.getAbsPath());
    }

    private String getAbsPath() {
        return this.absPath;
    }
}

