/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.AccessControlUtil;

public class JCRPrivilegesInfo {
    private static final String NO_LIMIT = "hl:noOwnershipLimit";
    private static final String REMOVE_ROOT = "hl:removeSharedRoot";

    public Privilege[] getSupportedPrivileges(Node node) throws RepositoryException {
        return this.getSupportedPrivileges(node.getSession(), node.getPath());
    }

    public Privilege[] getSupportedPrivileges(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
        Privilege[] supportedPrivileges = accessControlManager.getSupportedPrivileges(absPath);
        return supportedPrivileges;
    }

    public Map<Principal, AccessRights> getDeclaredAccessRights(Node node) throws RepositoryException {
        Map<Principal, AccessRights> accessRights = this.getDeclaredAccessRights(node.getSession(), node.getPath());
        return accessRights;
    }

    public Map<Principal, AccessRights> getDeclaredAccessRights(Session session, String absPath) throws RepositoryException {
        LinkedHashMap<Principal, AccessRights> accessMap = new LinkedHashMap<Principal, AccessRights>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            for (AccessControlEntry ace : entries) {
                boolean allow;
                Principal principal = ace.getPrincipal();
                AccessRights accessPrivileges = (AccessRights)accessMap.get(principal);
                if (accessPrivileges == null) {
                    accessPrivileges = new AccessRights();
                    accessMap.put(principal, accessPrivileges);
                }
                if (allow = AccessControlUtil.isAllow(ace)) {
                    accessPrivileges.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                    continue;
                }
                accessPrivileges.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
            }
        }
        return accessMap;
    }

    private AccessControlEntry[] getDeclaredAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
        for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            return accessControlEntries;
        }
        return new AccessControlEntry[0];
    }

    public AccessRights getDeclaredAccessRightsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getDeclaredAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public AccessRights getDeclaredAccessRightsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        AccessRights rights = new AccessRights();
        if (principalId != null && principalId.length() > 0) {
            AccessControlPolicy[] policies;
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
            for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
                AccessControlEntry[] accessControlEntries;
                if (!(accessControlPolicy instanceof AccessControlList)) continue;
                for (AccessControlEntry ace : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                    if (!principalId.equals(ace.getPrincipal().getName())) continue;
                    boolean isAllow = AccessControlUtil.isAllow(ace);
                    if (isAllow) {
                        rights.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                        continue;
                    }
                    rights.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
                }
            }
        }
        return rights;
    }

    public Map<Principal, AccessRights> getEffectiveAccessRights(Node node) throws RepositoryException {
        Map<Principal, AccessRights> accessRights = this.getEffectiveAccessRights(node.getSession(), node.getPath());
        return accessRights;
    }

    public Map<Principal, AccessRights> getEffectiveAccessRights(Session session, String absPath) throws RepositoryException {
        LinkedHashMap<Principal, AccessRights> accessMap = new LinkedHashMap<Principal, AccessRights>();
        AccessControlEntry[] entries = this.getEffectiveAccessControlEntries(session, absPath);
        if (entries != null) {
            for (AccessControlEntry ace : entries) {
                boolean allow;
                Principal principal = ace.getPrincipal();
                AccessRights accessPrivleges = (AccessRights)accessMap.get(principal);
                if (accessPrivleges == null) {
                    accessPrivleges = new AccessRights();
                    accessMap.put(principal, accessPrivleges);
                }
                if (allow = AccessControlUtil.isAllow(ace)) {
                    accessPrivleges.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                    continue;
                }
                accessPrivleges.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
            }
        }
        return accessMap;
    }

    private AccessControlEntry[] getEffectiveAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
        for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getEffectivePolicies(absPath)) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            return accessControlEntries;
        }
        return new AccessControlEntry[0];
    }

    public AccessRights getEffectiveAccessRightsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getEffectiveAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public AccessRights getEffectiveAccessRightsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        AccessRights rights = new AccessRights();
        if (principalId != null && principalId.length() > 0) {
            AccessControlPolicy[] policies;
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
            for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getEffectivePolicies(absPath)) {
                AccessControlEntry[] accessControlEntries;
                if (!(accessControlPolicy instanceof AccessControlList)) continue;
                for (AccessControlEntry ace : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                    if (!principalId.equals(ace.getPrincipal().getName())) continue;
                    boolean isAllow = AccessControlUtil.isAllow(ace);
                    if (isAllow) {
                        rights.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                        continue;
                    }
                    rights.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
                }
            }
        }
        return rights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canAddChildren(String user, String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession(user);
        try {
            System.out.println("getPrincipal " + session.getUserID());
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
            boolean bl = accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")});
            return bl;
        }
        catch (RepositoryException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDeleteChildren(String user, String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession(user);
        try {
            boolean bl = JCRPrivilegesInfo.canDeleteChildren(session, absPath);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    private static boolean canDeleteChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"), accessControlManager.privilegeFromName(NO_LIMIT)});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDelete(String owner, String currentUser, String absPath, boolean root) throws InternalErrorException {
        System.out.println("user: " + currentUser + " - on node: " + absPath + " - owner: " + owner);
        if (owner.equals(currentUser)) {
            return true;
        }
        Session session = JCRRepository.getSession(currentUser);
        System.out.println("session.getUserID(): " + session.getUserID());
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
            System.out.println("after");
            int lastSlash = absPath.lastIndexOf(47);
            String parentPath = lastSlash == 0 ? "/" : absPath.substring(0, lastSlash);
            System.out.println("before check");
            try {
                accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode")});
            }
            catch (Exception e) {
                System.out.println(e);
            }
            System.out.println("has");
            boolean canDelete = false;
            canDelete = root ? accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"), accessControlManager.privilegeFromName(NO_LIMIT), accessControlManager.privilegeFromName(REMOVE_ROOT)}) : accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"), accessControlManager.privilegeFromName(NO_LIMIT)}) && JCRPrivilegesInfo.canDeleteChildren(session, parentPath);
            System.out.println("canDelete? " + canDelete);
            System.out.println("canDeleteChildren? " + JCRPrivilegesInfo.canDeleteChildren(session, parentPath));
            boolean bl = canDelete;
            return bl;
        }
        catch (RepositoryException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canModifyProperties(String owner, String currentUser, String absPath, boolean root) throws InternalErrorException {
        if (owner.equals(currentUser)) {
            return true;
        }
        Session session = JCRRepository.getSession(currentUser);
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
            boolean canDelete = false;
            canDelete = root ? accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), accessControlManager.privilegeFromName(NO_LIMIT), accessControlManager.privilegeFromName(REMOVE_ROOT)}) : accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), accessControlManager.privilegeFromName(NO_LIMIT)});
            boolean bl = canDelete;
            return bl;
        }
        catch (RepositoryException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    public static class AccessRights {
        private Set<Privilege> granted = new HashSet<Privilege>();
        private Set<Privilege> denied = new HashSet<Privilege>();
        private static transient ResourceBundle resBundle = null;

        private ResourceBundle getResourceBundle(Locale locale) {
            if (resBundle == null || !resBundle.getLocale().equals(locale)) {
                resBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".PrivilegesResources", locale);
            }
            return resBundle;
        }

        public Set<Privilege> getGranted() {
            return this.granted;
        }

        public Set<Privilege> getDenied() {
            return this.denied;
        }

        public String getPrivilegeSetDisplayName(Locale locale) {
            if (this.denied != null && !this.denied.isEmpty()) {
                return this.getResourceBundle(locale).getString("privilegeset.custom");
            }
            if (this.granted.isEmpty()) {
                return this.getResourceBundle(locale).getString("privilegeset.none");
            }
            if (this.granted.size() == 1) {
                Iterator<Privilege> iterator = this.granted.iterator();
                Privilege next = iterator.next();
                if ("jcr:all".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.all");
                }
                if ("jcr:read".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.readonly");
                }
            } else if (this.granted.size() == 2) {
                Iterator<Privilege> iterator = this.granted.iterator();
                Privilege next = iterator.next();
                Privilege next2 = iterator.next();
                if ("jcr:read".equals(next.getName()) && "jcr:write".equals(next2.getName()) || "jcr:read".equals(next2.getName()) && "jcr:write".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.readwrite");
                }
            }
            return this.getResourceBundle(locale).getString("privilegeset.custom");
        }
    }
}

