/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.usermanager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUserManager
implements UserManager {
    private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);
    public static String url;

    public JCRUserManager() {
        url = JCRRepository.url;
    }

    public List<GCubeGroup> getGroups() throws InternalErrorException {
        ArrayList<GCubeGroup> groupsList = null;
        List list = null;
        GetMethod getMethod = null;
        try {
            groupsList = new ArrayList<GCubeGroup>();
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/ListGroupsServlet");
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
            for (String group : list) {
                System.out.println("**** " + group);
                groupsList.add(new JCRGroup(group));
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return groupsList;
    }

    public GCubeGroup getGroup(String groupId) throws InternalErrorException {
        JCRGroup group = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/IsGroupServlet?groupName=" + groupId);
            httpClient.executeMethod((HttpMethod)getMethod);
            System.out.println("Response " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            Boolean found = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            if (found.booleanValue()) {
                group = new JCRGroup(groupId);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createGroup(String groupName) throws InternalErrorException {
        this.logger.debug("Create a new group: " + groupName);
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/CreateGroupServlet?groupName=" + groupName);
            httpClient.executeMethod((HttpMethod)getMethod);
            System.out.println("Response " + getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAuthorizable(String groupName) throws InternalErrorException {
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/DeleteAuthorizableServlet?groupName=" + groupName);
            httpClient.executeMethod((HttpMethod)getMethod);
            System.out.println("Response " + getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error removing User or group in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return true;
    }

    public List<String> getUsers() throws InternalErrorException {
        List users = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/ListUsersServlet");
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            users = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String name, String pass) throws InternalErrorException {
        Boolean created = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            System.out.println(url);
            getMethod = new GetMethod(url + "/CreateUserServlet?userName=" + name + "&pwd=" + pass);
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            created = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            System.out.println("Response " + created);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return created;
    }
}

