package org.gcube.common.homelibrary.jcr.workspace.usermanager;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.thoughtworks.xstream.XStream;

public class JCRUserManager implements UserManager{
	
	private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);
	
	public static String url;
	
	public JCRUserManager(){
		super();
		url = JCRRepository.url;
	}



	@SuppressWarnings("unchecked")
	@Override
	public List<GCubeGroup> getGroups() throws InternalErrorException {

		List<GCubeGroup> groupsList = null;
		List<String> list = null;
		GetMethod getMethod = null;
		try {
			groupsList =  new ArrayList<GCubeGroup>();
			HttpClient httpClient = new HttpClient();            

			getMethod =  new GetMethod(url + "/ListGroupsServlet");
			httpClient.executeMethod(getMethod);

			XStream xstream = new XStream();
			list= (List<String>) xstream.fromXML(getMethod.getResponseBodyAsString());
			
			for(String group: list){
				System.out.println("**** " + group);
				groupsList.add(new JCRGroup(group));
			}

		} catch (Exception e) {
			logger.error("Error retrieving Users in UserManager", e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}

		return groupsList;
	}


	@Override
	public GCubeGroup getGroup(String groupId) throws InternalErrorException {

		JCRGroup group = null;
		GetMethod getMethod = null;
		try {

			HttpClient httpClient = new HttpClient();            

			getMethod =  new GetMethod(url + "/IsGroupServlet?groupName=" + groupId );
			httpClient.executeMethod(getMethod);

			System.out.println("Response " + getMethod.getResponseBodyAsString());

			XStream xstream = new XStream();
			Boolean found = (Boolean) xstream.fromXML(getMethod.getResponseBodyAsString());
			
			if (found)
				group = new JCRGroup(groupId);
			
		} catch (Exception e) {
			logger.error("Error retrieving Users in UserManager", e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}
		
		//get return
		return group;	
	}

	@Override
	public boolean createGroup(String groupName)	throws InternalErrorException {
		logger.debug("Create a new group: "+ groupName);
		GetMethod getMethod = null;
		try {

			HttpClient httpClient = new HttpClient();            

			getMethod =  new GetMethod(url + "/CreateGroupServlet?groupName=" + groupName );
			httpClient.executeMethod(getMethod);

			System.out.println("Response " + getMethod.getResponseBodyAsString());

		} catch (Exception e) {
			logger.error("Error retrieving Users in UserManager", e);
			return false;
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}

		return true;
	}

	
	@Override
	public boolean deleteAuthorizable(String groupName) throws InternalErrorException {
		GetMethod getMethod = null;
		try {

			HttpClient httpClient = new HttpClient();            

			getMethod =  new GetMethod(url + "/DeleteAuthorizableServlet?groupName=" + groupName );
			httpClient.executeMethod(getMethod);

			System.out.println("Response " + getMethod.getResponseBodyAsString());

		} catch (Exception e) {
			logger.error("Error removing User or group in UserManager", e);
			return false;
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}
		return true;
		
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<String> getUsers() throws InternalErrorException {
		List<String> users = null;
		GetMethod getMethod = null;
		try {

			HttpClient httpClient = new HttpClient();            

			getMethod =  new GetMethod(url + "/ListUsersServlet");
			httpClient.executeMethod(getMethod);

			XStream xstream = new XStream();
			users= (List<String>) xstream.fromXML(getMethod.getResponseBodyAsString());
			
		} catch (Exception e) {
			logger.error("Error retrieving Users in UserManager", e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}
		return users;
	}




	@Override
	public boolean createUser(String name, String pass) throws InternalErrorException {
		Boolean created = false;
		GetMethod getMethod = null;
		try {

			HttpClient httpClient = new HttpClient();            
			System.out.println(url);

			getMethod =  new GetMethod(url + "/CreateUserServlet?userName=" + name +"&pwd="+ pass);
			httpClient.executeMethod(getMethod);
			
			XStream xstream = new XStream();
			created = (Boolean) xstream.fromXML(getMethod.getResponseBodyAsString());
			
			System.out.println("Response " + created);

		} catch (Exception e) {
			logger.error("Error retrieving Users in UserManager", e);
			return false;
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}
		
		return created;
	}



}
