/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRHomeManager
implements HomeManager {
    private Map<String, JCRUser> users = new LinkedHashMap<String, JCRUser>();
    private Map<String, JCRHome> userHomesLogged = new LinkedHashMap<String, JCRHome>();
    private HomeManagerFactory factory;
    private static Logger logger = LoggerFactory.getLogger(JCRHomeManager.class);

    public JCRHomeManager(HomeManagerFactory factory) {
        this.factory = factory;
    }

    public HomeManagerFactory getHomeManagerFactory() {
        return this.factory;
    }

    public List<User> getUsers() {
        return new LinkedList<User>(this.users.values());
    }

    public User getUser(String portalLogin) throws InternalErrorException {
        logger.info("getUser portalLogin: " + portalLogin);
        return this.createUser(portalLogin);
    }

    public synchronized boolean existUser(String portalLogin) throws InternalErrorException {
        logger.trace("existUser portalLogin: " + portalLogin);
        if (portalLogin == null) {
            logger.error("portalLogin null");
            throw new IllegalArgumentException("The portalLogin value is null");
        }
        return this.users.containsKey(portalLogin);
    }

    public synchronized User createUser(String portalLogin) throws InternalErrorException {
        JCRUser user = this.users.get(portalLogin);
        if (user == null) {
            logger.info("User " + portalLogin + " not found, creating a new one.");
            user = new JCRUser(UUID.randomUUID().toString(), portalLogin);
            try {
                this.getHome(user);
            }
            catch (Exception e) {
                logger.error("error creating home", (Throwable)e);
            }
            logger.info("User created: " + user);
            this.users.put(portalLogin, user);
        }
        return user;
    }

    public Home getHome(User user) throws InternalErrorException, HomeNotFoundException {
        JCRHome home;
        logger.info("getHome user: " + user);
        if (this.userHomesLogged.containsKey(user.getPortalLogin())) {
            logger.debug(" User is already logged");
            JCRHome home2 = this.userHomesLogged.get(user.getPortalLogin());
            return home2;
        }
        try {
            home = new JCRHome(this, (JCRUser)user);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        this.userHomesLogged.put(user.getPortalLogin(), home);
        logger.trace("User loaded.");
        return home;
    }

    public Home getHome(String portalLogin) throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.info("getHome portalLogin: " + portalLogin);
        User user = this.getUser(portalLogin);
        return this.getHome(user);
    }

    public synchronized void removeUser(User user) throws InternalErrorException {
        this.userHomesLogged.remove(user.getPortalLogin());
    }
}

