/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.client;

import org.gcube.common.homelibrary.client.Delete;
import org.gcube.common.homelibrary.client.ListFolder;
import org.gcube.common.homelibrary.client.Mkdir;
import org.gcube.common.homelibrary.client.Test;
import org.gcube.common.homelibrary.client.UploadFile;

public class EntryPoint {
    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length >= 1) {
            switch (args[0]) {
                case "mkdir": {
                    if (args.length != 2 && args.length != 4) {
                        System.out.println("Usage:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar mkdir foldername destinationFolder description\n\n");
                        System.out.println("Example:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar mkdir TestFolder mypath/user/myWorkspace 'my Folder' \n\n");
                        return;
                    }
                    String folderName = args[1];
                    String destinationPath = null;
                    if (args.length > 2) {
                        destinationPath = args[2];
                    }
                    String description = null;
                    if (args.length > 3) {
                        description = args[3];
                    }
                    new Mkdir(folderName, destinationPath, description);
                    break;
                }
                case "ls": {
                    if (args.length > 2) {
                        System.out.println("Usage:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar ls foldername\n\n");
                        System.out.println("Example:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar ls myPersonalFolder \n\n");
                        return;
                    }
                    String folderName = null;
                    if (args.length > 1) {
                        folderName = args[1];
                    }
                    new ListFolder(folderName);
                    break;
                }
                case "rm": {
                    if (args.length != 2) {
                        System.out.println("Usage:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar rm foldername\n\n");
                        System.out.println("Example:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar rm myPersonalFolder \n\n");
                        return;
                    }
                    String path = args[1];
                    new Delete(path);
                    break;
                }
                case "put": {
                    if (args.length <= 2 && args.length >= 4) {
                        System.out.println("Usage:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar put URL destinationPath name\n\n");
                        System.out.println("Example:");
                        System.out.println("\tjava -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar put /home/user/Downloads/image.jpg mydir newName \n\n");
                        return;
                    }
                    String fileUrl = args[1];
                    String parentPath = null;
                    if (args.length > 2) {
                        parentPath = args[2];
                    }
                    String name = null;
                    if (args.length > 3) {
                        name = args[3];
                    }
                    new UploadFile(fileUrl, parentPath, name);
                    break;
                }
                case "test": {
                    new Test();
                    break;
                }
                default: {
                    System.out.println("Command not allowed");
                }
            }
        }
        if (args.length < 1) {
            System.err.println("Usage: java -jar home-library-cli-1.0.0-SNAPSHOT-jar-with-dependencies.jar <command>");
            System.err.println("Where <command> is:");
            System.err.println("\tmkdir");
            System.err.println("\tls");
            System.err.println("\trm");
            System.err.println("\tput");
            System.err.println("\ttest");
            System.exit(1);
        }
    }
}

