/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import java.io.Serializable;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.ValueHandlerFactory;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralExpression<T>
extends ExpressionImpl<T>
implements Serializable {
    private Object literal;

    public LiteralExpression(CriteriaBuilderImpl criteriaBuilder, T literal) {
        this(criteriaBuilder, LiteralExpression.determineClass(literal), literal);
    }

    private static Class determineClass(Object literal) {
        return literal == null ? null : literal.getClass();
    }

    public LiteralExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> type, T literal) {
        super(criteriaBuilder, type);
        this.literal = literal;
    }

    public T getLiteral() {
        return (T)this.literal;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        if (ValueHandlerFactory.isNumeric(this.literal)) {
            return ValueHandlerFactory.determineAppropriateHandler(this.literal.getClass()).render(this.literal);
        }
        String parameterName = renderingContext.registerLiteralParameterBinding(this.getLiteral(), this.getJavaType());
        return ':' + parameterName;
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        ValueHandlerFactory.ValueHandler<?> handler = ValueHandlerFactory.determineAppropriateHandler(this.literal.getClass());
        if (ValueHandlerFactory.isCharacter(this.literal)) {
            return '\'' + handler.render(this.literal) + '\'';
        }
        return handler.render(this.literal);
    }

    @Override
    protected void resetJavaType(Class targetType) {
        super.resetJavaType(targetType);
        ValueHandlerFactory.ValueHandler<Object> valueHandler = this.getValueHandler();
        if (valueHandler == null) {
            valueHandler = ValueHandlerFactory.determineAppropriateHandler(targetType);
            this.forceConversion(valueHandler);
        }
        if (valueHandler != null) {
            this.literal = valueHandler.convert(this.literal);
        }
    }
}

