/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.EntityStatistics;

public class ConcurrentEntityStatisticsImpl
extends CategorizedStatistics
implements EntityStatistics {
    private AtomicLong loadCount = new AtomicLong();
    private AtomicLong updateCount = new AtomicLong();
    private AtomicLong insertCount = new AtomicLong();
    private AtomicLong deleteCount = new AtomicLong();
    private AtomicLong fetchCount = new AtomicLong();
    private AtomicLong optimisticFailureCount = new AtomicLong();

    ConcurrentEntityStatisticsImpl(String name) {
        super(name);
    }

    public long getDeleteCount() {
        return this.deleteCount.get();
    }

    public long getInsertCount() {
        return this.insertCount.get();
    }

    public long getLoadCount() {
        return this.loadCount.get();
    }

    public long getUpdateCount() {
        return this.updateCount.get();
    }

    public long getFetchCount() {
        return this.fetchCount.get();
    }

    public long getOptimisticFailureCount() {
        return this.optimisticFailureCount.get();
    }

    public String toString() {
        return new StringBuilder().append("EntityStatistics").append("[loadCount=").append(this.loadCount).append(",updateCount=").append(this.updateCount).append(",insertCount=").append(this.insertCount).append(",deleteCount=").append(this.deleteCount).append(",fetchCount=").append(this.fetchCount).append(",optimisticLockFailureCount=").append(this.optimisticFailureCount).append(']').toString();
    }

    void incrementLoadCount() {
        this.loadCount.getAndIncrement();
    }

    void incrementFetchCount() {
        this.fetchCount.getAndIncrement();
    }

    void incrementUpdateCount() {
        this.updateCount.getAndIncrement();
    }

    void incrementInsertCount() {
        this.insertCount.getAndIncrement();
    }

    void incrementDeleteCount() {
        this.deleteCount.getAndIncrement();
    }

    void incrementOptimisticFailureCount() {
        this.optimisticFailureCount.getAndIncrement();
    }
}

