/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.WrappedMaterializedBlobType;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleValueBinder {
    private Logger log = LoggerFactory.getLogger(SimpleValueBinder.class);
    private String propertyName;
    private String returnedClassName;
    private Ejb3Column[] columns;
    private String persistentClassName;
    private String explicitType = "";
    private Properties typeParameters = new Properties();
    private ExtendedMappings mappings;
    private Table table;
    private SimpleValue simpleValue;
    private boolean isVersion;
    private boolean key;
    private String referencedEntityName;

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void setVersion(boolean isVersion) {
        this.isVersion = isVersion;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setType(XProperty property, XClass returnedClass) {
        String type;
        Properties typeParameters;
        XClass returnedClassOrElement;
        block37: {
            boolean isArray;
            block36: {
                boolean isDate;
                if (returnedClass == null) {
                    return;
                }
                returnedClassOrElement = returnedClass;
                isArray = false;
                if (property.isArray()) {
                    returnedClassOrElement = property.getElementClass();
                    isArray = true;
                }
                typeParameters = this.typeParameters;
                typeParameters.clear();
                type = "";
                if ((this.key || !property.isAnnotationPresent(Temporal.class)) && (!this.key || !property.isAnnotationPresent(MapKeyTemporal.class))) break block36;
                if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Date.class)) {
                    isDate = true;
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Calendar.class)) {
                    isDate = false;
                } else {
                    throw new AnnotationException("@Temporal should only be set on a java.util.Date or java.util.Calendar property: " + StringHelper.qualify(this.persistentClassName, this.propertyName));
                }
                TemporalType temporalType = this.getTemporalType(property);
                switch (temporalType) {
                    case DATE: {
                        type = isDate ? "date" : "calendar_date";
                        break;
                    }
                    case TIME: {
                        type = "time";
                        if (!isDate) {
                            throw new NotYetImplementedException("Calendar cannot persist TIME only" + StringHelper.qualify(this.persistentClassName, this.propertyName));
                        }
                        break block37;
                    }
                    case TIMESTAMP: {
                        type = isDate ? "timestamp" : "calendar";
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unknown temporal type: " + temporalType);
                    }
                }
                break block37;
            }
            if (property.isAnnotationPresent(Lob.class)) {
                if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Clob.class)) {
                    type = "clob";
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Blob.class)) {
                    type = "blob";
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, String.class)) {
                    type = Hibernate.MATERIALIZED_CLOB.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Character.class) && isArray) {
                    type = CharacterArrayClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Character.TYPE) && isArray) {
                    type = PrimitiveCharacterArrayClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Byte.class) && isArray) {
                    type = WrappedMaterializedBlobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Byte.TYPE) && isArray) {
                    type = Hibernate.MATERIALIZED_BLOB.getName();
                } else if (this.mappings.getReflectionManager().toXClass(Serializable.class).isAssignableFrom(returnedClassOrElement)) {
                    type = SerializableToBlobType.class.getName();
                    typeParameters.setProperty("classname", returnedClassOrElement.getName());
                } else {
                    type = "blob";
                }
            }
        }
        if (this.columns == null) {
            throw new AssertionFailure("SimpleValueBinder.setColumns should be set before SimpleValueBinder.setType");
        }
        if ("".equals(type) && returnedClassOrElement.isEnum()) {
            type = org.hibernate.type.EnumType.class.getName();
            typeParameters = new Properties();
            typeParameters.setProperty("enumClass", returnedClassOrElement.getName());
            String schema = this.columns[0].getTable().getSchema();
            schema = schema == null ? "" : schema;
            String catalog = this.columns[0].getTable().getCatalog();
            catalog = catalog == null ? "" : catalog;
            typeParameters.setProperty("schema", schema);
            typeParameters.setProperty("catalog", catalog);
            typeParameters.setProperty("table", this.columns[0].getTable().getName());
            typeParameters.setProperty("column", this.columns[0].getName());
            EnumType enumType = this.getEnumType(property);
            if (enumType != null) {
                if (EnumType.ORDINAL.equals((Object)enumType)) {
                    typeParameters.setProperty("type", String.valueOf(4));
                } else if (EnumType.STRING.equals((Object)enumType)) {
                    typeParameters.setProperty("type", String.valueOf(12));
                } else {
                    throw new AssertionFailure("Unknown EnumType: " + enumType);
                }
            }
        }
        this.explicitType = type;
        this.typeParameters = typeParameters;
        Type annType = property.getAnnotation(Type.class);
        this.setExplicitType(annType);
    }

    private EnumType getEnumType(XProperty property) {
        EnumType enumType = null;
        if (this.key) {
            MapKeyEnumerated enumAnn = property.getAnnotation(MapKeyEnumerated.class);
            if (enumAnn != null) {
                enumType = enumAnn.value();
            }
        } else {
            Enumerated enumAnn = property.getAnnotation(Enumerated.class);
            if (enumAnn != null) {
                enumType = enumAnn.value();
            }
        }
        return enumType;
    }

    private TemporalType getTemporalType(XProperty property) {
        if (this.key) {
            MapKeyTemporal ann = property.getAnnotation(MapKeyTemporal.class);
            return ann.value();
        }
        Temporal ann = property.getAnnotation(Temporal.class);
        return ann.value();
    }

    public void setExplicitType(String explicitType) {
        this.explicitType = explicitType;
    }

    public void setExplicitType(Type typeAnn) {
        if (typeAnn != null) {
            this.explicitType = typeAnn.type();
            this.typeParameters.clear();
            for (Parameter param : typeAnn.parameters()) {
                this.typeParameters.setProperty(param.name(), param.value());
            }
        }
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public SimpleValue make() {
        this.validate();
        this.log.debug("building SimpleValue for {}", (Object)this.propertyName);
        if (this.table == null) {
            this.table = this.columns[0].getTable();
        }
        this.simpleValue = new SimpleValue(this.table);
        this.linkWithValue();
        boolean isInSecondPass = this.mappings.isInSecondPass();
        SetSimpleValueTypeSecondPass secondPass = new SetSimpleValueTypeSecondPass(this);
        if (!isInSecondPass) {
            this.mappings.addSecondPass(secondPass);
        } else {
            this.fillSimpleValue();
        }
        return this.simpleValue;
    }

    public void linkWithValue() {
        if (this.columns[0].isNameDeferred() && !this.mappings.isInSecondPass() && this.referencedEntityName != null) {
            this.mappings.addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, (Ejb3JoinColumn[])this.columns, this.simpleValue));
        } else {
            for (Ejb3Column column : this.columns) {
                column.linkWithValue(this.simpleValue);
            }
        }
    }

    public void fillSimpleValue() {
        this.log.debug("setting SimpleValue typeName for {}", (Object)this.propertyName);
        String type = BinderHelper.isDefault(this.explicitType) ? this.returnedClassName : this.explicitType;
        TypeDef typeDef = this.mappings.getTypeDef(type);
        if (typeDef != null) {
            type = typeDef.getTypeClass();
            this.simpleValue.setTypeParameters(typeDef.getParameters());
        }
        if (this.typeParameters != null && this.typeParameters.size() != 0) {
            this.simpleValue.setTypeParameters(this.typeParameters);
        }
        this.simpleValue.setTypeName(type);
        if (this.persistentClassName != null) {
            this.simpleValue.setTypeUsingReflection(this.persistentClassName, this.propertyName);
        }
        if (!this.simpleValue.isTypeSpecified() && this.isVersion()) {
            this.simpleValue.setTypeName("integer");
        }
    }

    public void setKey(boolean key) {
        this.key = key;
    }
}

