/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.junit.functional;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.classic.Session;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.junit.UnitTestCase;
import org.hibernate.junit.functional.ExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FunctionalTestCase
extends UnitTestCase
implements ExecutionEnvironment.Settings {
    private static final Logger log = LoggerFactory.getLogger(FunctionalTestCase.class);
    private ExecutionEnvironment environment;
    private boolean isEnvironmentLocallyManaged;
    private Session session;

    public FunctionalTestCase(String string) {
        super(string);
    }

    public ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ExecutionEnvironment environment) {
        this.environment = environment;
    }

    protected void prepareTest() throws Exception {
    }

    protected void cleanupTest() throws Exception {
    }

    protected final void setUp() throws Exception {
        if (this.environment == null) {
            log.info("Building locally managed execution env");
            this.isEnvironmentLocallyManaged = true;
            this.environment = new ExecutionEnvironment(this);
            this.environment.initialize();
        }
        this.prepareTest();
    }

    protected final void tearDown() throws Exception {
        this.cleanupTest();
        if (this.isEnvironmentLocallyManaged) {
            log.info("Destroying locally managed execution env");
            this.environment.complete();
            this.environment = null;
        }
    }

    protected void runTest() throws Throwable {
        boolean stats = this.sfi().getStatistics().isStatisticsEnabled();
        try {
            if (stats) {
                this.sfi().getStatistics().clear();
            }
            super.runTest();
            if (stats) {
                this.sfi().getStatistics().logSummary();
            }
            if (this.session != null && this.session.isOpen()) {
                if (this.session.isConnected()) {
                    this.session.connection().rollback();
                }
                this.session.close();
                this.session = null;
                FunctionalTestCase.fail((String)"unclosed session");
            } else {
                this.session = null;
            }
            this.assertAllDataRemoved();
        }
        catch (Throwable e) {
            log.trace("test run resulted in error; attempting to cleanup", e);
            try {
                if (this.session != null && this.session.isOpen()) {
                    if (this.session.isConnected()) {
                        this.session.connection().rollback();
                    }
                    this.session.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (this.recreateSchemaAfterFailure() && this.environment != null) {
                    this.environment.rebuild();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAllDataRemoved() {
        if (!this.createSchema()) {
            return;
        }
        if (!Boolean.getBoolean("hibernate.test.validateDataCleanup")) {
            return;
        }
        Session tmpSession = this.getSessions().openSession();
        try {
            List list = tmpSession.createQuery("select o from java.lang.Object o").list();
            HashMap<String, Integer> items = new HashMap<String, Integer>();
            if (!list.isEmpty()) {
                for (Object element : list) {
                    Integer l = (Integer)items.get(tmpSession.getEntityName(element));
                    if (l == null) {
                        l = new Integer(0);
                    }
                    l = new Integer(l + 1);
                    items.put(tmpSession.getEntityName(element), l);
                    System.out.println("Data left: " + element);
                }
                FunctionalTestCase.fail((String)("Data is left in the database: " + ((Object)items).toString()));
            }
        }
        finally {
            try {
                tmpSession.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void skipExpectedFailure(Throwable error) {
        super.skipExpectedFailure(error);
        try {
            if (this.recreateSchemaAfterFailure() && this.environment != null) {
                this.environment.rebuild();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBaseForMappings() {
        return "org/hibernate/test/";
    }

    public boolean createSchema() {
        return true;
    }

    public boolean recreateSchemaAfterFailure() {
        return true;
    }

    public void configure(Configuration cfg) {
    }

    public boolean overrideCacheStrategy() {
        return true;
    }

    public String getCacheConcurrencyStrategy() {
        return "nonstrict-read-write";
    }

    public void afterSessionFactoryBuilt(SessionFactoryImplementor sfi) {
    }

    public void afterConfigurationBuilt(Mappings mappings, Dialect dialect) {
    }

    public boolean appliesTo(Dialect dialect) {
        return true;
    }

    protected SessionFactory getSessions() {
        return this.environment.getSessionFactory();
    }

    protected SessionFactoryImplementor sfi() {
        return (SessionFactoryImplementor)this.getSessions();
    }

    protected Dialect getDialect() {
        return ExecutionEnvironment.DIALECT;
    }

    protected Configuration getCfg() {
        return this.environment.getConfiguration();
    }

    public Session openSession() throws HibernateException {
        this.session = this.getSessions().openSession();
        return this.session;
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.getSessions().openSession(interceptor);
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSerializableIsolationEnforced() throws Exception {
        Connection conn = null;
        try {
            conn = this.sfi().getConnectionProvider().getConnection();
            boolean bl = conn.getTransactionIsolation() >= 8;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    this.sfi().getConnectionProvider().closeConnection(conn);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readCommittedIsolationMaintained(String scenario) {
        int isolation = 1;
        Session testSession = null;
        try {
            testSession = this.openSession();
            isolation = testSession.connection().getTransactionIsolation();
        }
        catch (Throwable ignore) {
        }
        finally {
            if (testSession != null) {
                try {
                    testSession.close();
                }
                catch (Throwable ignore) {}
            }
        }
        if (isolation < 2) {
            this.reportSkip("environment does not support at least read committed isolation", scenario);
            return false;
        }
        return true;
    }

    protected boolean allowsPhysicalColumnNameInOrderby(String testDescription) {
        if (DB2Dialect.class.isInstance(this.getDialect())) {
            this.reportSkip("Dialect does not support physical column name in order-by clause after it is aliased", testDescription);
            return false;
        }
        return true;
    }

    protected boolean allowsPhysicalColumnNameInHaving(String testDescription) {
        if (DerbyDialect.class.isInstance(this.getDialect())) {
            this.reportSkip("Dialect does not support physical column name in having clause after it is aliased", testDescription);
            return false;
        }
        return true;
    }

    protected boolean dialectSupportsEmptyInList(String testDescription) {
        if (!this.getDialect().supportsEmptyInList()) {
            this.reportSkip("Dialect does not support SQL empty in list : x in ()", testDescription);
            return false;
        }
        return true;
    }

    protected boolean dialectIsCaseSensitive(String testDescription) {
        if (!this.getDialect().areStringComparisonsCaseInsensitive()) {
            this.reportSkip("Dialect is case sensitive. ", testDescription);
            return true;
        }
        return false;
    }

    protected boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        if (!this.getDialect().supportsResultSetPositionQueryMethodsOnForwardOnlyCursor()) {
            this.reportSkip("Driver does not support 'position query' methods on forward-only cursors", "query support");
            return false;
        }
        return true;
    }

    protected boolean supportsCircularCascadeDelete() {
        if (!this.getDialect().supportsCircularCascadeDeleteConstraints()) {
            this.reportSkip("db/dialect does not support 'circular' cascade delete constraints", "cascade delete constraint support");
            return false;
        }
        return true;
    }

    protected boolean supportsSubselectOnLeftSideIn() {
        if (!this.getDialect().supportsSubselectAsInPredicateLHS()) {
            this.reportSkip("Database does not support (<subselect>) in ( ... ) ", "query support");
            return false;
        }
        return true;
    }

    protected boolean supportsExpectedLobUsagePattern() {
        if (!this.getDialect().supportsExpectedLobUsagePattern()) {
            this.reportSkip("database/driver does not support expected LOB usage pattern", "LOB support");
            return false;
        }
        return true;
    }

    protected boolean supportsLobValueChangePropogation() {
        if (!this.getDialect().supportsLobValueChangePropogation()) {
            this.reportSkip("database/driver does not support propogating LOB value change back to database", "LOB support");
            return false;
        }
        return true;
    }

    protected boolean supportsUnboundedLobLocatorMaterialization() {
        if (!this.getDialect().supportsUnboundedLobLocatorMaterialization()) {
            this.reportSkip("database/driver does not support materializing a LOB locator outside the 'owning' transaction", "LOB support");
            return false;
        }
        return true;
    }

    protected boolean supportsSubqueryOnMutatingTable() {
        if (!this.getDialect().supportsSubqueryOnMutatingTable()) {
            this.reportSkip("database/driver does not support referencing mutating table in subquery", "bulk DML support");
            return false;
        }
        return true;
    }

    protected boolean dialectIs(Class dialectClass) {
        return dialectClass.isInstance(this.getDialect());
    }

    protected boolean dialectIsOneOf(Class[] dialectClasses) {
        for (int i = 0; i < dialectClasses.length; ++i) {
            if (!dialectClasses[i].isInstance(this.getDialect())) continue;
            return true;
        }
        return false;
    }

    protected boolean dialectIsNot(Class dialectClass) {
        return !this.dialectIs(dialectClass);
    }

    protected boolean dialectIsNot(Class[] dialectClasses) {
        return !this.dialectIsOneOf(dialectClasses);
    }
}

