/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.hibernate.cache.infinispan.util.AddressAdapter;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheHelper {
    private static final Log log = LogFactory.getLog(CacheHelper.class);

    private CacheHelper() {
    }

    public static void initInternalEvict(CacheAdapter cacheAdapter, AddressAdapter member) {
        EvictAll eKey = new EvictAll(member == null ? NoAddress.INSTANCE : member);
        cacheAdapter.withFlags(FlagAdapter.CACHE_MODE_LOCAL).put(eKey, (Object)Internal.INIT);
    }

    public static void sendEvictAllNotification(CacheAdapter cacheAdapter, AddressAdapter member) {
        EvictAll eKey = new EvictAll(member == null ? NoAddress.INSTANCE : member);
        cacheAdapter.put(eKey, (Object)Internal.EVICT);
    }

    public static boolean isEvictAllNotification(Object key) {
        return key instanceof EvictAll;
    }

    public static boolean containsEvictAllNotification(Set keySet, AddressAdapter member) {
        EvictAll eKey = new EvictAll(member == null ? NoAddress.INSTANCE : member);
        return keySet.contains(eKey);
    }

    public static boolean isEvictAllNotification(Object key, Object value) {
        return key instanceof EvictAll && value == Internal.EVICT;
    }

    private static enum Internal {
        INIT,
        EVICT;

    }

    private static enum NoAddress implements AddressAdapter
    {
        INSTANCE;

    }

    private static class EvictAll
    implements Externalizable {
        AddressAdapter member;

        EvictAll(AddressAdapter member) {
            this.member = member;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EvictAll)) {
                return false;
            }
            EvictAll ek = (EvictAll)obj;
            return ek.member.equals(this.member);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.member.hashCode();
            return result;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.member = (AddressAdapter)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.member);
        }
    }
}

